/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;

public class MatchAllFilterOperator
extends BaseFilterOperator {
    public static final String EXPLAIN_NAME = "FILTER_MATCH_ENTIRE_SEGMENT";
    private final int _numDocs;

    public MatchAllFilterOperator(int numDocs) {
        this._numDocs = numDocs;
    }

    @Override
    public final boolean isResultMatchingAll() {
        return true;
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new MatchAllDocIdSet(this._numDocs));
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        return this._numDocs;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME + "(docs:" + this._numDocs + ')';
    }
}

