/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.spi.trace.FilterType;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RangeIndexBasedFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_RANGE_INDEX";
    private final RangeEvaluator _rangeEvaluator;
    private final PredicateEvaluator _rangePredicateEvaluator;
    private final DataSource _dataSource;
    private final int _numDocs;

    public RangeIndexBasedFilterOperator(PredicateEvaluator rangePredicateEvaluator, DataSource dataSource, int numDocs) {
        this._rangePredicateEvaluator = rangePredicateEvaluator;
        this._rangeEvaluator = RangeEvaluator.of((RangeIndexReader<ImmutableRoaringBitmap>)dataSource.getRangeIndex(), rangePredicateEvaluator);
        this._dataSource = dataSource;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._rangeEvaluator.isExact()) {
            ImmutableRoaringBitmap matches = this._rangeEvaluator.getMatchingDocIds();
            this.recordFilter(matches);
            return new FilterBlock(new BitmapDocIdSet(matches, this._numDocs));
        }
        return this.evaluateLegacyRangeFilter();
    }

    private FilterBlock evaluateLegacyRangeFilter() {
        ImmutableRoaringBitmap matches = this._rangeEvaluator.getMatchingDocIds();
        ImmutableRoaringBitmap partialMatches = this._rangeEvaluator.getPartiallyMatchingDocIds();
        if (partialMatches == null) {
            return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)(matches == null ? new MutableRoaringBitmap() : matches), this._numDocs));
        }
        ScanBasedFilterOperator scanBasedFilterOperator = new ScanBasedFilterOperator(this._rangePredicateEvaluator, this._dataSource, this._numDocs, false);
        final FilterBlockDocIdSet scanBasedDocIdSet = scanBasedFilterOperator.getNextBlock().getBlockDocIdSet();
        MutableRoaringBitmap docIds = ((ScanBasedDocIdIterator)scanBasedDocIdSet.iterator()).applyAnd(partialMatches);
        if (matches != null) {
            docIds.or(matches);
        }
        this.recordFilter(matches);
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)docIds, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return scanBasedDocIdSet.getNumEntriesScannedInFilter();
            }
        });
    }

    @Override
    public boolean canOptimizeCount() {
        return this._rangeEvaluator.isExact();
    }

    @Override
    public int getNumMatchingDocs() {
        return this._rangeEvaluator.getNumMatchingDocs();
    }

    @Override
    public boolean canProduceBitmaps() {
        return this._rangeEvaluator.isExact();
    }

    @Override
    public BitmapCollection getBitmaps() {
        return new BitmapCollection(this._numDocs, false, this._rangeEvaluator.getMatchingDocIds());
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        return "FILTER_RANGE_INDEX(indexLookUp:range_index,operator:" + this._rangePredicateEvaluator.getPredicateType() + ",predicate:" + this._rangePredicateEvaluator.getPredicate().toString() + ")";
    }

    private void recordFilter(ImmutableRoaringBitmap bitmap) {
        InvocationRecording recording = Tracing.activeRecording();
        if (recording.isEnabled()) {
            recording.setNumDocsMatchingAfterFilter(bitmap == null ? 0 : bitmap.getCardinality());
            recording.setColumnName(this._dataSource.getDataSourceMetadata().getFieldSpec().getName());
            recording.setFilter(FilterType.INDEX, this._rangePredicateEvaluator.getPredicateType().name());
            recording.setNumDocsScanned(this._numDocs);
        }
    }

    private static final class DoubleRangeEvaluator
    implements RangeEvaluator {
        final RangeIndexReader<ImmutableRoaringBitmap> _rangeIndexReader;
        final double _min;
        final double _max;

        DoubleRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator predicateEvaluator) {
            this._rangeIndexReader = rangeIndexReader;
            this._min = predicateEvaluator.getInclusiveLowerBound();
            this._max = predicateEvaluator.getInclusiveUpperBound();
        }

        @Override
        public ImmutableRoaringBitmap getMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(this._min, this._max);
        }

        @Override
        public ImmutableRoaringBitmap getPartiallyMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(this._min, this._max);
        }

        @Override
        public int getNumMatchingDocs() {
            return this._rangeIndexReader.getNumMatchingDocs(this._min, this._max);
        }

        @Override
        public boolean isExact() {
            return this._rangeIndexReader.isExact();
        }
    }

    private static final class FloatRangeEvaluator
    implements RangeEvaluator {
        final RangeIndexReader<ImmutableRoaringBitmap> _rangeIndexReader;
        final float _min;
        final float _max;

        FloatRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator predicateEvaluator) {
            this._rangeIndexReader = rangeIndexReader;
            this._min = predicateEvaluator.getInclusiveLowerBound();
            this._max = predicateEvaluator.getInclusiveUpperBound();
        }

        @Override
        public ImmutableRoaringBitmap getMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(this._min, this._max);
        }

        @Override
        public ImmutableRoaringBitmap getPartiallyMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(this._min, this._max);
        }

        @Override
        public int getNumMatchingDocs() {
            return this._rangeIndexReader.getNumMatchingDocs(this._min, this._max);
        }

        @Override
        public boolean isExact() {
            return this._rangeIndexReader.isExact();
        }
    }

    private static final class LongRangeEvaluator
    implements RangeEvaluator {
        final RangeIndexReader<ImmutableRoaringBitmap> _rangeIndexReader;
        final long _min;
        final long _max;

        LongRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator predicateEvaluator) {
            this._rangeIndexReader = rangeIndexReader;
            this._min = predicateEvaluator.getInclusiveLowerBound();
            this._max = predicateEvaluator.getInclusiveUpperBound();
        }

        @Override
        public ImmutableRoaringBitmap getMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(this._min, this._max);
        }

        @Override
        public ImmutableRoaringBitmap getPartiallyMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(this._min, this._max);
        }

        @Override
        public int getNumMatchingDocs() {
            return this._rangeIndexReader.getNumMatchingDocs(this._min, this._max);
        }

        @Override
        public boolean isExact() {
            return this._rangeIndexReader.isExact();
        }
    }

    private static final class IntRangeEvaluator
    implements RangeEvaluator {
        final RangeIndexReader<ImmutableRoaringBitmap> _rangeIndexReader;
        final int _min;
        final int _max;

        private IntRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, int min, int max) {
            this._rangeIndexReader = rangeIndexReader;
            this._min = min;
            this._max = max;
        }

        IntRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator predicateEvaluator) {
            this(rangeIndexReader, predicateEvaluator.getInclusiveLowerBound(), predicateEvaluator.getInclusiveUpperBound());
        }

        IntRangeEvaluator(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator predicateEvaluator) {
            this(rangeIndexReader, predicateEvaluator.getStartDictId(), predicateEvaluator.getEndDictId() - 1);
        }

        @Override
        public ImmutableRoaringBitmap getMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getMatchingDocIds(this._min, this._max);
        }

        @Override
        public ImmutableRoaringBitmap getPartiallyMatchingDocIds() {
            return (ImmutableRoaringBitmap)this._rangeIndexReader.getPartiallyMatchingDocIds(this._min, this._max);
        }

        @Override
        public int getNumMatchingDocs() {
            return this._rangeIndexReader.getNumMatchingDocs(this._min, this._max);
        }

        @Override
        public boolean isExact() {
            return this._rangeIndexReader.isExact();
        }
    }

    static interface RangeEvaluator {
        public static RangeEvaluator of(RangeIndexReader<ImmutableRoaringBitmap> rangeIndexReader, PredicateEvaluator predicateEvaluator) {
            if (predicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
                return new IntRangeEvaluator(rangeIndexReader, (RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)predicateEvaluator);
            }
            switch (predicateEvaluator.getDataType()) {
                case INT: {
                    return new IntRangeEvaluator(rangeIndexReader, (RangePredicateEvaluatorFactory.IntRawValueBasedRangePredicateEvaluator)predicateEvaluator);
                }
                case LONG: {
                    return new LongRangeEvaluator(rangeIndexReader, (RangePredicateEvaluatorFactory.LongRawValueBasedRangePredicateEvaluator)predicateEvaluator);
                }
                case FLOAT: {
                    return new FloatRangeEvaluator(rangeIndexReader, (RangePredicateEvaluatorFactory.FloatRawValueBasedRangePredicateEvaluator)predicateEvaluator);
                }
                case DOUBLE: {
                    return new DoubleRangeEvaluator(rangeIndexReader, (RangePredicateEvaluatorFactory.DoubleRawValueBasedRangePredicateEvaluator)predicateEvaluator);
                }
            }
            throw new IllegalStateException("String and Bytes data type not supported for Range Indexing");
        }

        public ImmutableRoaringBitmap getMatchingDocIds();

        public ImmutableRoaringBitmap getPartiallyMatchingDocIds();

        public int getNumMatchingDocs();

        public boolean isExact();
    }
}

