/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.math.BigDecimal;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.BaseInPredicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.TimestampUtils;

public class PredicateUtils {
    private static final int MAX_INITIAL_DICT_ID_SET_SIZE = 1000;

    private PredicateUtils() {
    }

    public static String getStoredValue(String value, FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return PredicateUtils.getStoredBooleanValue(value);
            }
            case TIMESTAMP: {
                return PredicateUtils.getStoredTimestampValue(value);
            }
        }
        return value;
    }

    public static String getStoredBooleanValue(String booleanValue) {
        return Integer.toString(BooleanUtils.toInt((String)booleanValue));
    }

    public static String getStoredTimestampValue(String timestampValue) {
        return Long.toString(TimestampUtils.toMillisSinceEpoch((String)timestampValue));
    }

    public static IntSet getDictIdSet(BaseInPredicate inPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        List values = inPredicate.getValues();
        int hashSetSize = Integer.min(HashUtil.getMinHashSetSize((int)values.size()), 1000);
        IntOpenHashSet dictIdSet = new IntOpenHashSet(hashSetSize);
        switch (dataType) {
            case INT: {
                int[] intValues;
                for (int value : intValues = inPredicate.getIntValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case LONG: {
                long[] longValues;
                for (long value : longValues = inPredicate.getLongValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues;
                for (float value : floatValues = inPredicate.getFloatValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues;
                for (double value : doubleValues = inPredicate.getDoubleValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues;
                for (BigDecimal value : bigDecimalValues = inPredicate.getBigDecimalValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case BOOLEAN: {
                int[] booleanValues;
                for (int value : booleanValues = inPredicate.getBooleanValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case TIMESTAMP: {
                long[] timestampValues;
                for (long value : timestampValues = inPredicate.getTimestampValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case STRING: {
                for (String value : values) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            case BYTES: {
                ByteArray[] bytesValues;
                for (ByteArray value : bytesValues = inPredicate.getBytesValues()) {
                    int dictId = dictionary.indexOf(value);
                    if (dictId < 0) continue;
                    dictIdSet.add(dictId);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType);
            }
        }
        return dictIdSet;
    }
}

