/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOnlyOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT";
    private final IndexSegment _indexSegment;
    private final boolean _nullHandlingEnabled;
    private final TransformOperator _transformOperator;
    private final List<ExpressionContext> _expressions;
    private final BlockValSet[] _blockValSets;
    private final DataSchema _dataSchema;
    private final int _numRowsToKeep;
    private final List<Object[]> _rows;
    private final RoaringBitmap[] _nullBitmaps;
    private int _numDocsScanned = 0;

    public SelectionOnlyOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._transformOperator = transformOperator;
        this._expressions = expressions;
        int numExpressions = this._expressions.size();
        this._blockValSets = new BlockValSet[numExpressions];
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            TransformResultMetadata expressionMetadata = this._transformOperator.getResultMetadata(expression);
            columnNames[i] = expression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._numRowsToKeep = queryContext.getLimit();
        this._rows = new ArrayList<Object[]>(Math.min(this._numRowsToKeep, 10000));
        this._nullBitmaps = this._nullHandlingEnabled ? new RoaringBitmap[numExpressions] : null;
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(selectList:");
        if (!this._expressions.isEmpty()) {
            stringBuilder.append(this._expressions.get(0));
            for (int i = 1; i < this._expressions.size(); ++i) {
                stringBuilder.append(", ").append(this._expressions.get(i));
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            int i;
            int numExpressions = this._expressions.size();
            for (int i2 = 0; i2 < numExpressions; ++i2) {
                this._blockValSets[i2] = transformBlock.getBlockValueSet(this._expressions.get(i2));
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(this._blockValSets);
            int numDocsToAdd = Math.min(this._numRowsToKeep - this._rows.size(), transformBlock.getNumDocs());
            this._numDocsScanned += numDocsToAdd;
            if (this._nullHandlingEnabled) {
                for (i = 0; i < numExpressions; ++i) {
                    this._nullBitmaps[i] = this._blockValSets[i].getNullBitmap();
                }
                for (int docId = 0; docId < numDocsToAdd; ++docId) {
                    Object[] values = blockValueFetcher.getRow(docId);
                    for (int colId = 0; colId < numExpressions; ++colId) {
                        if (this._nullBitmaps[colId] == null || !this._nullBitmaps[colId].contains(docId)) continue;
                        values[colId] = null;
                    }
                    this._rows.add(values);
                }
            } else {
                for (i = 0; i < numDocsToAdd; ++i) {
                    this._rows.add(blockValueFetcher.getRow(i));
                }
            }
            if (this._rows.size() != this._numRowsToKeep) continue;
            break;
        }
        return new IntermediateResultsBlock(this._dataSchema, this._rows, this._nullHandlingEnabled);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }
}

