/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.function.SelectTupleElementTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class GreatestTransformFunction
extends SelectTupleElementTransformFunction {
    public GreatestTransformFunction() {
        super(TransformFunctionType.GREATEST.getName());
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesSV == null || this._intValuesSV.length < numDocs) {
            this._intValuesSV = new int[numDocs];
        }
        int[] values = ((TransformFunction)this._arguments.get(0)).transformToIntValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._intValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToIntValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._intValuesSV[j] = Math.max(this._intValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._longValuesSV == null || this._longValuesSV.length < numDocs) {
            this._longValuesSV = new long[numDocs];
        }
        long[] values = ((TransformFunction)this._arguments.get(0)).transformToLongValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._longValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToLongValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._longValuesSV[j] = Math.max(this._longValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null || this._floatValuesSV.length < numDocs) {
            this._floatValuesSV = new float[numDocs];
        }
        float[] values = ((TransformFunction)this._arguments.get(0)).transformToFloatValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._floatValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToFloatValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._floatValuesSV[j] = Math.max(this._floatValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < numDocs) {
            this._doubleValuesSV = new double[numDocs];
        }
        double[] values = ((TransformFunction)this._arguments.get(0)).transformToDoubleValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._doubleValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToDoubleValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._doubleValuesSV[j] = Math.max(this._doubleValuesSV[j], values[j]);
                ++j;
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null || this._bigDecimalValuesSV.length < numDocs) {
            this._bigDecimalValuesSV = new BigDecimal[numDocs];
        }
        BigDecimal[] values = ((TransformFunction)this._arguments.get(0)).transformToBigDecimalValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._bigDecimalValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToBigDecimalValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                this._bigDecimalValuesSV[j] = this._bigDecimalValuesSV[j].max(values[j]);
                ++j;
            }
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null || this._stringValuesSV.length < numDocs) {
            this._stringValuesSV = new String[numDocs];
        }
        String[] values = ((TransformFunction)this._arguments.get(0)).transformToStringValuesSV(projectionBlock);
        System.arraycopy(values, 0, this._stringValuesSV, 0, numDocs);
        for (int i = 1; i < this._arguments.size(); ++i) {
            values = ((TransformFunction)this._arguments.get(i)).transformToStringValuesSV(projectionBlock);
            int j = 0;
            while (j < numDocs & j < values.length) {
                if (this._stringValuesSV[j].compareTo(values[j]) < 0) {
                    this._stringValuesSV[j] = values[j];
                }
                ++j;
            }
        }
        return this._stringValuesSV;
    }
}

