/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.JsonPathCache;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.PushDownTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.evaluator.TransformEvaluator;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluator;
import org.apache.pinot.segment.spi.evaluator.json.JsonPathEvaluators;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonExtractScalarTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractScalar";
    private static final ObjectMapper OBJECT_MAPPER_WITH_BIG_DECIMAL = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final ParseContext JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider(OBJECT_MAPPER_WITH_BIG_DECIMAL)).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)new Configuration.ConfigurationBuilder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPathString;
    private JsonPath _jsonPath;
    private Object _defaultValue;
    private JsonPathEvaluator _jsonPathEvaluator;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 3 || arguments.size() > 4) {
            throw new IllegalArgumentException("Expected 3/4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractScalar transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPathString = ((LiteralTransformFunction)arguments.get(1)).getLiteral();
        String resultsType = ((LiteralTransformFunction)arguments.get(2)).getLiteral().toUpperCase();
        boolean isSingleValue = !resultsType.endsWith("_ARRAY");
        try {
            FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)(isSingleValue ? resultsType : resultsType.substring(0, resultsType.length() - 6)));
            if (arguments.size() == 4) {
                this._defaultValue = dataType.convert(((LiteralTransformFunction)arguments.get(3)).getLiteral());
            }
            this._resultMetadata = new TransformResultMetadata(dataType, isSingleValue, false);
            this._jsonPathEvaluator = JsonPathEvaluators.create((String)this._jsonPathString, (Object)this._defaultValue);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unsupported results type: %s for jsonExtractScalar function. Supported types are: INT/LONG/FLOAT/DOUBLE/BOOLEAN/BIG_DECIMAL/TIMESTAMP/STRING/INT_ARRAY/LONG_ARRAY/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", resultsType));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesSV == null || this._intValuesSV.length < numDocs) {
            this._intValuesSV = new int[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToIntValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._intValuesSV);
            return this._intValuesSV;
        }
        return this.transformTransformedValuesToIntValuesSV(projectionBlock);
    }

    private int[] transformTransformedValuesToIntValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._intValuesSV[i] = (Integer)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._intValuesSV[i] = result instanceof Number ? ((Number)result).intValue() : Integer.parseInt(result.toString());
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._longValuesSV == null || this._longValuesSV.length < numDocs) {
            this._longValuesSV = new long[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToLongValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._longValuesSV);
            return this._longValuesSV;
        }
        return this.transformTransformedValuesToLongValuesSV(projectionBlock);
    }

    private long[] transformTransformedValuesToLongValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._longValuesSV[i] = (Long)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._longValuesSV[i] = result instanceof Number ? ((Number)result).longValue() : (long)Double.parseDouble(result.toString());
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null || this._floatValuesSV.length < numDocs) {
            this._floatValuesSV = new float[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToFloatValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._floatValuesSV);
            return this._floatValuesSV;
        }
        return this.transformTransformedValuesToFloatValuesSV(projectionBlock);
    }

    private float[] transformTransformedValuesToFloatValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._floatValuesSV[i] = ((Float)this._defaultValue).floatValue();
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._floatValuesSV[i] = result instanceof Number ? ((Number)result).floatValue() : Float.parseFloat(result.toString());
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < numDocs) {
            this._doubleValuesSV = new double[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToDoubleValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._doubleValuesSV);
            return this._doubleValuesSV;
        }
        return this.transformTransformedValuesToDoubleValuesSV(projectionBlock);
    }

    private double[] transformTransformedValuesToDoubleValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._doubleValuesSV[i] = (Double)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._doubleValuesSV[i] = result instanceof Number ? ((Number)result).doubleValue() : Double.parseDouble(result.toString());
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null || this._bigDecimalValuesSV.length < numDocs) {
            this._bigDecimalValuesSV = new BigDecimal[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToBigDecimalValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._bigDecimalValuesSV);
            return this._bigDecimalValuesSV;
        }
        return this.transformTransformedValuesToBigDecimalValuesSV(projectionBlock);
    }

    private BigDecimal[] transformTransformedValuesToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._bigDecimalValuesSV[i] = (BigDecimal)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._bigDecimalValuesSV[i] = result instanceof Number ? (BigDecimal)result : new BigDecimal(result.toString());
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null || this._stringValuesSV.length < numDocs) {
            this._stringValuesSV = new String[numDocs];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToStringValuesSV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._stringValuesSV);
            return this._stringValuesSV;
        }
        return this.transformTransformedValuesToStringValuesSV(projectionBlock);
    }

    private String[] transformTransformedValuesToStringValuesSV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT_WITH_BIG_DECIMAL.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._stringValuesSV[i] = (String)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPathString, jsonStrings[i]));
            }
            this._stringValuesSV[i] = result instanceof String ? (String)result : JsonUtils.objectToJsonNode((Object)result).toString();
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesMV == null || this._intValuesMV.length < numDocs) {
            this._intValuesMV = new int[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToIntValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._intValuesMV);
            return this._intValuesMV;
        }
        return this.transformTransformedValuesToIntValuesMV(projectionBlock);
    }

    private int[][] transformTransformedValuesToIntValuesMV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._intValuesMV[i] = new int[0];
                continue;
            }
            int numValues = result.size();
            int[] values = new int[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Integer)result.get(j);
            }
            this._intValuesMV[i] = values;
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._longValuesMV == null || this._longValuesMV.length < numDocs) {
            this._longValuesMV = new long[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToLongValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._longValuesMV);
            return this._longValuesMV;
        }
        return this.transformTransformedValuesToLongValuesMV(projectionBlock);
    }

    private long[][] transformTransformedValuesToLongValuesMV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._longValuesMV[i] = new long[0];
                continue;
            }
            int numValues = result.size();
            long[] values = new long[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Long)result.get(j);
            }
            this._longValuesMV[i] = values;
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._floatValuesMV == null || this._floatValuesMV.length < numDocs) {
            this._floatValuesMV = new float[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToFloatValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._floatValuesMV);
            return this._floatValuesMV;
        }
        return this.transformTransformedValuesToFloatValuesMV(projectionBlock);
    }

    private float[][] transformTransformedValuesToFloatValuesMV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._floatValuesMV[i] = new float[0];
                continue;
            }
            int numValues = result.size();
            float[] values = new float[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = ((Float)result.get(j)).floatValue();
            }
            this._floatValuesMV[i] = values;
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._doubleValuesMV == null || this._doubleValuesMV.length < numDocs) {
            this._doubleValuesMV = new double[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToDoubleValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._doubleValuesMV);
            return this._doubleValuesMV;
        }
        return this.transformTransformedToDoubleValuesMV(projectionBlock);
    }

    private double[][] transformTransformedToDoubleValuesMV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        int numDocs = projectionBlock.getNumDocs();
        if (this._doubleValuesMV == null || this._doubleValuesMV.length < numDocs) {
            this._doubleValuesMV = new double[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToDoubleValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._doubleValuesMV);
            return this._doubleValuesMV;
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._doubleValuesMV[i] = new double[0];
                continue;
            }
            int numValues = result.size();
            double[] values = new double[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Double)result.get(j);
            }
            this._doubleValuesMV[i] = values;
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._stringValuesMV == null || this._stringValuesMV.length < numDocs) {
            this._stringValuesMV = new String[numDocs][];
        }
        if (this._jsonFieldTransformFunction instanceof PushDownTransformFunction) {
            ((PushDownTransformFunction)((Object)this._jsonFieldTransformFunction)).transformToStringValuesMV(projectionBlock, (TransformEvaluator)this._jsonPathEvaluator, this._stringValuesMV);
            return this._stringValuesMV;
        }
        return this.transformTransformedValuesToStringValuesMV(projectionBlock);
    }

    private String[][] transformTransformedValuesToStringValuesMV(ProjectionBlock projectionBlock) {
        this.ensureJsonPathCompiled();
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._stringValuesMV[i] = new String[0];
                continue;
            }
            int numValues = result.size();
            String[] values = new String[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (String)result.get(j);
            }
            this._stringValuesMV[i] = values;
        }
        return this._stringValuesMV;
    }

    private void ensureJsonPathCompiled() {
        if (this._jsonPath == null) {
            this._jsonPath = JsonPathCache.INSTANCE.getOrCompute(this._jsonPathString);
        }
    }
}

