/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ModuloTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "mod";
    private double _firstLiteral;
    private TransformFunction _firstTransformFunction;
    private double _secondLiteral;
    private TransformFunction _secondTransformFunction;
    private double[] _modulos;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for MOD transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction) {
            this._firstLiteral = Double.parseDouble(((LiteralTransformFunction)firstArgument).getLiteral());
        } else {
            if (!firstArgument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("First argument of MOD transform function must be single-valued");
            }
            this._firstTransformFunction = firstArgument;
        }
        TransformFunction secondArgument = arguments.get(1);
        if (secondArgument instanceof LiteralTransformFunction) {
            this._secondLiteral = Double.parseDouble(((LiteralTransformFunction)secondArgument).getLiteral());
        } else {
            if (!secondArgument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("Second argument of MOD transform function must be single-valued");
            }
            this._secondTransformFunction = secondArgument;
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        double[] values;
        int length = projectionBlock.getNumDocs();
        if (this._modulos == null || this._modulos.length < length) {
            this._modulos = new double[length];
        }
        if (this._firstTransformFunction == null) {
            Arrays.fill(this._modulos, 0, length, this._firstLiteral);
        } else {
            values = this._firstTransformFunction.transformToDoubleValuesSV(projectionBlock);
            System.arraycopy(values, 0, this._modulos, 0, length);
        }
        if (this._secondTransformFunction == null) {
            int i = 0;
            while (i < length) {
                int n = i++;
                this._modulos[n] = this._modulos[n] % this._secondLiteral;
            }
        } else {
            values = this._secondTransformFunction.transformToDoubleValuesSV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int n = i;
                this._modulos[n] = this._modulos[n] % values[i];
            }
        }
        return this._modulos;
    }
}

