/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.CombinedFilterOperator;
import org.apache.pinot.core.operator.query.AggregationOperator;
import org.apache.pinot.core.operator.query.FastFilteredCountOperator;
import org.apache.pinot.core.operator.query.FilteredAggregationOperator;
import org.apache.pinot.core.operator.query.NonScanBasedAggregationOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class AggregationPlanNode
implements PlanNode {
    private static final EnumSet<AggregationFunctionType> DICTIONARY_BASED_FUNCTIONS = EnumSet.of(AggregationFunctionType.MIN, new AggregationFunctionType[]{AggregationFunctionType.MINMV, AggregationFunctionType.MAX, AggregationFunctionType.MAXMV, AggregationFunctionType.MINMAXRANGE, AggregationFunctionType.MINMAXRANGEMV, AggregationFunctionType.DISTINCTCOUNT, AggregationFunctionType.DISTINCTCOUNTMV, AggregationFunctionType.DISTINCTCOUNTHLL, AggregationFunctionType.DISTINCTCOUNTHLLMV, AggregationFunctionType.DISTINCTCOUNTRAWHLL, AggregationFunctionType.DISTINCTCOUNTRAWHLLMV, AggregationFunctionType.SEGMENTPARTITIONEDDISTINCTCOUNT, AggregationFunctionType.DISTINCTCOUNTSMARTHLL});
    private static final EnumSet<AggregationFunctionType> METADATA_BASED_FUNCTIONS = EnumSet.of(AggregationFunctionType.COUNT, new AggregationFunctionType[]{AggregationFunctionType.MIN, AggregationFunctionType.MINMV, AggregationFunctionType.MAX, AggregationFunctionType.MAXMV, AggregationFunctionType.MINMAXRANGE, AggregationFunctionType.MINMAXRANGEMV});
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;

    public AggregationPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
    }

    public Operator<IntermediateResultsBlock> run() {
        assert (this._queryContext.getAggregationFunctions() != null);
        return this._queryContext.isHasFilteredAggregations() ? this.buildFilteredAggOperator() : this.buildNonFilteredAggOperator();
    }

    private BaseOperator<IntermediateResultsBlock> buildFilteredAggOperator() {
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        Pair<FilterPlanNode, BaseFilterOperator> filterOperatorPair = this.buildFilterOperator(this._queryContext.getFilter());
        TransformOperator transformOperator = this.buildTransformOperatorForFilteredAggregates((BaseFilterOperator)filterOperatorPair.getRight());
        return this.buildFilterOperatorInternal((BaseFilterOperator)filterOperatorPair.getRight(), transformOperator, numTotalDocs);
    }

    private BaseOperator<IntermediateResultsBlock> buildFilterOperatorInternal(BaseFilterOperator mainPredicateFilterOperator, TransformOperator mainTransformOperator, int numTotalDocs) {
        HashMap<FilterContext, Pair> filterContextToAggFuncsMap = new HashMap<FilterContext, Pair>();
        ArrayList<AggregationFunction> nonFilteredAggregationFunctions = new ArrayList<AggregationFunction>();
        List<Pair<AggregationFunction, FilterContext>> aggregationFunctions = this._queryContext.getFilteredAggregationFunctions();
        for (Pair<AggregationFunction, FilterContext> inputPair : aggregationFunctions) {
            if (inputPair.getLeft() != null) {
                FilterContext currentFilterExpression = (FilterContext)inputPair.getRight();
                if (filterContextToAggFuncsMap.get(currentFilterExpression) != null) {
                    ((List)((Pair)filterContextToAggFuncsMap.get(currentFilterExpression)).getLeft()).add((AggregationFunction)inputPair.getLeft());
                    continue;
                }
                Pair<FilterPlanNode, BaseFilterOperator> pair = this.buildFilterOperator(currentFilterExpression);
                CombinedFilterOperator wrappedFilterOperator = new CombinedFilterOperator(mainPredicateFilterOperator, (BaseFilterOperator)pair.getRight());
                TransformOperator newTransformOperator = this.buildTransformOperatorForFilteredAggregates(wrappedFilterOperator);
                ArrayList<AggregationFunction> aggFunctionList = new ArrayList<AggregationFunction>();
                aggFunctionList.add((AggregationFunction)inputPair.getLeft());
                filterContextToAggFuncsMap.put(currentFilterExpression, Pair.of(aggFunctionList, (Object)newTransformOperator));
                continue;
            }
            nonFilteredAggregationFunctions.add((AggregationFunction)inputPair.getLeft());
        }
        ArrayList<Pair<AggregationFunction[], TransformOperator>> aggToTransformOpList = new ArrayList<Pair<AggregationFunction[], TransformOperator>>();
        for (Pair pair : filterContextToAggFuncsMap.values()) {
            List aggregationFunctionList = (List)pair.getLeft();
            if (aggregationFunctionList == null) {
                throw new IllegalStateException("Null aggregation list seen");
            }
            aggToTransformOpList.add(Pair.of((Object)aggregationFunctionList.toArray(new AggregationFunction[0]), (Object)((TransformOperator)pair.getRight())));
        }
        aggToTransformOpList.add(Pair.of((Object)nonFilteredAggregationFunctions.toArray(new AggregationFunction[0]), (Object)mainTransformOperator));
        return new FilteredAggregationOperator(this._queryContext.getAggregationFunctions(), aggToTransformOpList, numTotalDocs, this._queryContext.isNullHandlingEnabled());
    }

    private Pair<FilterPlanNode, BaseFilterOperator> buildFilterOperator(FilterContext filterContext) {
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._indexSegment, this._queryContext, filterContext);
        return Pair.of((Object)filterPlanNode, (Object)filterPlanNode.run());
    }

    private TransformOperator buildTransformOperatorForFilteredAggregates(BaseFilterOperator filterOperator) {
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        Set<ExpressionContext> expressionsToTransform = AggregationFunctionUtils.collectExpressionsToTransform(aggregationFunctions, null);
        return new TransformPlanNode(this._indexSegment, this._queryContext, expressionsToTransform, 10000, filterOperator).run();
    }

    public Operator<IntermediateResultsBlock> buildNonFilteredAggOperator() {
        Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs;
        assert (this._queryContext.getAggregationFunctions() != null);
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._indexSegment, this._queryContext);
        BaseFilterOperator filterOperator = filterPlanNode.run();
        if (AggregationPlanNode.canOptimizeFilteredCount(filterOperator, aggregationFunctions) && !this._queryContext.isNullHandlingEnabled()) {
            return new FastFilteredCountOperator(aggregationFunctions, filterOperator, this._indexSegment.getSegmentMetadata());
        }
        if (filterOperator.isResultMatchingAll() && !this._queryContext.isNullHandlingEnabled() && AggregationPlanNode.isFitForNonScanBasedPlan(aggregationFunctions, this._indexSegment)) {
            DataSource[] dataSources = new DataSource[aggregationFunctions.length];
            for (int i = 0; i < aggregationFunctions.length; ++i) {
                List<ExpressionContext> inputExpressions = aggregationFunctions[i].getInputExpressions();
                if (inputExpressions.isEmpty()) continue;
                String column = inputExpressions.get(0).getIdentifier();
                dataSources[i] = this._indexSegment.getDataSource(column);
            }
            return new NonScanBasedAggregationOperator(aggregationFunctions, dataSources, numTotalDocs);
        }
        List starTrees = this._indexSegment.getStarTrees();
        if (starTrees != null && !this._queryContext.isSkipStarTree() && !this._queryContext.isNullHandlingEnabled() && (aggregationFunctionColumnPairs = StarTreeUtils.extractAggregationFunctionPairs(aggregationFunctions)) != null && (predicateEvaluatorsMap = StarTreeUtils.extractPredicateEvaluatorsMap(this._indexSegment, this._queryContext.getFilter(), filterPlanNode.getPredicateEvaluators())) != null) {
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, null, predicateEvaluatorsMap.keySet())) continue;
                TransformOperator transformOperator = new StarTreeTransformPlanNode(this._queryContext, starTreeV2, aggregationFunctionColumnPairs, null, predicateEvaluatorsMap).run();
                return new AggregationOperator(aggregationFunctions, transformOperator, numTotalDocs, true, false);
            }
        }
        Set<ExpressionContext> expressionsToTransform = AggregationFunctionUtils.collectExpressionsToTransform(aggregationFunctions, null);
        TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressionsToTransform, 10000, filterOperator).run();
        return new AggregationOperator(aggregationFunctions, transformOperator, numTotalDocs, false, this._queryContext.isNullHandlingEnabled());
    }

    private static boolean isFitForNonScanBasedPlan(AggregationFunction[] aggregationFunctions, IndexSegment indexSegment) {
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            if (aggregationFunction.getType() == AggregationFunctionType.COUNT) continue;
            ExpressionContext argument = aggregationFunction.getInputExpressions().get(0);
            if (argument.getType() != ExpressionContext.Type.IDENTIFIER) {
                return false;
            }
            DataSource dataSource = indexSegment.getDataSource(argument.getIdentifier());
            if (DICTIONARY_BASED_FUNCTIONS.contains(aggregationFunction.getType()) && dataSource.getDictionary() != null || METADATA_BASED_FUNCTIONS.contains(aggregationFunction.getType()) && dataSource.getDataSourceMetadata().getMaxValue() != null && dataSource.getDataSourceMetadata().getMinValue() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean canOptimizeFilteredCount(BaseFilterOperator filterOperator, AggregationFunction[] aggregationFunctions) {
        return aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.COUNT && filterOperator.canOptimizeCount();
    }
}

