/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.query.DictionaryBasedDistinctOperator;
import org.apache.pinot.core.operator.query.DistinctOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;

public class DistinctPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;

    public DistinctPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
    }

    public Operator<IntermediateResultsBlock> run() {
        DataSource dataSource;
        Dictionary dictionary;
        ExpressionContext expression;
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        DistinctAggregationFunction distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        List<ExpressionContext> expressions = distinctAggregationFunction.getInputExpressions();
        if (this._queryContext.getFilter() == null && !this._queryContext.isNullHandlingEnabled() && expressions.size() == 1 && (expression = expressions.get(0)).getType() == ExpressionContext.Type.IDENTIFIER && (dictionary = (dataSource = this._indexSegment.getDataSource(expression.getIdentifier())).getDictionary()) != null) {
            DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
            NullValueVectorReader nullValueReader = dataSource.getNullValueVector();
            if (nullValueReader == null || nullValueReader.getNullBitmap().isEmpty()) {
                return new DictionaryBasedDistinctOperator(dataSourceMetadata.getDataType(), distinctAggregationFunction, dictionary, dataSourceMetadata.getNumDocs(), this._queryContext.isNullHandlingEnabled());
            }
        }
        TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, 10000).run();
        return new DistinctOperator(this._indexSegment, distinctAggregationFunction, transformOperator, this._queryContext);
    }
}

