/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.FirstWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.StringLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class FirstStringValueWithTimeAggregationFunction
extends FirstWithTimeAggregationFunction<String> {
    private static final ValueLongPair<String> DEFAULT_VALUE_TIME_PAIR = new StringLongPair("", Long.MAX_VALUE);

    public FirstStringValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol) {
        super(dataCol, timeCol, ObjectSerDeUtils.STRING_LONG_PAIR_SER_DE);
    }

    @Override
    public ValueLongPair<String> constructValueLongPair(String value, long time) {
        return new StringLongPair(value, time);
    }

    @Override
    public ValueLongPair<String> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public void aggregateResultWithRawData(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        ValueLongPair<String> defaultValueLongPair = this.getDefaultValueTimePair();
        String firstData = (String)((Object)defaultValueLongPair.getValue());
        long firstTime = defaultValueLongPair.getTime();
        String[] stringValues = blockValSet.getStringValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            String data = stringValues[i];
            long time = timeValues[i];
            if (time > firstTime) continue;
            firstTime = time;
            firstData = data;
        }
        this.setAggregationResult(aggregationResultHolder, firstData, firstTime);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        String[] stringValues = blockValSet.getStringValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            String data = stringValues[i];
            long time = timeValues[i];
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
        }
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        String[] stringValues = blockValSet.getStringValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            String value = stringValues[i];
            long time = timeValues[i];
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, value, time);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'STRING')";
    }

    @Override
    public String getColumnName() {
        return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_STRING";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }
}

