/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.LastWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.LongLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class LastLongValueWithTimeAggregationFunction
extends LastWithTimeAggregationFunction<Long> {
    private static final ValueLongPair<Long> DEFAULT_VALUE_TIME_PAIR = new LongLongPair(Long.valueOf(Long.MIN_VALUE), Long.MIN_VALUE);

    public LastLongValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol) {
        super(dataCol, timeCol, ObjectSerDeUtils.LONG_LONG_PAIR_SER_DE);
    }

    @Override
    public ValueLongPair<Long> constructValueLongPair(Long value, long time) {
        return new LongLongPair(value, time);
    }

    @Override
    public ValueLongPair<Long> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public void aggregateResultWithRawData(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        ValueLongPair<Long> defaultValueLongPair = this.getDefaultValueTimePair();
        Long lastData = (Long)defaultValueLongPair.getValue();
        long lastTime = defaultValueLongPair.getTime();
        long[] longValues = blockValSet.getLongValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            long data = longValues[i];
            long time = timeValues[i];
            if (time < lastTime) continue;
            lastTime = time;
            lastData = data;
        }
        this.setAggregationResult(aggregationResultHolder, lastData, lastTime);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        long[] longValues = blockValSet.getLongValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            long data = longValues[i];
            long time = timeValues[i];
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
        }
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        long[] longValues = blockValSet.getLongValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            long value = longValues[i];
            long time = timeValues[i];
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, value, time);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'LONG')";
    }

    @Override
    public String getColumnName() {
        return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_LONG";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }
}

