/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.roaringbitmap.RoaringBitmap;

public class MaxAggregationFunction
extends BaseSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_INITIAL_VALUE = Double.NEGATIVE_INFINITY;
    private final boolean _nullHandlingEnabled;

    public MaxAggregationFunction(ExpressionContext expression) {
        this(expression, false);
    }

    public MaxAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MAX;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(Double.NEGATIVE_INFINITY);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.aggregateNullHandlingEnabled(length, aggregationResultHolder, blockValSet, nullBitmap);
            return;
        }
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                Object[] values = blockValSet.getIntValuesSV();
                int max = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    max = Math.max(values[i], max);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.max((double)max, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case LONG: {
                Object[] values = blockValSet.getLongValuesSV();
                int max = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    max = (int)Math.max((long)values[i], (long)max);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.max((double)max, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case FLOAT: {
                Object[] values = blockValSet.getFloatValuesSV();
                int max = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    max = (int)Math.max((float)values[i], (float)max);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.max((double)max, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case DOUBLE: {
                Object[] values = blockValSet.getDoubleValuesSV();
                int max = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    max = (int)Math.max((double)values[i], (double)max);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.max((double)max, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case BIG_DECIMAL: {
                Object[] values = blockValSet.getBigDecimalValuesSV();
                Object max = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    max = values[i].max((BigDecimal)max);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.max(max.doubleValue(), aggregationResultHolder.getDoubleResult()));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute max for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void aggregateNullHandlingEnabled(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                if (nullBitmap.getCardinality() >= length) break;
                int[] values = blockValSet.getIntValuesSV();
                int max = Integer.MIN_VALUE;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        max = Math.max(values[i], max);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case LONG: {
                if (nullBitmap.getCardinality() >= length) break;
                long[] values = blockValSet.getLongValuesSV();
                long max = Long.MIN_VALUE;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        max = Math.max(values[i], max);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case FLOAT: {
                if (nullBitmap.getCardinality() >= length) break;
                float[] values = blockValSet.getFloatValuesSV();
                float max = Float.NEGATIVE_INFINITY;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        max = Math.max(values[i], max);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case DOUBLE: {
                if (nullBitmap.getCardinality() >= length) break;
                double[] values = blockValSet.getDoubleValuesSV();
                double max = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        max = Math.max(values[i], max);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case BIG_DECIMAL: {
                if (nullBitmap.getCardinality() >= length) break;
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal max = null;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        max = max == null ? values[i] : values[i].max(max);
                    }
                    ++i;
                }
                assert (max != null);
                this.updateAggregationResultHolder(aggregationResultHolder, max.doubleValue());
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute max for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void updateAggregationResultHolder(AggregationResultHolder aggregationResultHolder, double max) {
        Double otherMax = (Double)aggregationResultHolder.getResult();
        aggregationResultHolder.setValue(otherMax == null ? max : Math.max(max, otherMax));
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            if (nullBitmap.getCardinality() < length) {
                double[] valueArray = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    int groupKey = groupKeyArray[i];
                    Double result = (Double)groupByResultHolder.getResult(groupKey);
                    if (nullBitmap.contains(i) || result != null && !(value > result)) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
            return;
        }
        double[] valueArray = blockValSet.getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            int groupKey = groupKeyArray[i];
            if (!(value > groupByResultHolder.getDoubleResult(groupKey))) continue;
            groupByResultHolder.setValueForKey(groupKey, value);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                if (!(value > groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateMaxResult1, Double intermediateMaxResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateMaxResult1 == null) {
                return intermediateMaxResult2;
            }
            if (intermediateMaxResult2 == null) {
                return intermediateMaxResult1;
            }
        }
        if (intermediateMaxResult1 > intermediateMaxResult2) {
            return intermediateMaxResult1;
        }
        return intermediateMaxResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }
}

