/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.tdunning.math.stats.TDigest;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PercentileTDigestMVAggregationFunction
extends PercentileTDigestAggregationFunction {
    public PercentileTDigestMVAggregationFunction(ExpressionContext expression, int percentile) {
        super(expression, percentile);
    }

    public PercentileTDigestMVAggregationFunction(ExpressionContext expression, double percentile) {
        super(expression, percentile);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILETDIGESTMV;
    }

    @Override
    public String getColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILETDIGEST.getName() + (int)this._percentile + "MV_" + this._expression : AggregationFunctionType.PERCENTILETDIGEST.getName() + this._percentile + "MV_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILETDIGEST.getName().toLowerCase() + (int)this._percentile + "mv(" + this._expression + ")" : AggregationFunctionType.PERCENTILETDIGEST.getName().toLowerCase() + "mv(" + this._expression + ", " + this._percentile + ")";
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        TDigest tDigest = PercentileTDigestMVAggregationFunction.getDefaultTDigest(aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (double value : valuesArray[i]) {
                tDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            TDigest tDigest = PercentileTDigestMVAggregationFunction.getDefaultTDigest(groupByResultHolder, groupKeyArray[i]);
            for (double value : valuesArray[i]) {
                tDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[][] valuesArray = blockValSetMap.get(this._expression).getDoubleValuesMV();
        for (int i = 0; i < length; ++i) {
            double[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                TDigest tDigest = PercentileTDigestMVAggregationFunction.getDefaultTDigest(groupByResultHolder, groupKey);
                for (double value : values) {
                    tDigest.add(value);
                }
            }
        }
    }
}

