/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

public class DistinctExecutorUtils {
    private DistinctExecutorUtils() {
    }

    public static int[][] getDictIds(int[][] svDictIds, int[][][] mvDictIds, int docId) {
        int[][] nArrayArray;
        int[][] dictIdsArray = null;
        int numExpressions = svDictIds.length;
        int[] singleDictIds = new int[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            int j;
            if (svDictIds[i] != null) {
                int dictId = svDictIds[i][docId];
                if (dictIdsArray == null) {
                    singleDictIds[i] = dictId;
                    continue;
                }
                for (int[] dictIds : dictIdsArray) {
                    dictIds[i] = dictId;
                }
                continue;
            }
            int[] dictIdsForMV = mvDictIds[i][docId];
            int numValues = dictIdsForMV.length;
            if (numValues == 1) {
                int dictId = dictIdsForMV[0];
                if (dictIdsArray == null) {
                    singleDictIds[i] = dictId;
                    continue;
                }
                for (int[] dictIds : dictIdsArray) {
                    dictIds[i] = dictId;
                }
                continue;
            }
            if (dictIdsArray == null) {
                dictIdsArray = new int[numValues][];
                for (int j2 = 0; j2 < numValues; ++j2) {
                    int dictId = dictIdsForMV[j2];
                    dictIdsArray[j2] = (int[])singleDictIds.clone();
                    dictIdsArray[j2][i] = dictId;
                }
                continue;
            }
            int currentLength = dictIdsArray.length;
            int newLength = currentLength * numValues;
            int[][] newDictIdsArray = new int[newLength][];
            System.arraycopy(dictIdsArray, 0, newDictIdsArray, 0, currentLength);
            for (j = 1; j < numValues; ++j) {
                int offset = j * currentLength;
                for (int k = 0; k < currentLength; ++k) {
                    newDictIdsArray[offset + k] = (int[])dictIdsArray[k].clone();
                }
            }
            for (j = 0; j < numValues; ++j) {
                int dictId = dictIdsForMV[j];
                int startOffset = j * currentLength;
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newDictIdsArray[k][i] = dictId;
                }
            }
            dictIdsArray = newDictIdsArray;
        }
        if (dictIdsArray == null) {
            int[][] nArrayArray2 = new int[1][];
            nArrayArray = nArrayArray2;
            nArrayArray2[0] = singleDictIds;
        } else {
            nArrayArray = dictIdsArray;
        }
        return nArrayArray;
    }

    public static Object[][] getRecords(Object[][] svValues, Object[][][] mvValues, int docId) {
        Object[][] objectArrayArray;
        Object[][] records = null;
        int numExpressions = svValues.length;
        Object[] singleRecord = new Object[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            int j;
            if (svValues[i] != null) {
                Object value = svValues[i][docId];
                if (records == null) {
                    singleRecord[i] = value;
                    continue;
                }
                for (Object[] record : records) {
                    record[i] = value;
                }
                continue;
            }
            Object[] valuesForMV = mvValues[i][docId];
            int numValues = valuesForMV.length;
            if (numValues == 1) {
                Object value = valuesForMV[0];
                if (records == null) {
                    singleRecord[i] = value;
                    continue;
                }
                for (Object[] record : records) {
                    record[i] = value;
                }
                continue;
            }
            if (records == null) {
                records = new Object[numValues][];
                for (int j2 = 0; j2 < numValues; ++j2) {
                    Object value = valuesForMV[j2];
                    records[j2] = (Object[])singleRecord.clone();
                    records[j2][i] = value;
                }
                continue;
            }
            int currentLength = records.length;
            int newLength = currentLength * numValues;
            Object[][] newRecords = new Object[newLength][];
            System.arraycopy(records, 0, newRecords, 0, currentLength);
            for (j = 1; j < numValues; ++j) {
                int offset = j * currentLength;
                for (int k = 0; k < currentLength; ++k) {
                    newRecords[offset + k] = (Object[])records[k].clone();
                }
            }
            for (j = 0; j < numValues; ++j) {
                Object value = valuesForMV[j];
                int startOffset = j * currentLength;
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newRecords[k][i] = value;
                }
            }
            records = newRecords;
        }
        if (records == null) {
            Object[][] objectArrayArray2 = new Object[1][];
            objectArrayArray = objectArrayArray2;
            objectArrayArray2[0] = singleRecord;
        } else {
            objectArrayArray = records;
        }
        return objectArrayArray;
    }
}

