/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import java.util.ArrayList;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

abstract class BaseRawDoubleSingleColumnDistinctExecutor
implements DistinctExecutor {
    final ExpressionContext _expression;
    final FieldSpec.DataType _dataType;
    final int _limit;
    final boolean _nullHandlingEnabled;
    final DoubleSet _valueSet;
    protected boolean _hasNull;

    BaseRawDoubleSingleColumnDistinctExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        this._expression = expression;
        this._dataType = dataType;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._valueSet = new DoubleOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        DataSchema dataSchema = new DataSchema(new String[]{this._expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        ArrayList<Record> records = new ArrayList<Record>(this._valueSet.size());
        DoubleIterator valueIterator = this._valueSet.iterator();
        while (valueIterator.hasNext()) {
            records.add(new Record(new Object[]{valueIterator.nextDouble()}));
        }
        if (this._hasNull) {
            records.add(new Record(new Object[]{null}));
        }
        return new DistinctTable(dataSchema, records, this._nullHandlingEnabled);
    }
}

