/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawDoubleSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawDoubleSingleColumnDistinctOnlyExecutor
extends BaseRawDoubleSingleColumnDistinctExecutor {
    public RawDoubleSingleColumnDistinctOnlyExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        int numDocs = transformBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            double[] values = blockValueSet.getDoubleValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        this._hasNull = true;
                        continue;
                    }
                    this._valueSet.add(values[i]);
                    if (this._valueSet.size() < this._limit - (this._hasNull ? 1 : 0)) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    this._valueSet.add(values[i]);
                    if (this._valueSet.size() < this._limit) continue;
                    return true;
                }
            }
        } else {
            double[][] values = blockValueSet.getDoubleValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (double value : values[i]) {
                    this._valueSet.add(value);
                    if (this._valueSet.size() < this._limit) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

