/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.floats.FloatHeapPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawFloatSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawFloatSingleColumnDistinctOrderByExecutor
extends BaseRawFloatSingleColumnDistinctExecutor {
    private final FloatPriorityQueue _priorityQueue;

    public RawFloatSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new FloatHeapPriorityQueue(Math.min(limit, 10000), (f1, f2) -> Float.compare(f1, f2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        int numDocs = transformBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            float[] values = blockValueSet.getFloatValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        this._hasNull = true;
                        continue;
                    }
                    this.add(values[i]);
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    this.add(values[i]);
                }
            }
        } else {
            float[][] values = blockValueSet.getFloatValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (float value : values[i]) {
                    this.add(value);
                }
            }
        }
        return false;
    }

    private void add(float value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit - (this._hasNull ? 1 : 0)) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                float firstValue = this._priorityQueue.firstFloat();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueFloat();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
    }
}

