/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.statement;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.function.scalar.ArithmeticFunctions;
import org.apache.pinot.common.function.scalar.DateTimeFunctions;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.statement.StatementOptimizer;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.sql.FilterKind;

public class JsonStatementOptimizer
implements StatementOptimizer {
    private static final Set<String> NUMERICAL_FUNCTIONS = JsonStatementOptimizer.getNumericalFunctionList();
    private static final Set<String> DATETIME_FUNCTIONS = JsonStatementOptimizer.getDateTimeFunctionList();

    @Override
    public void optimize(PinotQuery query, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        Expression expression;
        Object expression22;
        if (schema == null || !schema.hasJSONColumn()) {
            return;
        }
        List expressions = query.getSelectList();
        for (Object expression22 : expressions) {
            Pair<String, Boolean> result = JsonStatementOptimizer.optimizeJsonIdentifier((Expression)expression22, schema, DataSchema.ColumnDataType.STRING);
            if (expression22.getType() != ExpressionType.FUNCTION || expression22.getFunctionCall().getOperator().equals("AS") || !((Boolean)result.getRight()).booleanValue()) continue;
            Function aliasFunction = JsonStatementOptimizer.getAliasFunction((String)result.getLeft(), expression22.getFunctionCall());
            expression22.setFunctionCall(aliasFunction);
        }
        Expression filter = query.getFilterExpression();
        if (filter != null) {
            JsonStatementOptimizer.optimizeJsonPredicate(filter, tableConfig, schema);
        }
        if ((expressions = query.getGroupByList()) != null) {
            expression22 = expressions.iterator();
            while (expression22.hasNext()) {
                expression = (Expression)expression22.next();
                JsonStatementOptimizer.optimizeJsonIdentifier(expression, schema, DataSchema.ColumnDataType.STRING);
            }
        }
        if ((expressions = query.getOrderByList()) != null) {
            expression22 = expressions.iterator();
            while (expression22.hasNext()) {
                expression = (Expression)expression22.next();
                JsonStatementOptimizer.optimizeJsonIdentifier(expression, schema, DataSchema.ColumnDataType.STRING);
            }
        }
        if ((expression22 = query.getHavingExpression()) != null) {
            JsonStatementOptimizer.optimizeJsonIdentifier((Expression)expression22, schema, DataSchema.ColumnDataType.STRING);
        }
    }

    private static Pair<String, Boolean> optimizeJsonIdentifier(Expression expression, @Nullable Schema schema, DataSchema.ColumnDataType outputDataType) {
        switch (expression.getType()) {
            case LITERAL: {
                return Pair.of((Object)JsonStatementOptimizer.getLiteralSQL(expression.getLiteral(), true), (Object)false);
            }
            case IDENTIFIER: {
                String[] parts;
                boolean hasJsonPathExpression = false;
                String columnName = expression.getIdentifier().getName();
                if (!schema.hasColumn(columnName) && (parts = JsonStatementOptimizer.getIdentifierParts(expression.getIdentifier())).length > 1 && JsonStatementOptimizer.isValidJSONColumn(parts[0], schema)) {
                    Function jsonExtractScalarFunction = JsonStatementOptimizer.getJsonExtractFunction(parts, outputDataType);
                    expression.setIdentifier(null);
                    expression.setType(ExpressionType.FUNCTION);
                    expression.setFunctionCall(jsonExtractScalarFunction);
                    hasJsonPathExpression = true;
                }
                return Pair.of((Object)columnName, (Object)hasJsonPathExpression);
            }
            case FUNCTION: {
                Function function = expression.getFunctionCall();
                List operands = function.getOperands();
                boolean hasJsonPathExpression = false;
                StringBuffer alias = new StringBuffer();
                if (function.getOperator().toUpperCase().equals("AS")) {
                    hasJsonPathExpression = (Boolean)JsonStatementOptimizer.optimizeJsonIdentifier((Expression)operands.get(0), schema, outputDataType).getRight();
                    alias.append(((Expression)function.getOperands().get(1)).getIdentifier().getName());
                } else {
                    alias.append(function.getOperator().toLowerCase()).append("(");
                    outputDataType = JsonStatementOptimizer.getJsonExtractOutputDataType(function);
                    for (int i = 0; i < operands.size(); ++i) {
                        Pair<String, Boolean> operandResult = JsonStatementOptimizer.optimizeJsonIdentifier((Expression)operands.get(i), schema, outputDataType);
                        hasJsonPathExpression |= ((Boolean)operandResult.getRight()).booleanValue();
                        if (i > 0) {
                            alias.append(",");
                        }
                        alias.append((String)operandResult.getLeft());
                    }
                    alias.append(")");
                }
                return Pair.of((Object)alias.toString(), (Object)hasJsonPathExpression);
            }
        }
        return Pair.of((Object)"", (Object)false);
    }

    private static Function getAliasFunction(String alias, Function function) {
        Function aliasFunction = new Function("as");
        ArrayList<Expression> operands = new ArrayList<Expression>();
        Expression expression = new Expression(ExpressionType.FUNCTION);
        expression.setFunctionCall(function);
        operands.add(expression);
        operands.add(RequestUtils.getIdentifierExpression((String)alias));
        aliasFunction.setOperands(operands);
        return aliasFunction;
    }

    private static Function getJsonExtractFunction(String[] parts, DataSchema.ColumnDataType dataType) {
        Function jsonExtractScalarFunction = new Function("jsonextractscalar");
        ArrayList<Expression> operands = new ArrayList<Expression>();
        operands.add(RequestUtils.getIdentifierExpression((String)parts[0]));
        operands.add(RequestUtils.getLiteralExpression((String)JsonStatementOptimizer.getJsonPath(parts, false)));
        operands.add(RequestUtils.getLiteralExpression((String)dataType.toString()));
        operands.add(RequestUtils.getLiteralExpression((Object)JsonStatementOptimizer.getDefaultNullValueForType(dataType)));
        jsonExtractScalarFunction.setOperands(operands);
        return jsonExtractScalarFunction;
    }

    private static void optimizeJsonPredicate(Expression expression, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        if (expression.getType() == ExpressionType.FUNCTION) {
            Function function = expression.getFunctionCall();
            String operator = function.getOperator();
            FilterKind kind = FilterKind.valueOf((String)operator);
            List operands = function.getOperands();
            switch (kind) {
                case AND: 
                case OR: 
                case NOT: {
                    operands.forEach(operand -> JsonStatementOptimizer.optimizeJsonPredicate(operand, tableConfig, schema));
                    break;
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    String[] parts;
                    Expression left = (Expression)operands.get(0);
                    Expression right = (Expression)operands.get(1);
                    if (left.getType() != ExpressionType.IDENTIFIER || right.getType() != ExpressionType.LITERAL || schema.hasColumn(left.getIdentifier().getName()) || (parts = JsonStatementOptimizer.getIdentifierParts(left.getIdentifier())).length <= 1 || !JsonStatementOptimizer.isValidJSONColumn(parts[0], schema)) break;
                    if (JsonStatementOptimizer.isIndexedJSONColumn(parts[0], tableConfig)) {
                        Function jsonMatchFunction = new Function(FilterKind.JSON_MATCH.name());
                        ArrayList<Expression> jsonMatchFunctionOperands = new ArrayList<Expression>();
                        jsonMatchFunctionOperands.add(RequestUtils.getIdentifierExpression((String)parts[0]));
                        jsonMatchFunctionOperands.add(RequestUtils.getLiteralExpression((String)(JsonStatementOptimizer.getJsonPath(parts, true) + JsonStatementOptimizer.getOperatorSQL(kind) + JsonStatementOptimizer.getLiteralSQL(right.getLiteral(), false))));
                        jsonMatchFunction.setOperands(jsonMatchFunctionOperands);
                        expression.setFunctionCall(jsonMatchFunction);
                        break;
                    }
                    left.clear();
                    left.setType(ExpressionType.FUNCTION);
                    left.setFunctionCall(JsonStatementOptimizer.getJsonExtractFunction(parts, JsonStatementOptimizer.getColumnTypeForLiteral(right.getLiteral())));
                    break;
                }
                case IS_NULL: 
                case IS_NOT_NULL: {
                    String[] parts;
                    Expression operand2 = (Expression)operands.get(0);
                    if (operand2.getType() != ExpressionType.IDENTIFIER || schema.hasColumn(operand2.getIdentifier().getName()) || (parts = JsonStatementOptimizer.getIdentifierParts(operand2.getIdentifier())).length <= 1 || !JsonStatementOptimizer.isValidJSONColumn(parts[0], schema)) break;
                    if (JsonStatementOptimizer.isIndexedJSONColumn(parts[0], tableConfig)) {
                        Function jsonMatchFunction = new Function(FilterKind.JSON_MATCH.name());
                        ArrayList<Expression> jsonMatchFunctionOperands = new ArrayList<Expression>();
                        jsonMatchFunctionOperands.add(RequestUtils.getIdentifierExpression((String)parts[0]));
                        jsonMatchFunctionOperands.add(RequestUtils.getLiteralExpression((String)(JsonStatementOptimizer.getJsonPath(parts, true) + JsonStatementOptimizer.getOperatorSQL(kind))));
                        jsonMatchFunction.setOperands(jsonMatchFunctionOperands);
                        expression.setFunctionCall(jsonMatchFunction);
                        break;
                    }
                    operand2.clear();
                    operand2.setType(ExpressionType.FUNCTION);
                    operand2.setFunctionCall(JsonStatementOptimizer.getJsonExtractFunction(parts, DataSchema.ColumnDataType.JSON));
                    break;
                }
            }
        }
    }

    private static String[] getIdentifierParts(Identifier identifier) {
        String name = identifier.getName();
        int dotIndex = name.indexOf(46);
        int openBracketIndex = name.indexOf(91);
        if (openBracketIndex != -1 && (dotIndex == -1 || openBracketIndex < dotIndex)) {
            return new String[]{name.substring(0, openBracketIndex), name.substring(openBracketIndex)};
        }
        if (dotIndex != -1) {
            return new String[]{name.substring(0, dotIndex), name.substring(dotIndex)};
        }
        return new String[]{name};
    }

    private static String getJsonPath(String[] parts, boolean applyDoubleQuote) {
        StringBuilder builder = new StringBuilder();
        if (applyDoubleQuote) {
            builder.append("\"");
        }
        builder.append("$");
        builder.append(parts[1]);
        if (applyDoubleQuote) {
            builder.append("\"");
        }
        return builder.toString();
    }

    private static boolean isValidJSONColumn(String columnName, @Nullable Schema schema) {
        return schema != null && schema.hasColumn(columnName) && schema.getFieldSpecFor(columnName).getDataType().equals((Object)FieldSpec.DataType.JSON);
    }

    private static boolean isIndexedJSONColumn(String columnName, @Nullable TableConfig tableConfig) {
        if (tableConfig == null) {
            return false;
        }
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        if (indexingConfig == null) {
            return false;
        }
        List jsonIndexColumns = indexingConfig.getJsonIndexColumns();
        if (jsonIndexColumns == null) {
            return false;
        }
        return jsonIndexColumns.contains(columnName);
    }

    private static String getOperatorSQL(FilterKind kind) {
        switch (kind) {
            case EQUALS: {
                return " = ";
            }
            case NOT_EQUALS: {
                return " != ";
            }
            case GREATER_THAN: {
                return " > ";
            }
            case GREATER_THAN_OR_EQUAL: {
                return " >= ";
            }
            case LESS_THAN: {
                return " < ";
            }
            case LESS_THAN_OR_EQUAL: {
                return " <= ";
            }
            case IN: {
                return " IN ";
            }
            case NOT_IN: {
                return " NOT IN ";
            }
            case IS_NULL: {
                return " IS NULL";
            }
            case IS_NOT_NULL: {
                return " IS NOT NULL";
            }
        }
        return " ";
    }

    private static String getLiteralSQL(Literal literal, boolean aliasing) {
        StringBuffer result = new StringBuffer();
        result.append(aliasing ? "'" : "");
        switch ((Literal._Fields)literal.getSetField()) {
            case BOOL_VALUE: {
                result.append(String.valueOf(literal.getBinaryValue()));
                break;
            }
            case BYTE_VALUE: {
                result.append((String)(aliasing ? String.valueOf(literal.getByteValue()) : "'" + String.valueOf(literal.getByteValue()) + "'"));
                break;
            }
            case SHORT_VALUE: {
                result.append((String)(aliasing ? String.valueOf(literal.getShortValue()) : "'" + String.valueOf(literal.getShortValue()) + "'"));
                break;
            }
            case INT_VALUE: {
                result.append(String.valueOf(literal.getIntValue()));
                break;
            }
            case LONG_VALUE: {
                result.append(String.valueOf(literal.getLongValue()));
                break;
            }
            case DOUBLE_VALUE: {
                result.append(String.valueOf(literal.getDoubleValue()));
                break;
            }
            case STRING_VALUE: {
                result.append("'" + literal.getStringValue() + "'");
                break;
            }
            case BINARY_VALUE: {
                result.append((String)(aliasing ? String.valueOf(literal.getBinaryValue()) : "'" + String.valueOf(literal.getBinaryValue()) + "'"));
                break;
            }
        }
        result.append(aliasing ? "'" : "");
        return result.toString();
    }

    private static DataSchema.ColumnDataType getColumnTypeForLiteral(Literal literal) {
        switch ((Literal._Fields)literal.getSetField()) {
            case BOOL_VALUE: {
                return DataSchema.ColumnDataType.BOOLEAN;
            }
            case SHORT_VALUE: 
            case INT_VALUE: 
            case LONG_VALUE: {
                return DataSchema.ColumnDataType.LONG;
            }
            case DOUBLE_VALUE: {
                return DataSchema.ColumnDataType.DOUBLE;
            }
            case STRING_VALUE: {
                return DataSchema.ColumnDataType.STRING;
            }
            case BYTE_VALUE: 
            case BINARY_VALUE: {
                return DataSchema.ColumnDataType.BYTES;
            }
        }
        return DataSchema.ColumnDataType.STRING;
    }

    private static Object getDefaultNullValueForType(DataSchema.ColumnDataType dataType) {
        switch (dataType) {
            case INT: {
                return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
            }
            case LONG: {
                return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_LONG;
            }
            case FLOAT: {
                return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_FLOAT;
            }
            case DOUBLE: {
                return FieldSpec.DEFAULT_DIMENSION_NULL_VALUE_OF_DOUBLE;
            }
        }
        return "null";
    }

    private static DataSchema.ColumnDataType getJsonExtractOutputDataType(Function function) {
        DataSchema.ColumnDataType dataType = DataSchema.ColumnDataType.STRING;
        if (NUMERICAL_FUNCTIONS.contains(function.getOperator().toUpperCase())) {
            dataType = DataSchema.ColumnDataType.DOUBLE;
        } else if (DATETIME_FUNCTIONS.contains(function.getOperator().toUpperCase())) {
            dataType = DataSchema.ColumnDataType.LONG;
        }
        return dataType;
    }

    public static Set<String> getNumericalFunctionList() {
        AggregationFunctionType[] aggs;
        Method[] methods;
        HashSet<String> set = new HashSet<String>();
        for (Method method : methods = ArithmeticFunctions.class.getDeclaredMethods()) {
            set.add(method.getName().toUpperCase());
        }
        for (AggregationFunctionType agg : aggs = AggregationFunctionType.values()) {
            set.add(agg.getName().toUpperCase());
        }
        return set;
    }

    public static Set<String> getDateTimeFunctionList() {
        Method[] methods;
        HashSet<String> set = new HashSet<String>();
        for (Method method : methods = DateTimeFunctions.class.getDeclaredMethods()) {
            set.add(method.getName().toUpperCase());
        }
        return set;
    }
}

