/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.roaringbitmap.RoaringBitmap;

public class AggregationDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;

    AggregationDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        if (dataTableMap.isEmpty()) {
            DataSchema resultTableSchema = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema()).getResultDataSchema();
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, Collections.emptyList()));
            return;
        }
        int numAggregationFunctions = this._aggregationFunctions.length;
        Object[] intermediateResults = new Object[numAggregationFunctions];
        for (DataTable dataTable : dataTableMap.values()) {
            for (int i = 0; i < numAggregationFunctions; ++i) {
                Object intermediateResultToMerge;
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                if (this._queryContext.isNullHandlingEnabled()) {
                    RoaringBitmap nullBitmap = dataTable.getNullRowIds(i);
                    boolean isNull = nullBitmap != null && nullBitmap.contains(0);
                    switch (columnDataType) {
                        case LONG: {
                            intermediateResultToMerge = isNull ? null : Long.valueOf(dataTable.getLong(0, i));
                            break;
                        }
                        case DOUBLE: {
                            intermediateResultToMerge = isNull ? null : Double.valueOf(dataTable.getDouble(0, i));
                            break;
                        }
                        case OBJECT: {
                            intermediateResultToMerge = isNull ? null : dataTable.getObject(0, i);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal column data type in aggregation results: " + columnDataType);
                        }
                    }
                } else {
                    switch (columnDataType) {
                        case LONG: {
                            intermediateResultToMerge = dataTable.getLong(0, i);
                            break;
                        }
                        case DOUBLE: {
                            intermediateResultToMerge = dataTable.getDouble(0, i);
                            break;
                        }
                        case OBJECT: {
                            intermediateResultToMerge = dataTable.getObject(0, i);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal column data type in aggregation results: " + columnDataType);
                        }
                    }
                }
                Object mergedIntermediateResult = intermediateResults[i];
                intermediateResults[i] = mergedIntermediateResult == null ? intermediateResultToMerge : this._aggregationFunctions[i].merge(mergedIntermediateResult, intermediateResultToMerge);
            }
        }
        Object[] finalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            Object result = aggregationFunction.extractFinalResult(intermediateResults[i]);
            finalResults[i] = result == null ? null : aggregationFunction.getFinalResultColumnType().convert(result);
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(finalResults));
    }

    private ResultTable reduceToResultTable(Object[] finalResults) {
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema());
        DataSchema dataSchema = postAggregationHandler.getResultDataSchema();
        Object[] row = postAggregationHandler.getResult(finalResults);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (int i = 0; i < numColumns; ++i) {
            row[i] = columnDataTypes[i].format(row[i]);
        }
        return new ResultTable(dataSchema, Collections.singletonList(row));
    }

    private DataSchema getPrePostAggregationDataSchema() {
        int numAggregationFunctions = this._aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            columnNames[i] = aggregationFunction.getResultColumnName();
            columnDataTypes[i] = aggregationFunction.getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }
}

