/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseReduceService {
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    protected static final String REDUCE_THREAD_NAME_FORMAT = "brw-%d";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseReduceService.class);
    protected final ExecutorService _reduceExecutorService;
    protected final int _maxReduceThreadsPerQuery;
    protected final int _groupByTrimThreshold;

    public BaseReduceService(PinotConfiguration config) {
        this._maxReduceThreadsPerQuery = config.getProperty("pinot.broker.max.reduce.threads.per.query", CommonConstants.Broker.DEFAULT_MAX_REDUCE_THREADS_PER_QUERY);
        this._groupByTrimThreshold = config.getProperty("pinot.broker.groupby.trim.threshold", 1000000);
        int numThreadsInExecutorService = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Initializing BrokerReduceService with {} threads, and {} max reduce threads.", (Object)numThreadsInExecutorService, (Object)this._maxReduceThreadsPerQuery);
        ThreadFactory reduceThreadFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat(REDUCE_THREAD_NAME_FORMAT).build();
        this._reduceExecutorService = Executors.newFixedThreadPool(numThreadsInExecutorService, reduceThreadFactory);
    }

    protected static void updateAlias(QueryContext queryContext, BrokerResponseNative brokerResponseNative) {
        List<ExpressionContext> selectExpressions;
        int numSelectExpressions;
        ResultTable resultTable = brokerResponseNative.getResultTable();
        if (resultTable == null) {
            return;
        }
        List<String> aliasList = queryContext.getAliasList();
        if (aliasList.isEmpty()) {
            return;
        }
        String[] columnNames = resultTable.getDataSchema().getColumnNames();
        if (columnNames.length != (numSelectExpressions = (selectExpressions = BaseReduceService.getSelectExpressions(queryContext.getSelectExpressions())).size())) {
            return;
        }
        for (int i = 0; i < numSelectExpressions; ++i) {
            String alias = aliasList.get(i);
            if (alias == null) continue;
            columnNames[i] = alias;
        }
    }

    protected static List<ExpressionContext> getSelectExpressions(List<ExpressionContext> selectExpressions) {
        if (selectExpressions.size() == 1 && selectExpressions.get(0).getType() == ExpressionContext.Type.FUNCTION && selectExpressions.get(0).getFunction().getFunctionName().equals("distinct")) {
            return selectExpressions.get(0).getFunction().getArguments();
        }
        return selectExpressions;
    }

    protected void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }

    protected static class ExecutionStatsAggregator {
        private final List<QueryProcessingException> _processingExceptions = new ArrayList<QueryProcessingException>();
        private final Map<String, String> _traceInfo = new HashMap<String, String>();
        private final boolean _enableTrace;
        private long _numDocsScanned = 0L;
        private long _numEntriesScannedInFilter = 0L;
        private long _numEntriesScannedPostFilter = 0L;
        private long _numSegmentsQueried = 0L;
        private long _numSegmentsProcessed = 0L;
        private long _numSegmentsMatched = 0L;
        private long _numConsumingSegmentsQueried = 0L;
        private long _numConsumingSegmentsProcessed = 0L;
        private long _numConsumingSegmentsMatched = 0L;
        private long _minConsumingFreshnessTimeMs = Long.MAX_VALUE;
        private long _numTotalDocs = 0L;
        private long _offlineThreadCpuTimeNs = 0L;
        private long _realtimeThreadCpuTimeNs = 0L;
        private long _offlineSystemActivitiesCpuTimeNs = 0L;
        private long _realtimeSystemActivitiesCpuTimeNs = 0L;
        private long _offlineResponseSerializationCpuTimeNs = 0L;
        private long _realtimeResponseSerializationCpuTimeNs = 0L;
        private long _offlineTotalCpuTimeNs = 0L;
        private long _realtimeTotalCpuTimeNs = 0L;
        private long _numSegmentsPrunedByServer = 0L;
        private long _numSegmentsPrunedInvalid = 0L;
        private long _numSegmentsPrunedByLimit = 0L;
        private long _numSegmentsPrunedByValue = 0L;
        private long _explainPlanNumEmptyFilterSegments = 0L;
        private long _explainPlanNumMatchAllFilterSegments = 0L;
        private boolean _numGroupsLimitReached = false;

        protected ExecutionStatsAggregator(boolean enableTrace) {
            this._enableTrace = enableTrace;
        }

        protected synchronized void aggregate(ServerRoutingInstance routingInstance, DataTable dataTable) {
            String numTotalDocsString;
            String explainPlanNumMatchAllFilterSegments;
            String responseSerializationCpuTimeNsString;
            String systemActivitiesCpuTimeNsString;
            String threadCpuTimeNsString;
            String minConsumingFreshnessTimeMsString;
            String numConsumingSegmentsMatched;
            String numConsumingSegmentsProcessed;
            String numConsumingSegmentsQueriedString;
            String numSegmentsMatchedString;
            String numSegmentsProcessedString;
            String numSegmentsQueriedString;
            String numEntriesScannedPostFilterString;
            String numEntriesScannedInFilterString;
            Map metadata = dataTable.getMetadata();
            if (this._enableTrace) {
                this._traceInfo.put(routingInstance.getHostname(), (String)metadata.get(DataTable.MetadataKey.TRACE_INFO.getName()));
            }
            Map exceptions = dataTable.getExceptions();
            Iterator iterator = exceptions.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                this._processingExceptions.add(new QueryProcessingException(key, (String)exceptions.get(key)));
            }
            String numDocsScannedString = (String)metadata.get(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName());
            if (numDocsScannedString != null) {
                this._numDocsScanned += Long.parseLong(numDocsScannedString);
            }
            if ((numEntriesScannedInFilterString = (String)metadata.get(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName())) != null) {
                this._numEntriesScannedInFilter += Long.parseLong(numEntriesScannedInFilterString);
            }
            if ((numEntriesScannedPostFilterString = (String)metadata.get(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName())) != null) {
                this._numEntriesScannedPostFilter += Long.parseLong(numEntriesScannedPostFilterString);
            }
            if ((numSegmentsQueriedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName())) != null) {
                this._numSegmentsQueried += Long.parseLong(numSegmentsQueriedString);
            }
            if ((numSegmentsProcessedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName())) != null) {
                this._numSegmentsProcessed += Long.parseLong(numSegmentsProcessedString);
            }
            if ((numSegmentsMatchedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName())) != null) {
                this._numSegmentsMatched += Long.parseLong(numSegmentsMatchedString);
            }
            if ((numConsumingSegmentsQueriedString = (String)metadata.get(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_QUERIED.getName())) != null) {
                this._numConsumingSegmentsQueried += Long.parseLong(numConsumingSegmentsQueriedString);
            }
            if ((numConsumingSegmentsProcessed = (String)metadata.get(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName())) != null) {
                this._numConsumingSegmentsProcessed += Long.parseLong(numConsumingSegmentsProcessed);
            }
            if ((numConsumingSegmentsMatched = (String)metadata.get(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_MATCHED.getName())) != null) {
                this._numConsumingSegmentsMatched += Long.parseLong(numConsumingSegmentsMatched);
            }
            if ((minConsumingFreshnessTimeMsString = (String)metadata.get(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName())) != null) {
                this._minConsumingFreshnessTimeMs = Math.min(Long.parseLong(minConsumingFreshnessTimeMsString), this._minConsumingFreshnessTimeMs);
            }
            if ((threadCpuTimeNsString = (String)metadata.get(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName())) != null) {
                if (routingInstance.getTableType() == TableType.OFFLINE) {
                    this._offlineThreadCpuTimeNs += Long.parseLong(threadCpuTimeNsString);
                } else {
                    this._realtimeThreadCpuTimeNs += Long.parseLong(threadCpuTimeNsString);
                }
            }
            if ((systemActivitiesCpuTimeNsString = (String)metadata.get(DataTable.MetadataKey.SYSTEM_ACTIVITIES_CPU_TIME_NS.getName())) != null) {
                if (routingInstance.getTableType() == TableType.OFFLINE) {
                    this._offlineSystemActivitiesCpuTimeNs += Long.parseLong(systemActivitiesCpuTimeNsString);
                } else {
                    this._realtimeSystemActivitiesCpuTimeNs += Long.parseLong(systemActivitiesCpuTimeNsString);
                }
            }
            if ((responseSerializationCpuTimeNsString = (String)metadata.get(DataTable.MetadataKey.RESPONSE_SER_CPU_TIME_NS.getName())) != null) {
                if (routingInstance.getTableType() == TableType.OFFLINE) {
                    this._offlineResponseSerializationCpuTimeNs += Long.parseLong(responseSerializationCpuTimeNsString);
                } else {
                    this._realtimeResponseSerializationCpuTimeNs += Long.parseLong(responseSerializationCpuTimeNsString);
                }
            }
            this._offlineTotalCpuTimeNs = this._offlineThreadCpuTimeNs + this._offlineSystemActivitiesCpuTimeNs + this._offlineResponseSerializationCpuTimeNs;
            this._realtimeTotalCpuTimeNs = this._realtimeThreadCpuTimeNs + this._realtimeSystemActivitiesCpuTimeNs + this._realtimeResponseSerializationCpuTimeNs;
            this.withNotNullLongMetadata(metadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_SERVER, l -> this._numSegmentsPrunedByServer += l);
            this.withNotNullLongMetadata(metadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_INVALID, l -> this._numSegmentsPrunedInvalid += l);
            this.withNotNullLongMetadata(metadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_LIMIT, l -> this._numSegmentsPrunedByLimit += l);
            this.withNotNullLongMetadata(metadata, DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_VALUE, l -> this._numSegmentsPrunedByValue += l);
            String explainPlanNumEmptyFilterSegments = (String)metadata.get(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS.getName());
            if (explainPlanNumEmptyFilterSegments != null) {
                this._explainPlanNumEmptyFilterSegments += Long.parseLong(explainPlanNumEmptyFilterSegments);
            }
            if ((explainPlanNumMatchAllFilterSegments = (String)metadata.get(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS.getName())) != null) {
                this._explainPlanNumMatchAllFilterSegments += Long.parseLong(explainPlanNumMatchAllFilterSegments);
            }
            if ((numTotalDocsString = (String)metadata.get(DataTable.MetadataKey.TOTAL_DOCS.getName())) != null) {
                this._numTotalDocs += Long.parseLong(numTotalDocsString);
            }
            this._numGroupsLimitReached |= Boolean.parseBoolean((String)metadata.get(DataTable.MetadataKey.NUM_GROUPS_LIMIT_REACHED.getName()));
        }

        protected void setStats(String rawTableName, BrokerResponseNative brokerResponseNative, BrokerMetrics brokerMetrics) {
            List processingExceptions = brokerResponseNative.getProcessingExceptions();
            processingExceptions.addAll(this._processingExceptions);
            if (this._enableTrace) {
                brokerResponseNative.getTraceInfo().putAll(this._traceInfo);
            }
            brokerResponseNative.setNumDocsScanned(this._numDocsScanned);
            brokerResponseNative.setNumEntriesScannedInFilter(this._numEntriesScannedInFilter);
            brokerResponseNative.setNumEntriesScannedPostFilter(this._numEntriesScannedPostFilter);
            brokerResponseNative.setNumSegmentsQueried(this._numSegmentsQueried);
            brokerResponseNative.setNumSegmentsProcessed(this._numSegmentsProcessed);
            brokerResponseNative.setNumSegmentsMatched(this._numSegmentsMatched);
            brokerResponseNative.setTotalDocs(this._numTotalDocs);
            brokerResponseNative.setNumGroupsLimitReached(this._numGroupsLimitReached);
            brokerResponseNative.setOfflineThreadCpuTimeNs(this._offlineThreadCpuTimeNs);
            brokerResponseNative.setRealtimeThreadCpuTimeNs(this._realtimeThreadCpuTimeNs);
            brokerResponseNative.setOfflineSystemActivitiesCpuTimeNs(this._offlineSystemActivitiesCpuTimeNs);
            brokerResponseNative.setRealtimeSystemActivitiesCpuTimeNs(this._realtimeSystemActivitiesCpuTimeNs);
            brokerResponseNative.setOfflineResponseSerializationCpuTimeNs(this._offlineResponseSerializationCpuTimeNs);
            brokerResponseNative.setRealtimeResponseSerializationCpuTimeNs(this._realtimeResponseSerializationCpuTimeNs);
            brokerResponseNative.setOfflineTotalCpuTimeNs(this._offlineTotalCpuTimeNs);
            brokerResponseNative.setRealtimeTotalCpuTimeNs(this._realtimeTotalCpuTimeNs);
            brokerResponseNative.setNumSegmentsPrunedByServer(this._numSegmentsPrunedByServer);
            brokerResponseNative.setNumSegmentsPrunedInvalid(this._numSegmentsPrunedInvalid);
            brokerResponseNative.setNumSegmentsPrunedByLimit(this._numSegmentsPrunedByLimit);
            brokerResponseNative.setNumSegmentsPrunedByValue(this._numSegmentsPrunedByValue);
            brokerResponseNative.setExplainPlanNumEmptyFilterSegments(this._explainPlanNumEmptyFilterSegments);
            brokerResponseNative.setExplainPlanNumMatchAllFilterSegments(this._explainPlanNumMatchAllFilterSegments);
            if (this._numConsumingSegmentsQueried > 0L) {
                brokerResponseNative.setNumConsumingSegmentsQueried(this._numConsumingSegmentsQueried);
            }
            if (this._minConsumingFreshnessTimeMs != Long.MAX_VALUE) {
                brokerResponseNative.setMinConsumingFreshnessTimeMs(this._minConsumingFreshnessTimeMs);
            }
            brokerResponseNative.setNumConsumingSegmentsProcessed(this._numConsumingSegmentsProcessed);
            brokerResponseNative.setNumConsumingSegmentsMatched(this._numConsumingSegmentsMatched);
            if (brokerMetrics != null) {
                brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.DOCUMENTS_SCANNED, this._numDocsScanned);
                brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_IN_FILTER, this._numEntriesScannedInFilter);
                brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_POST_FILTER, this._numEntriesScannedPostFilter);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.OFFLINE_THREAD_CPU_TIME_NS, this._offlineThreadCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.REALTIME_THREAD_CPU_TIME_NS, this._realtimeThreadCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.OFFLINE_SYSTEM_ACTIVITIES_CPU_TIME_NS, this._offlineSystemActivitiesCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.REALTIME_SYSTEM_ACTIVITIES_CPU_TIME_NS, this._realtimeSystemActivitiesCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.OFFLINE_RESPONSE_SER_CPU_TIME_NS, this._offlineResponseSerializationCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.REALTIME_RESPONSE_SER_CPU_TIME_NS, this._realtimeResponseSerializationCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.OFFLINE_TOTAL_CPU_TIME_NS, this._offlineTotalCpuTimeNs, TimeUnit.NANOSECONDS);
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.REALTIME_TOTAL_CPU_TIME_NS, this._realtimeTotalCpuTimeNs, TimeUnit.NANOSECONDS);
                if (this._minConsumingFreshnessTimeMs != Long.MAX_VALUE) {
                    brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.FRESHNESS_LAG_MS, System.currentTimeMillis() - this._minConsumingFreshnessTimeMs, TimeUnit.MILLISECONDS);
                }
            }
        }

        private void withNotNullLongMetadata(Map<String, String> metadata, DataTable.MetadataKey key, LongConsumer consumer) {
            String strValue = metadata.get(key.getName());
            if (strValue != null) {
                consumer.accept(Long.parseLong(strValue));
            }
        }
    }
}

