/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.BaseReduceService;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.GapfillProcessorFactory;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GapfillUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

@ThreadSafe
public class BrokerReduceService
extends BaseReduceService {
    public BrokerReduceService(PinotConfiguration config) {
        super(config);
    }

    public BrokerResponseNative reduceOnDataTable(BrokerRequest brokerRequest, BrokerRequest serverBrokerRequest, Map<ServerRoutingInstance, DataTable> dataTableMap, long reduceTimeOutMs, @Nullable BrokerMetrics brokerMetrics) {
        QueryContext queryContext;
        if (dataTableMap.isEmpty()) {
            return BrokerResponseNative.empty();
        }
        Map queryOptions = brokerRequest.getPinotQuery().getQueryOptions();
        boolean enableTrace = queryOptions != null && Boolean.parseBoolean((String)queryOptions.get("trace"));
        BaseReduceService.ExecutionStatsAggregator aggregator = new BaseReduceService.ExecutionStatsAggregator(enableTrace);
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        DataSchema cachedDataSchema = null;
        Iterator<Map.Entry<ServerRoutingInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerRoutingInstance, DataTable> entry = iterator.next();
            DataTable dataTable = entry.getValue();
            aggregator.aggregate(entry.getKey(), dataTable);
            DataSchema dataSchema = dataTable.getDataSchema();
            if (dataSchema == null) {
                iterator.remove();
                continue;
            }
            if (dataTable.getNumberOfRows() == 0) {
                if (cachedDataSchema == null) {
                    cachedDataSchema = dataSchema;
                }
                iterator.remove();
                continue;
            }
            cachedDataSchema = dataSchema;
        }
        String tableName = serverBrokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        aggregator.setStats(rawTableName, brokerResponseNative, brokerMetrics);
        if (cachedDataSchema == null) {
            return brokerResponseNative;
        }
        QueryContext serverQueryContext = QueryContextConverterUtils.getQueryContext(serverBrokerRequest.getPinotQuery());
        DataTableReducer dataTableReducer = ResultReducerFactory.getResultReducer(serverQueryContext);
        dataTableReducer.reduceAndSetResults(rawTableName, cachedDataSchema, dataTableMap, brokerResponseNative, new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs, this._groupByTrimThreshold), brokerMetrics);
        if (brokerRequest == serverBrokerRequest) {
            queryContext = serverQueryContext;
        } else {
            queryContext = QueryContextConverterUtils.getQueryContext(brokerRequest.getPinotQuery());
            GapfillUtils.GapfillType gapfillType = GapfillUtils.getGapfillType(queryContext);
            BaseGapfillProcessor gapfillProcessor = GapfillProcessorFactory.getGapfillProcessor(queryContext, gapfillType);
            gapfillProcessor.process(brokerResponseNative);
        }
        if (!serverQueryContext.isExplain()) {
            BrokerReduceService.updateAlias(queryContext, brokerResponseNative);
        }
        return brokerResponseNative;
    }

    @Override
    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

