/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionFactory;
import org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.GapfillFilterHandler;
import org.apache.pinot.core.query.reduce.RowBasedBlockValSet;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;

public class GapfillProcessor
extends BaseGapfillProcessor {
    private final Set<Key> _groupByKeys;
    private final Map<String, ExpressionContext> _fillExpressions = GapfillUtils.getFillExpressions(this._gapFillSelection);
    private int[] _sourceColumnIndexForResultSchema = null;

    GapfillProcessor(QueryContext queryContext, GapfillUtils.GapfillType gapfillType) {
        super(queryContext, gapfillType);
        this._groupByKeys = new HashSet<Key>();
    }

    @Override
    public void process(BrokerResponseNative brokerResponseNative) {
        DataSchema dataSchema = brokerResponseNative.getResultTable().getDataSchema();
        DataSchema resultTableSchema = this.getResultTableDataSchema(dataSchema);
        if (brokerResponseNative.getResultTable().getRows().isEmpty()) {
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, Collections.emptyList()));
            return;
        }
        String[] columns = dataSchema.getColumnNames();
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            indexes.put(columns[i], i);
        }
        this._isGroupBySelections = new boolean[dataSchema.getColumnDataTypes().length];
        for (ExpressionContext entityColum : this._timeSeries) {
            int index = (Integer)indexes.get(entityColum.getIdentifier());
            this._isGroupBySelections[index] = true;
        }
        for (int i = 0; i < this._isGroupBySelections.length; ++i) {
            if (!this._isGroupBySelections[i]) continue;
            this._groupByKeyIndexes.add(i);
        }
        List<Object[]>[] timeBucketedRawRows = this.putRawRowsIntoTimeBucket(brokerResponseNative.getResultTable().getRows());
        this.replaceColumnNameWithAlias(dataSchema);
        if (this._queryContext.getAggregationFunctions() == null) {
            int i;
            HashMap<String, Integer> sourceColumnsIndexes = new HashMap<String, Integer>();
            for (i = 0; i < dataSchema.getColumnNames().length; ++i) {
                sourceColumnsIndexes.put(dataSchema.getColumnName(i), i);
            }
            this._sourceColumnIndexForResultSchema = new int[resultTableSchema.getColumnNames().length];
            for (i = 0; i < this._sourceColumnIndexForResultSchema.length; ++i) {
                this._sourceColumnIndexForResultSchema[i] = (Integer)sourceColumnsIndexes.get(resultTableSchema.getColumnName(i));
            }
        }
        List<Object[]> resultRows = this.gapFillAndAggregate(timeBucketedRawRows, resultTableSchema, dataSchema);
        brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, resultRows));
    }

    private List<Object[]> gapFillAndAggregate(List<Object[]>[] timeBucketedRawRows, DataSchema dataSchemaForAggregatedResult, DataSchema dataSchema) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        GapfillFilterHandler postGapfillFilterHandler = null;
        if (this._queryContext.getSubquery() != null && this._queryContext.getFilter() != null) {
            postGapfillFilterHandler = new GapfillFilterHandler(this._queryContext.getFilter(), dataSchema);
        }
        GapfillFilterHandler postAggregateHavingFilterHandler = null;
        if (this._queryContext.getHavingFilter() != null) {
            postAggregateHavingFilterHandler = new GapfillFilterHandler(this._queryContext.getHavingFilter(), dataSchemaForAggregatedResult);
        }
        long start = this._startMs;
        DataSchema.ColumnDataType[] resultColumnDataTypes = dataSchema.getColumnDataTypes();
        ArrayList<Object[]> bucketedResult = new ArrayList<Object[]>();
        for (long time = this._startMs; time < this._endMs; time += this._gapfillTimeBucketSize) {
            int index = this.findGapfillBucketIndex(time);
            this.gapfill(time, bucketedResult, timeBucketedRawRows[index], dataSchema, postGapfillFilterHandler);
            if (this._queryContext.getAggregationFunctions() == null) {
                for (Object[] row : bucketedResult) {
                    Object[] resultRow = new Object[this._sourceColumnIndexForResultSchema.length];
                    for (int i = 0; i < this._sourceColumnIndexForResultSchema.length; ++i) {
                        resultRow[i] = row[this._sourceColumnIndexForResultSchema[i]];
                    }
                    result.add(resultRow);
                }
                bucketedResult.clear();
                continue;
            }
            if (index % this._aggregationSize != this._aggregationSize - 1) continue;
            if (bucketedResult.size() > 0) {
                Object timeCol = resultColumnDataTypes[this._timeBucketColumnIndex] == DataSchema.ColumnDataType.LONG ? Long.valueOf(this._dateTimeFormatter.fromMillisToFormat(start)) : this._dateTimeFormatter.fromMillisToFormat(start);
                List<Object[]> aggregatedRows = this.aggregateGapfilledData(timeCol, bucketedResult, dataSchema);
                for (Object[] aggregatedRow : aggregatedRows) {
                    if (postAggregateHavingFilterHandler == null || postAggregateHavingFilterHandler.isMatch(aggregatedRow)) {
                        result.add(aggregatedRow);
                    }
                    if (result.size() < this._limitForAggregatedResult) continue;
                    return result;
                }
                bucketedResult.clear();
            }
            start = time + this._gapfillTimeBucketSize;
        }
        return result;
    }

    private void gapfill(long bucketTime, List<Object[]> bucketedResult, List<Object[]> rawRowsForBucket, DataSchema dataSchema, GapfillFilterHandler postGapfillFilterHandler) {
        DataSchema.ColumnDataType[] resultColumnDataTypes = dataSchema.getColumnDataTypes();
        int numResultColumns = resultColumnDataTypes.length;
        HashSet<Key> keys = new HashSet<Key>(this._groupByKeys);
        if (rawRowsForBucket != null) {
            for (Object[] resultRow : rawRowsForBucket) {
                for (int i = 0; i < resultColumnDataTypes.length; ++i) {
                    resultRow[i] = resultColumnDataTypes[i].format(resultRow[i]);
                }
                long timeCol = this._dateTimeFormatter.fromFormatToMillis(String.valueOf(resultRow[0]));
                if (timeCol > bucketTime) break;
                if (timeCol != bucketTime) continue;
                if (postGapfillFilterHandler == null || postGapfillFilterHandler.isMatch(resultRow)) {
                    if (bucketedResult.size() >= this._limitForGapfilledResult) {
                        this._limitForGapfilledResult = 0;
                        break;
                    }
                    bucketedResult.add(resultRow);
                }
                Key key = this.constructGroupKeys(resultRow);
                keys.remove(key);
                this._previousByGroupKey.put(key, resultRow);
            }
        }
        for (Key key : keys) {
            Object[] gapfillRow = new Object[numResultColumns];
            int keyIndex = 0;
            gapfillRow[0] = resultColumnDataTypes[this._timeBucketColumnIndex] == DataSchema.ColumnDataType.LONG ? Long.valueOf(this._dateTimeFormatter.fromMillisToFormat(bucketTime)) : this._dateTimeFormatter.fromMillisToFormat(bucketTime);
            for (int i = 1; i < this._isGroupBySelections.length; ++i) {
                gapfillRow[i] = this._isGroupBySelections[i] ? key.getValues()[keyIndex++] : this.getFillValue(i, dataSchema.getColumnName(i), key, resultColumnDataTypes[i]);
            }
            if (postGapfillFilterHandler != null && !postGapfillFilterHandler.isMatch(gapfillRow)) continue;
            if (bucketedResult.size() >= this._limitForGapfilledResult) break;
            bucketedResult.add(gapfillRow);
        }
        this._limitForGapfilledResult = this._limitForGapfilledResult > this._groupByKeys.size() ? (this._limitForGapfilledResult -= this._groupByKeys.size()) : 0;
    }

    private List<Object[]> aggregateGapfilledData(Object timeCol, List<Object[]> bucketedRows, DataSchema dataSchema) {
        int i;
        List<ExpressionContext> groupbyExpressions = this._queryContext.getGroupByExpressions();
        Preconditions.checkArgument((groupbyExpressions != null ? 1 : 0) != 0, (Object)"No GroupBy Clause.");
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < dataSchema.getColumnNames().length; ++i2) {
            indexes.put(dataSchema.getColumnName(i2), i2);
        }
        for (Object[] bucketedRow : bucketedRows) {
            bucketedRow[this._timeBucketColumnIndex] = timeCol;
        }
        HashMap groupKeyIndexes = new HashMap();
        int[] groupKeyArray = new int[bucketedRows.size()];
        ArrayList<Object[]> aggregatedResult = new ArrayList<Object[]>();
        for (int i3 = 0; i3 < bucketedRows.size(); ++i3) {
            Object[] bucketedRow = bucketedRows.get(i3);
            ArrayList<Object> groupKey = new ArrayList<Object>(groupbyExpressions.size());
            for (ExpressionContext groupbyExpression : groupbyExpressions) {
                int columnIndex = (Integer)indexes.get(groupbyExpression.toString());
                groupKey.add(bucketedRow[columnIndex]);
            }
            if (groupKeyIndexes.containsKey(groupKey)) {
                groupKeyArray[i3] = (Integer)groupKeyIndexes.get(groupKey);
                continue;
            }
            groupKeyArray[i3] = groupKeyIndexes.size();
            groupKeyIndexes.put(groupKey, groupKeyIndexes.size());
            Object[] row = new Object[this._queryContext.getSelectExpressions().size()];
            for (int j = 0; j < this._queryContext.getSelectExpressions().size(); ++j) {
                ExpressionContext expressionContext = this._queryContext.getSelectExpressions().get(j);
                if (expressionContext.getType() == ExpressionContext.Type.FUNCTION) continue;
                row[j] = bucketedRow[(Integer)indexes.get(expressionContext.toString())];
            }
            aggregatedResult.add(row);
        }
        HashMap<ExpressionContext, BlockValSet> blockValSetMap = new HashMap<ExpressionContext, BlockValSet>();
        for (i = 1; i < dataSchema.getColumnNames().length; ++i) {
            blockValSetMap.put(ExpressionContext.forIdentifier((String)dataSchema.getColumnName(i)), new RowBasedBlockValSet(dataSchema.getColumnDataType(i), bucketedRows, i));
        }
        for (i = 0; i < this._queryContext.getSelectExpressions().size(); ++i) {
            ExpressionContext expressionContext = this._queryContext.getSelectExpressions().get(i);
            if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) continue;
            FunctionContext functionContext = expressionContext.getFunction();
            AggregationFunction aggregationFunction = AggregationFunctionFactory.getAggregationFunction(functionContext, this._queryContext);
            GroupByResultHolder groupByResultHolder = aggregationFunction.createGroupByResultHolder(groupKeyIndexes.size(), groupKeyIndexes.size());
            if (aggregationFunction instanceof CountAggregationFunction) {
                aggregationFunction.aggregateGroupBySV(bucketedRows.size(), groupKeyArray, groupByResultHolder, new HashMap<ExpressionContext, BlockValSet>());
            } else {
                aggregationFunction.aggregateGroupBySV(bucketedRows.size(), groupKeyArray, groupByResultHolder, blockValSetMap);
            }
            for (int j = 0; j < groupKeyIndexes.size(); ++j) {
                Object[] row = (Object[])aggregatedResult.get(j);
                row[i] = aggregationFunction.extractGroupByResult(groupByResultHolder, j);
                row[i] = aggregationFunction.extractFinalResult(row[i]);
            }
        }
        return aggregatedResult;
    }

    private Object getFillValue(int columnIndex, String columnName, Object key, DataSchema.ColumnDataType dataType) {
        ExpressionContext expressionContext = this._fillExpressions.get(columnName);
        if (expressionContext != null && expressionContext.getFunction() != null && GapfillUtils.isFill(expressionContext)) {
            List args = expressionContext.getFunction().getArguments();
            if (((ExpressionContext)args.get(1)).getLiteral() == null) {
                throw new UnsupportedOperationException("Wrong Sql.");
            }
            GapfillUtils.FillType fillType = GapfillUtils.FillType.valueOf(((ExpressionContext)args.get(1)).getLiteral());
            if (fillType == GapfillUtils.FillType.FILL_DEFAULT_VALUE) {
                return GapfillUtils.getDefaultValue(dataType);
            }
            if (fillType == GapfillUtils.FillType.FILL_PREVIOUS_VALUE) {
                Object[] row = (Object[])this._previousByGroupKey.get(key);
                if (row != null) {
                    return row[columnIndex];
                }
                return GapfillUtils.getDefaultValue(dataType);
            }
            throw new UnsupportedOperationException("unsupported fill type.");
        }
        return GapfillUtils.getDefaultValue(dataType);
    }

    private List<Object[]>[] putRawRowsIntoTimeBucket(List<Object[]> rows) {
        List[] bucketedItems = new List[this._numOfTimeBuckets];
        for (Object[] row : rows) {
            long timeBucket = this._dateTimeFormatter.fromFormatToMillis(String.valueOf(row[this._timeBucketColumnIndex]));
            int index = this.findGapfillBucketIndex(timeBucket);
            if (index >= this._numOfTimeBuckets) continue;
            Key key = this.constructGroupKeys(row);
            this._groupByKeys.add(key);
            if (index < 0) {
                this._previousByGroupKey.compute(key, (k, previousRow) -> {
                    if (previousRow == null) {
                        return row;
                    }
                    long previousTimeBucket = this._dateTimeFormatter.fromFormatToMillis(String.valueOf(previousRow[this._timeBucketColumnIndex]));
                    if (timeBucket > previousTimeBucket) {
                        return row;
                    }
                    return previousRow;
                });
                continue;
            }
            if (bucketedItems[index] == null) {
                bucketedItems[index] = new ArrayList();
            }
            bucketedItems[index].add(row);
        }
        return bucketedItems;
    }
}

