/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RowBasedBlockValSet
implements BlockValSet {
    private final FieldSpec.DataType _dataType;
    private final PinotDataType _pinotDataType;
    private final List<Object[]> _rows;
    private final int _columnIndex;

    public RowBasedBlockValSet(DataSchema.ColumnDataType columnDataType, List<Object[]> rows, int columnIndex) {
        this._dataType = columnDataType.toDataType();
        this._pinotDataType = PinotDataType.getPinotDataTypeForExecution((DataSchema.ColumnDataType)columnDataType);
        this._rows = rows;
        this._columnIndex = columnIndex;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        return null;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataType;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] getDictionaryIdsSV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getIntValuesSV() {
        int length = this._rows.size();
        int[] values = new int[length];
        if (this._dataType.isNumeric()) {
            for (int i = 0; i < length; ++i) {
                values[i] = ((Number)this._rows.get(i)[this._columnIndex]).intValue();
            }
        } else if (this._dataType == FieldSpec.DataType.STRING) {
            for (int i = 0; i < length; ++i) {
                values[i] = Integer.parseInt((String)this._rows.get(i)[this._columnIndex]);
            }
        } else {
            throw new IllegalStateException("Cannot read int values from data type: " + this._dataType);
        }
        return values;
    }

    @Override
    public long[] getLongValuesSV() {
        int length = this._rows.size();
        long[] values = new long[length];
        if (this._dataType.isNumeric()) {
            for (int i = 0; i < length; ++i) {
                values[i] = ((Number)this._rows.get(i)[this._columnIndex]).longValue();
            }
        } else if (this._dataType == FieldSpec.DataType.STRING) {
            for (int i = 0; i < length; ++i) {
                values[i] = Long.parseLong((String)this._rows.get(i)[this._columnIndex]);
            }
        } else {
            throw new IllegalStateException("Cannot read long values from data type: " + this._dataType);
        }
        return values;
    }

    @Override
    public float[] getFloatValuesSV() {
        int length = this._rows.size();
        float[] values = new float[length];
        if (this._dataType.isNumeric()) {
            for (int i = 0; i < length; ++i) {
                values[i] = ((Number)this._rows.get(i)[this._columnIndex]).floatValue();
            }
        } else if (this._dataType == FieldSpec.DataType.STRING) {
            for (int i = 0; i < length; ++i) {
                values[i] = Float.parseFloat((String)this._rows.get(i)[this._columnIndex]);
            }
        } else {
            throw new IllegalStateException("Cannot read float values from data type: " + this._dataType);
        }
        return values;
    }

    @Override
    public double[] getDoubleValuesSV() {
        int length = this._rows.size();
        double[] values = new double[length];
        if (this._dataType.isNumeric()) {
            for (int i = 0; i < length; ++i) {
                values[i] = ((Number)this._rows.get(i)[this._columnIndex]).doubleValue();
            }
        } else if (this._dataType == FieldSpec.DataType.STRING) {
            for (int i = 0; i < length; ++i) {
                values[i] = Double.parseDouble((String)this._rows.get(i)[this._columnIndex]);
            }
        } else {
            throw new IllegalStateException("Cannot read double values from data type: " + this._dataType);
        }
        return values;
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        int length = this._rows.size();
        BigDecimal[] values = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this._pinotDataType.toBigDecimal(this._rows.get(i)[this._columnIndex]);
        }
        return values;
    }

    @Override
    public String[] getStringValuesSV() {
        int length = this._rows.size();
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this._rows.get(i)[this._columnIndex].toString();
        }
        return values;
    }

    @Override
    public byte[][] getBytesValuesSV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getIntValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] getLongValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] getFloatValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getDoubleValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] getStringValuesMV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getNumMVEntries() {
        throw new UnsupportedOperationException();
    }
}

