/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class QueryContextConverterUtils {
    private QueryContextConverterUtils() {
    }

    public static QueryContext getQueryContext(String query) {
        return QueryContextConverterUtils.getQueryContext(CalciteSqlParser.compileToPinotQuery((String)query));
    }

    public static QueryContext getQueryContext(PinotQuery pinotQuery) {
        DataSource dataSource = pinotQuery.getDataSource();
        String tableName = dataSource.getTableName();
        QueryContext subquery = null;
        if (dataSource.getSubquery() != null) {
            subquery = QueryContextConverterUtils.getQueryContext(dataSource.getSubquery());
        }
        List selectList = pinotQuery.getSelectList();
        ArrayList<String> aliasList = new ArrayList<String>(selectList.size());
        ArrayList<ExpressionContext> selectExpressions = new ArrayList<ExpressionContext>(selectList.size());
        Iterator iterator = selectList.iterator();
        while (iterator.hasNext()) {
            Expression expressionWithoutAlias;
            block21: {
                block20: {
                    Expression thriftExpression;
                    expressionWithoutAlias = thriftExpression = (Expression)iterator.next();
                    if (thriftExpression.getType() != ExpressionType.FUNCTION) break block20;
                    Function function = thriftExpression.getFunctionCall();
                    List operands = function.getOperands();
                    switch (function.getOperator().toUpperCase()) {
                        case "AS": {
                            expressionWithoutAlias = (Expression)operands.get(0);
                            aliasList.add(((Expression)operands.get(1)).getIdentifier().getName());
                            break;
                        }
                        case "DISTINCT": {
                            int numOperands = operands.size();
                            for (int i = 0; i < numOperands; ++i) {
                                Expression operand = (Expression)operands.get(i);
                                Function operandFunction = operand.getFunctionCall();
                                if (operandFunction != null && operandFunction.getOperator().equalsIgnoreCase("AS")) {
                                    operands.set(i, (Expression)operandFunction.getOperands().get(0));
                                    aliasList.add(((Expression)operandFunction.getOperands().get(1)).getIdentifier().getName());
                                    continue;
                                }
                                aliasList.add(null);
                            }
                            break block21;
                        }
                        default: {
                            aliasList.add(null);
                        }
                    }
                    break block21;
                }
                aliasList.add(null);
            }
            selectExpressions.add(RequestContextUtils.getExpression((Expression)expressionWithoutAlias));
        }
        FilterContext filter = null;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            filter = RequestContextUtils.getFilter((Expression)filterExpression);
        }
        ArrayList<ExpressionContext> groupByExpressions = null;
        List groupByList = pinotQuery.getGroupByList();
        if (CollectionUtils.isNotEmpty((Collection)groupByList)) {
            groupByExpressions = new ArrayList<ExpressionContext>(groupByList.size());
            for (Expression thriftExpression : groupByList) {
                groupByExpressions.add(RequestContextUtils.getExpression((Expression)thriftExpression));
            }
        }
        ArrayList<OrderByExpressionContext> orderByExpressions = null;
        List orderByList = pinotQuery.getOrderByList();
        if (CollectionUtils.isNotEmpty((Collection)orderByList)) {
            orderByExpressions = new ArrayList<OrderByExpressionContext>(orderByList.size());
            HashSet<ExpressionContext> expressionSet = new HashSet<ExpressionContext>();
            for (Expression orderBy : orderByList) {
                Function thriftFunction = orderBy.getFunctionCall();
                ExpressionContext expression = RequestContextUtils.getExpression((Expression)((Expression)thriftFunction.getOperands().get(0)));
                if (!expressionSet.add(expression)) continue;
                boolean isAsc = thriftFunction.getOperator().equalsIgnoreCase("ASC");
                orderByExpressions.add(new OrderByExpressionContext(expression, isAsc));
            }
        }
        FilterContext havingFilter = null;
        Expression havingExpression = pinotQuery.getHavingExpression();
        if (havingExpression != null) {
            havingFilter = RequestContextUtils.getFilter((Expression)havingExpression);
        }
        HashMap<ExpressionContext, ExpressionContext> expressionContextOverrideHints = new HashMap<ExpressionContext, ExpressionContext>();
        Map expressionOverrideHints = pinotQuery.getExpressionOverrideHints();
        if (expressionOverrideHints != null) {
            for (Map.Entry entry : expressionOverrideHints.entrySet()) {
                expressionContextOverrideHints.put(RequestContextUtils.getExpression((Expression)((Expression)entry.getKey())), RequestContextUtils.getExpression((Expression)((Expression)entry.getValue())));
            }
        }
        return new QueryContext.Builder().setTableName(tableName).setSubquery(subquery).setSelectExpressions(selectExpressions).setAliasList(aliasList).setFilter(filter).setGroupByExpressions(groupByExpressions).setOrderByExpressions(orderByExpressions).setHavingFilter(havingFilter).setLimit(pinotQuery.getLimit()).setOffset(pinotQuery.getOffset()).setQueryOptions(pinotQuery.getQueryOptions()).setExpressionOverrideHints(expressionContextOverrideHints).setExplain(pinotQuery.isExplain()).build();
    }
}

