/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOperatorService {
    private final QueryContext _queryContext;
    private final List<String> _selectionColumns;
    private final DataSchema _dataSchema;
    private final int _offset;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;

    public SelectionOperatorService(QueryContext queryContext, DataSchema dataSchema) {
        this._queryContext = queryContext;
        this._selectionColumns = SelectionOperatorUtils.getSelectionColumns(queryContext, dataSchema);
        this._dataSchema = dataSchema;
        this._offset = queryContext.getOffset();
        this._numRowsToKeep = this._offset + queryContext.getLimit();
        assert (queryContext.getOrderByExpressions() != null);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), this.getTypeCompatibleComparator(queryContext.getOrderByExpressions()));
    }

    private Comparator<Object[]> getTypeCompatibleComparator(List<OrderByExpressionContext> orderByExpressions) {
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        int numOrderByExpressions = orderByExpressions.size();
        ArrayList<Integer> valueIndexList = new ArrayList<Integer>(numOrderByExpressions);
        for (int i = 0; i < numOrderByExpressions; ++i) {
            if (columnDataTypes[i].isArray()) continue;
            valueIndexList.add(i);
        }
        int numValuesToCompare = valueIndexList.size();
        int[] valueIndices = new int[numValuesToCompare];
        boolean[] useDoubleComparison = new boolean[numValuesToCompare];
        int[] multipliers = new int[numValuesToCompare];
        for (int i = 0; i < numValuesToCompare; ++i) {
            int valueIndex;
            valueIndices[i] = valueIndex = ((Integer)valueIndexList.get(i)).intValue();
            if (columnDataTypes[valueIndex].isNumber()) {
                useDoubleComparison[i] = true;
            }
            multipliers[i] = orderByExpressions.get(valueIndex).isAsc() ? -1 : 1;
        }
        if (this._queryContext.isNullHandlingEnabled()) {
            return (o1, o2) -> {
                for (int i = 0; i < numValuesToCompare; ++i) {
                    int index = valueIndices[i];
                    Object v1 = o1[index];
                    Object v2 = o2[index];
                    if (v1 == null) {
                        return v2 == null ? 0 : -multipliers[i];
                    }
                    if (v2 == null) {
                        return multipliers[i];
                    }
                    int result = useDoubleComparison[i] ? Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue()) : ((Comparable)v1).compareTo(v2);
                    if (result == 0) continue;
                    return result * multipliers[i];
                }
                return 0;
            };
        }
        return (o1, o2) -> {
            for (int i = 0; i < numValuesToCompare; ++i) {
                int index = valueIndices[i];
                Object v1 = o1[index];
                Object v2 = o2[index];
                int result = useDoubleComparison[i] ? Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue()) : ((Comparable)v1).compareTo(v2);
                if (result == 0) continue;
                return result * multipliers[i];
            }
            return 0;
        };
    }

    public PriorityQueue<Object[]> getRows() {
        return this._rows;
    }

    public void reduceWithOrdering(Collection<DataTable> dataTables, boolean nullHandlingEnabled) {
        for (DataTable dataTable : dataTables) {
            int numRows = dataTable.getNumberOfRows();
            if (nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[dataTable.getDataSchema().size()];
                for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                    nullBitmaps[colId] = dataTable.getNullRowIds(colId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                    for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows; ++rowId) {
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
            }
        }
    }

    public ResultTable renderResultTableWithOrdering() {
        int[] columnIndices = SelectionOperatorUtils.getColumnIndices(this._selectionColumns, this._dataSchema);
        int numColumns = columnIndices.length;
        String[] columnNames = this._dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        String[] resultColumnNames = new String[numColumns];
        DataSchema.ColumnDataType[] resultColumnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int columnIndex = columnIndices[i];
            resultColumnNames[i] = columnNames[columnIndex];
            resultColumnDataTypes[i] = columnDataTypes[columnIndex];
        }
        DataSchema resultDataSchema = new DataSchema(resultColumnNames, resultColumnDataTypes);
        LinkedList<Object[]> rowsInSelectionResults = new LinkedList<Object[]>();
        while (this._rows.size() > this._offset) {
            Object[] row = this._rows.poll();
            assert (row != null);
            Object[] extractedRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = row[columnIndices[i]];
                if (value == null) continue;
                extractedRow[i] = resultColumnDataTypes[i].convertAndFormat(value);
            }
            rowsInSelectionResults.addFirst(extractedRow);
        }
        return new ResultTable(resultDataSchema, rowsInSelectionResults);
    }
}

