/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.core.segment.processing.mapper.SegmentMapper;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.core.segment.processing.reducer.ReducerFactory;
import org.apache.pinot.segment.local.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGeneratorFactory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentProcessorFramework {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentProcessorFramework.class);
    private final List<RecordReader> _recordReaders;
    private final SegmentProcessorConfig _segmentProcessorConfig;
    private final File _mapperOutputDir;
    private final File _reducerOutputDir;
    private final File _segmentsOutputDir;

    public SegmentProcessorFramework(List<RecordReader> recordReaders, SegmentProcessorConfig segmentProcessorConfig, File workingDir) throws IOException {
        Preconditions.checkState((!recordReaders.isEmpty() ? 1 : 0) != 0, (Object)"No record reader is provided");
        LOGGER.info("Initializing SegmentProcessorFramework with {} record readers, config: {}, working dir: {}", new Object[]{recordReaders.size(), segmentProcessorConfig, workingDir.getAbsolutePath()});
        this._recordReaders = recordReaders;
        this._segmentProcessorConfig = segmentProcessorConfig;
        this._mapperOutputDir = new File(workingDir, "mapper_output");
        FileUtils.forceMkdir((File)this._mapperOutputDir);
        this._reducerOutputDir = new File(workingDir, "reducer_output");
        FileUtils.forceMkdir((File)this._reducerOutputDir);
        this._segmentsOutputDir = new File(workingDir, "segments_output");
        FileUtils.forceMkdir((File)this._segmentsOutputDir);
    }

    public List<File> process() throws Exception {
        LOGGER.info("Beginning map phase on {} record readers", (Object)this._recordReaders.size());
        SegmentMapper mapper = new SegmentMapper(this._recordReaders, this._segmentProcessorConfig, this._mapperOutputDir);
        Map<String, GenericRowFileManager> partitionToFileManagerMap = mapper.map();
        if (partitionToFileManagerMap.isEmpty()) {
            LOGGER.info("No partition generated from mapper phase, skipping the reducer phase");
            return Collections.emptyList();
        }
        LOGGER.info("Beginning reduce phase on partitions: {}", partitionToFileManagerMap.keySet());
        for (Map.Entry<String, GenericRowFileManager> entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = entry.getKey();
            GenericRowFileManager fileManager = entry.getValue();
            Reducer reducer = ReducerFactory.getReducer(partitionId, fileManager, this._segmentProcessorConfig, this._reducerOutputDir);
            entry.setValue(reducer.reduce());
        }
        LOGGER.info("Beginning segment creation phase on partitions: {}", partitionToFileManagerMap.keySet());
        ArrayList<File> outputSegmentDirs = new ArrayList<File>();
        TableConfig tableConfig = this._segmentProcessorConfig.getTableConfig();
        Schema schema = this._segmentProcessorConfig.getSchema();
        String segmentNamePrefix = this._segmentProcessorConfig.getSegmentConfig().getSegmentNamePrefix();
        String segmentNamePostfix = this._segmentProcessorConfig.getSegmentConfig().getSegmentNamePostfix();
        String fixedSegmentName = this._segmentProcessorConfig.getSegmentConfig().getFixedSegmentName();
        SegmentGeneratorConfig generatorConfig = new SegmentGeneratorConfig(tableConfig, schema);
        generatorConfig.setOutDir(this._segmentsOutputDir.getPath());
        if (tableConfig.getIndexingConfig().getSegmentNameGeneratorType() != null) {
            generatorConfig.setSegmentNameGenerator(SegmentNameGeneratorFactory.createSegmentNameGenerator((TableConfig)tableConfig, (Schema)schema, (String)segmentNamePrefix, (String)segmentNamePostfix, (String)fixedSegmentName, (boolean)false));
        } else {
            generatorConfig.setSegmentNamePrefix(segmentNamePrefix);
            generatorConfig.setSegmentNamePostfix(segmentNamePostfix);
        }
        int maxNumRecordsPerSegment = this._segmentProcessorConfig.getSegmentConfig().getMaxNumRecordsPerSegment();
        int sequenceId = 0;
        for (Map.Entry<String, GenericRowFileManager> entry : partitionToFileManagerMap.entrySet()) {
            String partitionId = entry.getKey();
            GenericRowFileManager fileManager = entry.getValue();
            GenericRowFileReader fileReader = fileManager.getFileReader();
            int numRows = fileReader.getNumRows();
            int numSortFields = fileReader.getNumSortFields();
            LOGGER.info("Start creating segments on partition: {}, numRows: {}, numSortFields: {}", new Object[]{partitionId, numRows, numSortFields});
            GenericRowFileRecordReader recordReader = fileReader.getRecordReader();
            int startRowId = 0;
            while (startRowId < numRows) {
                int endRowId = Math.min(startRowId + maxNumRecordsPerSegment, numRows);
                LOGGER.info("Start creating segment of sequenceId: {} with row range: {} to {}", new Object[]{sequenceId, startRowId, endRowId});
                generatorConfig.setSequenceId(sequenceId);
                GenericRowFileRecordReader recordReaderForRange = recordReader.getRecordReaderForRange(startRowId, endRowId);
                SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
                driver.init(generatorConfig, (SegmentCreationDataSource)new RecordReaderSegmentCreationDataSource((RecordReader)recordReaderForRange), TransformPipeline.getPassThroughPipeline());
                driver.build();
                outputSegmentDirs.add(driver.getOutputDirectory());
                startRowId += maxNumRecordsPerSegment;
                ++sequenceId;
            }
            fileManager.cleanUp();
        }
        FileUtils.deleteDirectory((File)this._mapperOutputDir);
        FileUtils.deleteDirectory((File)this._reducerOutputDir);
        LOGGER.info("Successfully created segments: {}", outputSegmentDirs);
        return outputSegmentDirs;
    }
}

