/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import it.unimi.dsi.fastutil.Arrays;
import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class GenericRowFileRecordReader
implements RecordReader {
    private final GenericRowFileReader _fileReader;
    private final int _startRowId;
    private final int _endRowId;
    private final int[] _sortedRowIds;
    private int _nextRowId;

    public GenericRowFileRecordReader(GenericRowFileReader fileReader) {
        this._fileReader = fileReader;
        int numRows = fileReader.getNumRows();
        this._startRowId = 0;
        this._endRowId = numRows;
        if (fileReader.getNumSortFields() > 0) {
            this._sortedRowIds = new int[numRows];
            for (int i = 0; i < numRows; ++i) {
                this._sortedRowIds[i] = i;
            }
            Arrays.quickSort((int)0, (int)this._endRowId, (i1, i2) -> this._fileReader.compare(this._sortedRowIds[i1], this._sortedRowIds[i2]), (i1, i2) -> {
                int temp = this._sortedRowIds[i1];
                this._sortedRowIds[i1] = this._sortedRowIds[i2];
                this._sortedRowIds[i2] = temp;
            });
        } else {
            this._sortedRowIds = null;
        }
    }

    private GenericRowFileRecordReader(GenericRowFileReader fileReader, int startRowId, int endRowId, @Nullable int[] sortedRowIds) {
        this._fileReader = fileReader;
        this._startRowId = startRowId;
        this._endRowId = endRowId;
        this._sortedRowIds = sortedRowIds;
        this._nextRowId = startRowId;
    }

    public GenericRowFileRecordReader getRecordReaderForRange(int startRowId, int endRowId) {
        return new GenericRowFileRecordReader(this._fileReader, startRowId, endRowId, this._sortedRowIds);
    }

    public void read(int rowId, GenericRow buffer) {
        if (this._sortedRowIds != null) {
            rowId = this._sortedRowIds[rowId];
        }
        this._fileReader.read(rowId, buffer);
    }

    public int compare(int rowId1, int rowId2) {
        assert (this._sortedRowIds != null);
        return this._fileReader.compare(this._sortedRowIds[rowId1], this._sortedRowIds[rowId2]);
    }

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this._nextRowId < this._endRowId;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        int n;
        if (this._sortedRowIds != null) {
            n = this._sortedRowIds[this._nextRowId++];
        } else {
            int n2 = this._nextRowId;
            n = n2;
            this._nextRowId = n2 + 1;
        }
        int rowId = n;
        this._fileReader.read(rowId, reuse);
        return reuse;
    }

    public void rewind() {
        this._nextRowId = this._startRowId;
    }

    public void close() {
    }
}

