/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public class GenericRowSerializer {
    private final int _numFields;
    private final String[] _fieldNames;
    private final boolean[] _isSingleValueFields;
    private final FieldSpec.DataType[] _storedTypes;
    private final Object[] _stringBytes;
    private final Map<String, Integer> _fieldIndexMap;
    private final int[] _nullFieldIndexes;

    public GenericRowSerializer(List<FieldSpec> fieldSpecs, boolean includeNullFields) {
        int i;
        this._numFields = fieldSpecs.size();
        this._fieldNames = new String[this._numFields];
        this._isSingleValueFields = new boolean[this._numFields];
        this._storedTypes = new FieldSpec.DataType[this._numFields];
        this._stringBytes = new Object[this._numFields];
        for (i = 0; i < this._numFields; ++i) {
            FieldSpec fieldSpec = fieldSpecs.get(i);
            this._fieldNames[i] = fieldSpec.getName();
            this._isSingleValueFields[i] = fieldSpec.isSingleValueField();
            this._storedTypes[i] = fieldSpec.getDataType().getStoredType();
        }
        if (includeNullFields) {
            this._fieldIndexMap = new HashMap<String, Integer>();
            for (i = 0; i < this._numFields; ++i) {
                this._fieldIndexMap.put(this._fieldNames[i], i);
            }
            this._nullFieldIndexes = new int[this._numFields];
        } else {
            this._fieldIndexMap = null;
            this._nullFieldIndexes = null;
        }
    }

    public byte[] serialize(GenericRow row) {
        int i;
        int numBytes = 0;
        block30: for (int i2 = 0; i2 < this._numFields; ++i2) {
            Object value = row.getValue(this._fieldNames[i2]);
            if (this._isSingleValueFields[i2]) {
                switch (this._storedTypes[i2]) {
                    case INT: {
                        numBytes += 4;
                        continue block30;
                    }
                    case LONG: {
                        numBytes += 8;
                        continue block30;
                    }
                    case FLOAT: {
                        numBytes += 4;
                        continue block30;
                    }
                    case DOUBLE: {
                        numBytes += 8;
                        continue block30;
                    }
                    case STRING: {
                        byte[] stringBytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                        numBytes += 4 + stringBytes.length;
                        this._stringBytes[i2] = stringBytes;
                        continue block30;
                    }
                    case BYTES: {
                        numBytes += 4 + ((byte[])value).length;
                        continue block30;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported SV stored type: " + this._storedTypes[i2]);
                    }
                }
            }
            Object[] multiValue = (Object[])value;
            int numValues = multiValue.length;
            numBytes += 4;
            switch (this._storedTypes[i2]) {
                case INT: {
                    numBytes += 4 * numValues;
                    continue block30;
                }
                case LONG: {
                    numBytes += 8 * numValues;
                    continue block30;
                }
                case FLOAT: {
                    numBytes += 4 * numValues;
                    continue block30;
                }
                case DOUBLE: {
                    numBytes += 8 * numValues;
                    continue block30;
                }
                case STRING: {
                    numBytes += 4 * numValues;
                    byte[][] stringBytesArray = new byte[numValues][];
                    for (int j = 0; j < numValues; ++j) {
                        byte[] byArray = ((String)multiValue[j]).getBytes(StandardCharsets.UTF_8);
                        numBytes += byArray.length;
                        stringBytesArray[j] = byArray;
                    }
                    this._stringBytes[i2] = stringBytesArray;
                    continue block30;
                }
                default: {
                    throw new IllegalStateException("Unsupported MV stored type: " + this._storedTypes[i2]);
                }
            }
        }
        int numNullFields = 0;
        if (this._fieldIndexMap != null) {
            Set nullFields = row.getNullValueFields();
            for (String nullField : nullFields) {
                Integer nullFieldIndex = this._fieldIndexMap.get(nullField);
                if (nullFieldIndex == null) continue;
                this._nullFieldIndexes[numNullFields++] = nullFieldIndex;
            }
            Arrays.sort(this._nullFieldIndexes, 0, numNullFields);
            numBytes += 4 * (1 + numNullFields);
        }
        byte[] serializedBytes = new byte[numBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(serializedBytes).order(PinotDataBuffer.NATIVE_ORDER);
        block33: for (i = 0; i < this._numFields; ++i) {
            Object value = row.getValue(this._fieldNames[i]);
            if (this._isSingleValueFields[i]) {
                switch (this._storedTypes[i]) {
                    case INT: {
                        byteBuffer.putInt((Integer)value);
                        continue block33;
                    }
                    case LONG: {
                        byteBuffer.putLong((Long)value);
                        continue block33;
                    }
                    case FLOAT: {
                        byteBuffer.putFloat(((Float)value).floatValue());
                        continue block33;
                    }
                    case DOUBLE: {
                        byteBuffer.putDouble((Double)value);
                        continue block33;
                    }
                    case STRING: {
                        byte[] stringBytes = (byte[])this._stringBytes[i];
                        byteBuffer.putInt(stringBytes.length);
                        byteBuffer.put(stringBytes);
                        continue block33;
                    }
                    case BYTES: {
                        byte[] byArray = (byte[])value;
                        byteBuffer.putInt(byArray.length);
                        byteBuffer.put(byArray);
                        continue block33;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported SV stored type: " + this._storedTypes[i]);
                    }
                }
            }
            Object[] multiValue = (Object[])value;
            byteBuffer.putInt(multiValue.length);
            switch (this._storedTypes[i]) {
                case INT: {
                    int n;
                    Object[] objectArray = multiValue;
                    int n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        Object element = objectArray[n];
                        byteBuffer.putInt((Integer)element);
                    }
                    continue block33;
                }
                case LONG: {
                    int n;
                    Object[] objectArray = multiValue;
                    int n3 = objectArray.length;
                    for (n = 0; n < n3; ++n) {
                        Object element = objectArray[n];
                        byteBuffer.putLong((Long)element);
                    }
                    continue block33;
                }
                case FLOAT: {
                    int n;
                    Object[] objectArray = multiValue;
                    int n4 = objectArray.length;
                    for (n = 0; n < n4; ++n) {
                        Object element = objectArray[n];
                        byteBuffer.putFloat(((Float)element).floatValue());
                    }
                    continue block33;
                }
                case DOUBLE: {
                    int n;
                    Object[] objectArray = multiValue;
                    int n5 = objectArray.length;
                    for (n = 0; n < n5; ++n) {
                        Object element = objectArray[n];
                        byteBuffer.putDouble((Double)element);
                    }
                    continue block33;
                }
                case STRING: {
                    byte[][] byArray;
                    byte[][] byArray2 = byArray = (byte[][])this._stringBytes[i];
                    int n = byArray2.length;
                    for (int j = 0; j < n; ++j) {
                        byte[] stringBytes = byArray2[j];
                        byteBuffer.putInt(stringBytes.length);
                        byteBuffer.put(stringBytes);
                    }
                    continue block33;
                }
                default: {
                    throw new IllegalStateException("Unsupported MV stored type: " + this._storedTypes[i]);
                }
            }
        }
        if (this._fieldIndexMap != null) {
            byteBuffer.putInt(numNullFields);
            for (i = 0; i < numNullFields; ++i) {
                byteBuffer.putInt(this._nullFieldIndexes[i]);
            }
        }
        return serializedBytes;
    }
}

