/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.core.segment.processing.framework.MergeType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public final class SegmentProcessorUtils {
    private SegmentProcessorUtils() {
    }

    public static Pair<List<FieldSpec>, Integer> getFieldSpecs(Schema schema, MergeType mergeType, @Nullable List<String> sortOrder) {
        int numSortFields;
        if (sortOrder == null) {
            sortOrder = Collections.emptyList();
        }
        ArrayList<Object> fieldSpecs = new ArrayList<Object>();
        for (String sortColumn : sortOrder) {
            FieldSpec fieldSpec = schema.getFieldSpecFor(sortColumn);
            Preconditions.checkArgument((fieldSpec != null ? 1 : 0) != 0, (String)"Failed to find sort column: %s", (Object)sortColumn);
            Preconditions.checkArgument((boolean)fieldSpec.isSingleValueField(), (String)"Cannot sort on MV column: %s", (Object)sortColumn);
            Preconditions.checkArgument((!fieldSpec.isVirtualColumn() ? 1 : 0) != 0, (String)"Cannot sort on virtual column: %s", (Object)sortColumn);
            Preconditions.checkArgument((fieldSpec.getFieldType() != FieldSpec.FieldType.METRIC || mergeType != MergeType.ROLLUP ? 1 : 0) != 0, (String)"For ROLLUP, cannot sort on metric column: %s", (Object)sortColumn);
            fieldSpecs.add(fieldSpec);
        }
        ArrayList<FieldSpec> metricFieldSpecs = new ArrayList<FieldSpec>();
        ArrayList<FieldSpec> nonMetricFieldSpecs = new ArrayList<FieldSpec>();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || sortOrder.contains(fieldSpec.getName())) continue;
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
                metricFieldSpecs.add(fieldSpec);
                continue;
            }
            nonMetricFieldSpecs.add(fieldSpec);
        }
        metricFieldSpecs.sort(Comparator.comparing(FieldSpec::getName));
        fieldSpecs.addAll(nonMetricFieldSpecs);
        nonMetricFieldSpecs.sort(Comparator.comparing(FieldSpec::getName));
        fieldSpecs.addAll(metricFieldSpecs);
        switch (mergeType) {
            case CONCAT: {
                numSortFields = sortOrder.size();
                break;
            }
            case ROLLUP: {
                numSortFields = sortOrder.size() + nonMetricFieldSpecs.size();
                break;
            }
            case DEDUP: {
                numSortFields = fieldSpecs.size();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported merge type: " + mergeType);
            }
        }
        return new ImmutablePair(fieldSpecs, (Object)numSortFields);
    }
}

