/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.transport.QueryResponse;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerResponse;
import org.apache.pinot.core.transport.ServerRoutingInstance;

@ThreadSafe
public class AsyncQueryResponse
implements QueryResponse {
    private final QueryRouter _queryRouter;
    private final long _requestId;
    private final AtomicReference<QueryResponse.Status> _status = new AtomicReference<QueryResponse.Status>(QueryResponse.Status.IN_PROGRESS);
    private final AtomicInteger _numServersResponded = new AtomicInteger();
    private final ConcurrentHashMap<ServerRoutingInstance, ServerResponse> _responseMap;
    private final CountDownLatch _countDownLatch;
    private final long _maxEndTimeMs;
    private volatile ServerRoutingInstance _failedServer;
    private volatile Exception _exception;

    public AsyncQueryResponse(QueryRouter queryRouter, long requestId, Set<ServerRoutingInstance> serversQueried, long startTimeMs, long timeoutMs) {
        this._queryRouter = queryRouter;
        this._requestId = requestId;
        int numServersQueried = serversQueried.size();
        this._responseMap = new ConcurrentHashMap(numServersQueried);
        for (ServerRoutingInstance serverRoutingInstance : serversQueried) {
            this._responseMap.put(serverRoutingInstance, new ServerResponse(startTimeMs));
        }
        this._countDownLatch = new CountDownLatch(numServersQueried);
        this._maxEndTimeMs = startTimeMs + timeoutMs;
    }

    @Override
    public QueryResponse.Status getStatus() {
        return this._status.get();
    }

    @Override
    public int getNumServersResponded() {
        return this._numServersResponded.get();
    }

    @Override
    public Map<ServerRoutingInstance, ServerResponse> getCurrentResponses() {
        return this._responseMap;
    }

    @Override
    public Map<ServerRoutingInstance, ServerResponse> getFinalResponses() throws InterruptedException {
        try {
            boolean finish = this._countDownLatch.await(this._maxEndTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            this._status.compareAndSet(QueryResponse.Status.IN_PROGRESS, finish ? QueryResponse.Status.COMPLETED : QueryResponse.Status.TIMED_OUT);
            ConcurrentHashMap<ServerRoutingInstance, ServerResponse> concurrentHashMap = this._responseMap;
            return concurrentHashMap;
        }
        finally {
            this._queryRouter.markQueryDone(this._requestId);
        }
    }

    @Override
    public String getServerStats() {
        StringBuilder stringBuilder = new StringBuilder("(Server=SubmitDelayMs,ResponseDelayMs,ResponseSize,DeserializationTimeMs,RequestSentDelayMs)");
        for (Map.Entry<ServerRoutingInstance, ServerResponse> entry : this._responseMap.entrySet()) {
            stringBuilder.append(';').append(entry.getKey().getShortName()).append('=').append(entry.getValue().toString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public ServerRoutingInstance getFailedServer() {
        return this._failedServer;
    }

    @Override
    public Exception getException() {
        return this._exception;
    }

    void markRequestSubmitted(ServerRoutingInstance serverRoutingInstance) {
        this._responseMap.get(serverRoutingInstance).markRequestSubmitted();
    }

    void markRequestSent(ServerRoutingInstance serverRoutingInstance, long requestSentLatencyMs) {
        this._responseMap.get(serverRoutingInstance).markRequestSent(requestSentLatencyMs);
    }

    void receiveDataTable(ServerRoutingInstance serverRoutingInstance, DataTable dataTable, int responseSize, int deserializationTimeMs) {
        this._responseMap.get(serverRoutingInstance).receiveDataTable(dataTable, responseSize, deserializationTimeMs);
        this._numServersResponded.getAndIncrement();
        this._countDownLatch.countDown();
    }

    void markQueryFailed(ServerRoutingInstance serverRoutingInstance, Exception exception) {
        this._status.set(QueryResponse.Status.FAILED);
        this._failedServer = serverRoutingInstance;
        this._exception = exception;
        int count = (int)this._countDownLatch.getCount();
        for (int i = 0; i < count; ++i) {
            this._countDownLatch.countDown();
        }
    }

    void markServerDown(ServerRoutingInstance serverRoutingInstance, Exception exception) {
        ServerResponse serverResponse = this._responseMap.get(serverRoutingInstance);
        if (serverResponse != null && serverResponse.getDataTable() == null) {
            this.markQueryFailed(serverRoutingInstance, exception);
        }
    }
}

