/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.datatable.DataTableFactory;

public class QueryOptionsUtils {
    private QueryOptionsUtils() {
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        if (timeoutMsString != null) {
            long timeoutMs = Long.parseLong(timeoutMsString);
            Preconditions.checkState((timeoutMs > 0L ? 1 : 0) != 0, (String)"Query timeout must be positive, got: %s", (long)timeoutMs);
            return timeoutMs;
        }
        return null;
    }

    public static boolean isSkipUpsert(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsert"));
    }

    public static boolean isSkipStarTree(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useStarTree"));
    }

    public static boolean isRoutingForceHLC(Map<String, String> queryOptions) {
        String routingOptions = queryOptions.get("routingOptions");
        return routingOptions != null && routingOptions.toUpperCase().contains("FORCE_HLC");
    }

    public static boolean isSkipScanFilterReorder(Map<String, String> queryOptions) {
        return "false".equalsIgnoreCase(queryOptions.get("useScanReorderOpt"));
    }

    @Nullable
    public static Integer getNumReplicaGroupsToQuery(Map<String, String> queryOptions) {
        String numReplicaGroupsToQuery = queryOptions.get("numReplicaGroupsToQuery");
        return numReplicaGroupsToQuery != null ? Integer.valueOf(Integer.parseInt(numReplicaGroupsToQuery)) : null;
    }

    public static boolean isExplainPlanVerbose(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("explainPlanVerbose"));
    }

    @Nullable
    public static Integer getMaxExecutionThreads(Map<String, String> queryOptions) {
        String maxExecutionThreadsString = queryOptions.get("maxExecutionThreads");
        return maxExecutionThreadsString != null ? Integer.valueOf(Integer.parseInt(maxExecutionThreadsString)) : null;
    }

    @Nullable
    public static Integer getMinSegmentGroupTrimSize(Map<String, String> queryOptions) {
        String minSegmentGroupTrimSizeString = queryOptions.get("minSegmentGroupTrimSize");
        return minSegmentGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minSegmentGroupTrimSizeString)) : null;
    }

    @Nullable
    public static Integer getMinServerGroupTrimSize(Map<String, String> queryOptions) {
        String minServerGroupTrimSizeString = queryOptions.get("minServerGroupTrimSize");
        return minServerGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minServerGroupTrimSizeString)) : null;
    }

    public static boolean isNullHandlingEnabled(Map<String, String> queryOptions) {
        boolean nullHandlingEnabled = Boolean.parseBoolean(queryOptions.get("enableNullHandling"));
        if (nullHandlingEnabled) {
            Preconditions.checkState((DataTableFactory.getDataTableVersion() >= 4 ? 1 : 0) != 0, (Object)"Null handling cannot be enabled for data table version smaller than 4");
        }
        return nullHandlingEnabled;
    }
}

