/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public final class SegmentProcessorAvroUtils {
    private SegmentProcessorAvroUtils() {
    }

    public static GenericData.Record convertGenericRowToAvroRecord(GenericRow genericRow, GenericData.Record reusableRecord) {
        return SegmentProcessorAvroUtils.convertGenericRowToAvroRecord(genericRow, reusableRecord, genericRow.getFieldToValueMap().keySet());
    }

    public static GenericData.Record convertGenericRowToAvroRecord(GenericRow genericRow, GenericData.Record reusableRecord, Set<String> fields) {
        for (String field : fields) {
            Object value = genericRow.getValue(field);
            if (value instanceof Object[]) {
                reusableRecord.put(field, Arrays.asList((Object[])value));
                continue;
            }
            if (value instanceof byte[]) {
                value = ByteBuffer.wrap((byte[])value);
            }
            reusableRecord.put(field, value);
        }
        return reusableRecord;
    }

    public static Schema convertPinotSchemaToAvroSchema(org.apache.pinot.spi.data.Schema pinotSchema) {
        SchemaBuilder.FieldAssembler fieldAssembler = SchemaBuilder.record((String)"record").fields();
        List orderedFieldSpecs = pinotSchema.getAllFieldSpecs().stream().sorted(Comparator.comparing(FieldSpec::getName)).collect(Collectors.toList());
        block15: for (FieldSpec fieldSpec : orderedFieldSpecs) {
            String name = fieldSpec.getName();
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            if (fieldSpec.isSingleValueField()) {
                switch (storedType) {
                    case INT: {
                        fieldAssembler = fieldAssembler.name(name).type().intType().noDefault();
                        continue block15;
                    }
                    case LONG: {
                        fieldAssembler = fieldAssembler.name(name).type().longType().noDefault();
                        continue block15;
                    }
                    case FLOAT: {
                        fieldAssembler = fieldAssembler.name(name).type().floatType().noDefault();
                        continue block15;
                    }
                    case DOUBLE: {
                        fieldAssembler = fieldAssembler.name(name).type().doubleType().noDefault();
                        continue block15;
                    }
                    case STRING: {
                        fieldAssembler = fieldAssembler.name(name).type().stringType().noDefault();
                        continue block15;
                    }
                    case BYTES: {
                        fieldAssembler = fieldAssembler.name(name).type().bytesType().noDefault();
                        continue block15;
                    }
                }
                throw new RuntimeException("Unsupported data type: " + storedType);
            }
            switch (storedType) {
                case INT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().intType()).noDefault();
                    continue block15;
                }
                case LONG: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().longType()).noDefault();
                    continue block15;
                }
                case FLOAT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().floatType()).noDefault();
                    continue block15;
                }
                case DOUBLE: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().doubleType()).noDefault();
                    continue block15;
                }
                case STRING: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().stringType()).noDefault();
                    continue block15;
                }
            }
            throw new RuntimeException("Unsupported data type: " + storedType);
        }
        return (Schema)fieldAssembler.endRecord();
    }
}

