/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.InvertedIndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexHandler.class);
    private final SegmentMetadata _segmentMetadata;
    private final HashSet<String> _columnsToAddIdx;

    public InvertedIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._columnsToAddIdx = new HashSet<String>(indexLoadingConfig.getInvertedIndexColumns());
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.INVERTED_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateInvertedIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new inverted index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws IOException {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.INVERTED_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.INVERTED_INDEX);
            LOGGER.info("Removed existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateInvertedIndex(columnMetadata)) continue;
            this.createInvertedIndexForColumn(segmentWriter, columnMetadata, (InvertedIndexCreatorProvider)indexCreatorProvider);
        }
    }

    private boolean shouldCreateInvertedIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null && !columnMetadata.isSorted() && columnMetadata.hasDictionary();
    }

    private void createInvertedIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, InvertedIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".inv.inprogress");
        File invertedIndexFile = new File(indexDir, columnName + ".bitmap.inv");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)invertedIndexFile);
        }
        LOGGER.info("Creating new inverted index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        int numDocs = columnMetadata.getTotalDocs();
        try (DictionaryBasedInvertedIndexCreator creator = indexCreatorProvider.newInvertedIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forInvertedIndex());
             ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    creator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    creator.add(dictIds, length);
                }
            }
            creator.seal();
        }
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, invertedIndexFile, ColumnIndexType.INVERTED_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created inverted index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }
}

