/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.TextIndexCreatorProvider;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextIndexHandler.class);
    private final SegmentMetadata _segmentMetadata;
    private final Set<String> _columnsToAddIdx;
    private final FSTType _fstType;

    public TextIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._fstType = indexLoadingConfig.getFSTIndexType();
        this._columnsToAddIdx = new HashSet<String>(indexLoadingConfig.getTextIndexColumns());
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.TEXT_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateTextIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new text index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws Exception {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.TEXT_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.TEXT_INDEX);
            LOGGER.info("Removed existing text index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateTextIndex(columnMetadata)) continue;
            this.createTextIndexForColumn(segmentWriter, columnMetadata, (TextIndexCreatorProvider)indexCreatorProvider);
        }
    }

    private boolean shouldCreateTextIndex(ColumnMetadata columnMetadata) {
        if (columnMetadata != null) {
            this.checkUnsupportedOperationsForTextIndex(columnMetadata);
            return true;
        }
        return false;
    }

    private void checkUnsupportedOperationsForTextIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("Text index is currently only supported on STRING columns: " + column);
        }
    }

    private void createTextIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, TextIndexCreatorProvider indexCreatorProvider) throws Exception {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        int numDocs = columnMetadata.getTotalDocs();
        boolean hasDictionary = columnMetadata.hasDictionary();
        LOGGER.info("Creating new text index for column: {} in segment: {}, hasDictionary: {}", new Object[]{columnName, segmentName, hasDictionary});
        File segmentDirectory = SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)this._segmentMetadata.getVersion());
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             TextIndexCreator textIndexCreator = indexCreatorProvider.newTextIndexCreator(IndexCreationContext.builder().withColumnMetadata(columnMetadata).withIndexDir(segmentDirectory).build().forTextIndex(this._fstType, true));){
            if (columnMetadata.isSingleValue()) {
                this.processSVField(segmentWriter, hasDictionary, forwardIndexReader, readerContext, textIndexCreator, numDocs, columnMetadata);
            } else {
                this.processMVField(segmentWriter, hasDictionary, forwardIndexReader, readerContext, textIndexCreator, numDocs, columnMetadata);
            }
            textIndexCreator.seal();
        }
        LOGGER.info("Created text index for column: {} in segment: {}", (Object)columnName, (Object)segmentName);
    }

    private void processSVField(SegmentDirectory.Writer segmentWriter, boolean hasDictionary, ForwardIndexReader forwardIndexReader, ForwardIndexReaderContext readerContext, TextIndexCreator textIndexCreator, int numDocs, ColumnMetadata columnMetadata) throws IOException {
        if (!hasDictionary) {
            for (int docId = 0; docId < numDocs; ++docId) {
                textIndexCreator.add(forwardIndexReader.getString(docId, readerContext));
            }
        } else {
            try (BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
                for (int docId = 0; docId < numDocs; ++docId) {
                    int dictId = forwardIndexReader.getDictId(docId, readerContext);
                    textIndexCreator.add(dictionary.getStringValue(dictId));
                }
            }
        }
    }

    private void processMVField(SegmentDirectory.Writer segmentWriter, boolean hasDictionary, ForwardIndexReader forwardIndexReader, ForwardIndexReaderContext readerContext, TextIndexCreator textIndexCreator, int numDocs, ColumnMetadata columnMetadata) throws IOException {
        if (!hasDictionary) {
            String[] valueBuffer = new String[columnMetadata.getMaxNumberOfMultiValues()];
            for (int docId = 0; docId < numDocs; ++docId) {
                int length = forwardIndexReader.getStringMV(docId, valueBuffer, readerContext);
                textIndexCreator.add(valueBuffer, length);
            }
        } else {
            try (BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
                int maxNumEntries = columnMetadata.getMaxNumberOfMultiValues();
                int[] dictIdBuffer = new int[maxNumEntries];
                String[] valueBuffer = new String[maxNumEntries];
                for (int docId = 0; docId < numDocs; ++docId) {
                    int length = forwardIndexReader.getDictIdMV(docId, dictIdBuffer, readerContext);
                    for (int i = 0; i < length; ++i) {
                        valueBuffer[i] = dictionary.getStringValue(dictIdBuffer[i]);
                    }
                    textIndexCreator.add(valueBuffer, length);
                }
            }
        }
    }
}

