/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class BytesDictionary
extends BaseImmutableDictionary {
    public BytesDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        super(dataBuffer, length, numBytesPerValue, (byte)0);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    public int indexOf(ByteArray bytesValue) {
        return this.normalizeIndex(this.binarySearch(bytesValue.getBytes()));
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(BytesUtils.toBytes((String)stringValue));
    }

    public ByteArray getMinVal() {
        return new ByteArray(this.getBytes(0));
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this.getBytes(this.length() - 1));
    }

    public byte[] get(int dictId) {
        return this.getBytes(dictId);
    }

    public Object getInternal(int dictId) {
        return new ByteArray(this.getBytes(dictId));
    }

    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimalUtils.deserialize((byte[])this.getBytes(dictId));
    }

    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this.getBytes(dictId));
    }

    public byte[] getBytesValue(int dictId) {
        return this.getBytes(dictId);
    }
}

