/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.readers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.sort.PinotSegmentSorter;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotSegmentRecordReader
implements RecordReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentRecordReader.class);
    private IndexSegment _indexSegment;
    private boolean _destroySegmentOnClose;
    private int _numDocs;
    private Map<String, PinotSegmentColumnReader> _columnReaderMap;
    private int[] _sortedDocIds;
    private boolean _skipDefaultNullValues;
    private int _nextDocId = 0;

    public PinotSegmentRecordReader() {
    }

    @Deprecated
    public PinotSegmentRecordReader(File indexDir) throws Exception {
        try {
            this.init(indexDir, null, null, false);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Deprecated
    public PinotSegmentRecordReader(File indexDir, @Nullable Schema schema, @Nullable List<String> sortOrder) throws Exception {
        Set fieldsToRead = schema != null ? schema.getPhysicalColumnNames() : null;
        try {
            this.init(indexDir, fieldsToRead, sortOrder, false);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void init(File indexDir, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
        this.init(indexDir, fieldsToRead, null, true);
    }

    public void init(File indexDir, @Nullable Set<String> fieldsToRead, @Nullable List<String> sortOrder, boolean skipDefaultNullValues) {
        ImmutableSegment indexSegment;
        try {
            indexSegment = ImmutableSegmentLoader.load(indexDir, ReadMode.mmap);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while loading the segment from: " + indexDir, e);
        }
        this.init((IndexSegment)indexSegment, true, fieldsToRead, null, sortOrder, skipDefaultNullValues);
    }

    public void init(ImmutableSegment immutableSegment) {
        this.init((IndexSegment)immutableSegment, false, null, null, null, false);
    }

    public void init(MutableSegment mutableSegment, @Nullable int[] sortedDocIds) {
        this.init((IndexSegment)mutableSegment, false, null, sortedDocIds, null, false);
    }

    private void init(IndexSegment indexSegment, boolean destroySegmentOnClose, @Nullable Set<String> fieldsToRead, @Nullable int[] sortedDocIds, @Nullable List<String> sortOrder, boolean skipDefaultNullValues) {
        this._indexSegment = indexSegment;
        this._destroySegmentOnClose = destroySegmentOnClose;
        this._numDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        if (this._numDocs > 0) {
            this._columnReaderMap = new HashMap<String, PinotSegmentColumnReader>();
            Set columnsInSegment = this._indexSegment.getPhysicalColumnNames();
            if (CollectionUtils.isEmpty(fieldsToRead)) {
                for (String column : columnsInSegment) {
                    this._columnReaderMap.put(column, new PinotSegmentColumnReader(indexSegment, column));
                }
            } else {
                for (String column : fieldsToRead) {
                    if (columnsInSegment.contains(column)) {
                        this._columnReaderMap.put(column, new PinotSegmentColumnReader(indexSegment, column));
                        continue;
                    }
                    LOGGER.warn("Ignoring column: {} that does not exist in the segment", (Object)column);
                }
            }
            this._sortedDocIds = sortedDocIds != null ? sortedDocIds : (int[])(CollectionUtils.isNotEmpty(sortOrder) ? new PinotSegmentSorter(this._numDocs, this._columnReaderMap).getSortedDocIds(sortOrder) : null);
            this._skipDefaultNullValues = skipDefaultNullValues;
        }
    }

    @Nullable
    public int[] getSortedDocIds() {
        return this._sortedDocIds;
    }

    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        if (this._sortedDocIds == null) {
            this.getRecord(reuse, this._nextDocId);
        } else {
            this.getRecord(reuse, this._sortedDocIds[this._nextDocId]);
        }
        ++this._nextDocId;
        return reuse;
    }

    public void getRecord(GenericRow reuse, int docId) {
        for (Map.Entry<String, PinotSegmentColumnReader> entry : this._columnReaderMap.entrySet()) {
            String column = entry.getKey();
            PinotSegmentColumnReader columnReader = entry.getValue();
            if (!columnReader.isNull(docId)) {
                reuse.putValue(column, columnReader.getValue(docId));
                continue;
            }
            if (this._skipDefaultNullValues) continue;
            reuse.putDefaultNullValue(column, columnReader.getValue(docId));
        }
    }

    public Object getValue(int docId, String column) {
        return this._columnReaderMap.get(column).getValue(docId);
    }

    public void rewind() {
        this._nextDocId = 0;
    }

    public void close() throws IOException {
        if (this._columnReaderMap != null) {
            for (PinotSegmentColumnReader columnReader : this._columnReaderMap.values()) {
                columnReader.close();
            }
        }
        if (this._destroySegmentOnClose && this._indexSegment != null) {
            this._indexSegment.destroy();
        }
    }
}

