/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.data.Schema;

public class StarTreeV2BuilderConfig {
    public static final int DEFAULT_MAX_LEAF_RECORDS = 10000;
    private static final int DIMENSION_CARDINALITY_THRESHOLD_FOR_DEFAULT_CONFIG = 10000;
    private final List<String> _dimensionsSplitOrder;
    private final Set<String> _skipStarNodeCreationForDimensions;
    private final Set<AggregationFunctionColumnPair> _functionColumnPairs;
    private final int _maxLeafRecords;

    public static StarTreeV2BuilderConfig fromIndexConfig(StarTreeIndexConfig indexConfig) {
        Set<String> skipStarNodeCreationForDimensions;
        List dimensionsSplitOrder = indexConfig.getDimensionsSplitOrder();
        if (indexConfig.getSkipStarNodeCreationForDimensions() != null) {
            skipStarNodeCreationForDimensions = new HashSet(indexConfig.getSkipStarNodeCreationForDimensions());
            Preconditions.checkArgument((boolean)dimensionsSplitOrder.containsAll(skipStarNodeCreationForDimensions), (String)"Can not skip star-node creation for dimensions not in the split order, dimensionsSplitOrder: %s, skipStarNodeCreationForDimensions: %s", (Object)dimensionsSplitOrder, skipStarNodeCreationForDimensions);
        } else {
            skipStarNodeCreationForDimensions = Collections.emptySet();
        }
        HashSet<AggregationFunctionColumnPair> functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        for (String functionColumnPair : indexConfig.getFunctionColumnPairs()) {
            functionColumnPairs.add(AggregationFunctionColumnPair.fromColumnName((String)functionColumnPair));
        }
        int maxLeafRecords = indexConfig.getMaxLeafRecords();
        if (maxLeafRecords <= 0) {
            maxLeafRecords = 10000;
        }
        return new StarTreeV2BuilderConfig(dimensionsSplitOrder, skipStarNodeCreationForDimensions, functionColumnPairs, maxLeafRecords);
    }

    public static StarTreeV2BuilderConfig generateDefaultConfig(SegmentMetadata segmentMetadata) {
        Schema schema = segmentMetadata.getSchema();
        ArrayList<ColumnMetadata> dimensionColumnMetadataList = new ArrayList<ColumnMetadata>();
        ArrayList<ColumnMetadata> timeColumnMetadataList = new ArrayList<ColumnMetadata>();
        ArrayList<String> numericMetrics = new ArrayList<String>();
        for (Object fieldSpec : schema.getAllFieldSpecs()) {
            if (!fieldSpec.isSingleValueField() || fieldSpec.isVirtualColumn()) continue;
            String column = fieldSpec.getName();
            switch (fieldSpec.getFieldType()) {
                case DIMENSION: {
                    ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
                    if (!columnMetadata.hasDictionary() || columnMetadata.getCardinality() > 10000) break;
                    dimensionColumnMetadataList.add(columnMetadata);
                    break;
                }
                case DATE_TIME: 
                case TIME: {
                    ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
                    if (!columnMetadata.hasDictionary()) break;
                    timeColumnMetadataList.add(columnMetadata);
                    break;
                }
                case METRIC: {
                    if (!fieldSpec.getDataType().isNumeric()) break;
                    numericMetrics.add(column);
                    break;
                }
            }
        }
        dimensionColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.getCardinality(), o1.getCardinality()));
        timeColumnMetadataList.sort((o1, o2) -> Integer.compare(o2.getCardinality(), o1.getCardinality()));
        ArrayList<String> dimensionsSplitOrder = new ArrayList<String>();
        for (ColumnMetadata dimensionColumnMetadata : dimensionColumnMetadataList) {
            dimensionsSplitOrder.add(dimensionColumnMetadata.getColumnName());
        }
        for (ColumnMetadata timeColumnMetadata : timeColumnMetadataList) {
            dimensionsSplitOrder.add(timeColumnMetadata.getColumnName());
        }
        Preconditions.checkState((!dimensionsSplitOrder.isEmpty() ? 1 : 0) != 0, (Object)"No qualified dimension found for star-tree split order");
        HashSet<AggregationFunctionColumnPair> functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        functionColumnPairs.add(AggregationFunctionColumnPair.COUNT_STAR);
        for (String numericMetric : numericMetrics) {
            functionColumnPairs.add(new AggregationFunctionColumnPair(AggregationFunctionType.SUM, numericMetric));
        }
        return new StarTreeV2BuilderConfig(dimensionsSplitOrder, Collections.emptySet(), functionColumnPairs, 10000);
    }

    private StarTreeV2BuilderConfig(List<String> dimensionsSplitOrder, Set<String> skipStarNodeCreationForDimensions, Set<AggregationFunctionColumnPair> functionColumnPairs, int maxLeafRecords) {
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
        this._functionColumnPairs = functionColumnPairs;
        this._maxLeafRecords = maxLeafRecords;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StarTreeV2BuilderConfig)) {
            return false;
        }
        StarTreeV2BuilderConfig that = (StarTreeV2BuilderConfig)o;
        return this._maxLeafRecords == that._maxLeafRecords && Objects.equals(this._dimensionsSplitOrder, that._dimensionsSplitOrder) && Objects.equals(this._skipStarNodeCreationForDimensions, that._skipStarNodeCreationForDimensions) && Objects.equals(this._functionColumnPairs, that._functionColumnPairs);
    }

    public int hashCode() {
        return Objects.hash(this._dimensionsSplitOrder, this._skipStarNodeCreationForDimensions, this._functionColumnPairs, this._maxLeafRecords);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("splitOrder", this._dimensionsSplitOrder).append("skipStarNodeCreation", this._skipStarNodeCreationForDimensions).append("functionColumnPairs", this._functionColumnPairs).append("maxLeafRecords", this._maxLeafRecords).toString();
    }
}

