/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.Iterator;
import java.util.List;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;

public class UpsertUtils {
    private UpsertUtils() {
    }

    public static Iterator<RecordInfo> getRecordInfoIterator(final ImmutableSegment segment, final List<String> primaryKeyColumns, final String comparisonColumn) {
        final int numTotalDocs = segment.getSegmentMetadata().getTotalDocs();
        return new Iterator<RecordInfo>(){
            private int _docId = 0;

            @Override
            public boolean hasNext() {
                return this._docId < numTotalDocs;
            }

            @Override
            public RecordInfo next() {
                PrimaryKey primaryKey = new PrimaryKey(new Object[primaryKeyColumns.size()]);
                UpsertUtils.getPrimaryKey((IndexSegment)segment, primaryKeyColumns, this._docId, primaryKey);
                Object comparisonValue = segment.getValue(this._docId, comparisonColumn);
                if (comparisonValue instanceof byte[]) {
                    comparisonValue = new ByteArray((byte[])comparisonValue);
                }
                return new RecordInfo(primaryKey, this._docId++, (Comparable)comparisonValue);
            }
        };
    }

    public static void getPrimaryKey(IndexSegment segment, List<String> primaryKeyColumns, int docId, PrimaryKey buffer) {
        Object[] values = buffer.getValues();
        int numPrimaryKeyColumns = values.length;
        for (int i = 0; i < numPrimaryKeyColumns; ++i) {
            Object value = segment.getValue(docId, primaryKeyColumns.get(i));
            if (value instanceof byte[]) {
                value = new ByteArray((byte[])value);
            }
            values[i] = value;
        }
    }
}

