/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicHeader;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPushUtils
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPushUtils.class);
    private static final FileUploadDownloadClient FILE_UPLOAD_DOWNLOAD_CLIENT = new FileUploadDownloadClient();

    private SegmentPushUtils() {
    }

    public static URI generateSegmentTarURI(URI dirURI, URI fileURI, String prefix, String suffix) {
        if (StringUtils.isEmpty((CharSequence)prefix) && StringUtils.isEmpty((CharSequence)suffix)) {
            int port;
            String scheme = fileURI.getScheme();
            if (StringUtils.isEmpty((CharSequence)fileURI.getScheme())) {
                scheme = dirURI.getScheme();
            }
            String host = fileURI.getHost();
            if (StringUtils.isEmpty((CharSequence)fileURI.getHost())) {
                host = dirURI.getHost();
            }
            if ((port = fileURI.getPort()) < 0) {
                port = dirURI.getPort();
            }
            try {
                return new URI(scheme, fileURI.getUserInfo(), host, port, fileURI.getPath(), fileURI.getQuery(), fileURI.getFragment());
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Unable to generate push uri based from dir URI: {} and file URI: {}, directly return file URI.", (Object)dirURI, (Object)fileURI);
                return fileURI;
            }
        }
        return URI.create((prefix != null ? prefix : "") + fileURI.getRawPath() + (suffix != null ? suffix : ""));
    }

    public static void pushSegments(SegmentGenerationJobSpec spec, PinotFS fileSystem, List<String> tarFilePaths) throws RetriableOperationException, AttemptsExceededException {
        String tableName = spec.getTableSpec().getTableName();
        TableType tableType = tableName.endsWith("_" + TableType.REALTIME.name()) ? TableType.REALTIME : TableType.OFFLINE;
        boolean cleanUpOutputDir = spec.isCleanUpOutputDir();
        LOGGER.info("Start pushing segments: {}... to locations: {} for table {}", new Object[]{Arrays.toString(tarFilePaths.subList(0, Math.min(5, tarFilePaths.size())).toArray()), Arrays.toString(spec.getPinotClusterSpecs()), tableName});
        for (String tarFilePath : tarFilePaths) {
            URI tarFileURI = URI.create(tarFilePath);
            File tarFile = new File(tarFilePath);
            String fileName = tarFile.getName();
            Preconditions.checkArgument((boolean)fileName.endsWith(".tar.gz"));
            String segmentName = fileName.substring(0, fileName.length() - ".tar.gz".length());
            AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)spec.getAuthToken());
            for (PinotClusterSpec pinotClusterSpec : spec.getPinotClusterSpecs()) {
                URI controllerURI;
                try {
                    controllerURI = new URI(pinotClusterSpec.getControllerURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Got invalid controller uri - '" + pinotClusterSpec.getControllerURI() + "'");
                }
                LOGGER.info("Pushing segment: {} to location: {} for table {}", new Object[]{segmentName, controllerURI, tableName});
                int attempts = 1;
                if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushAttempts() > 0) {
                    attempts = spec.getPushJobSpec().getPushAttempts();
                }
                long retryWaitMs = 1000L;
                if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushRetryIntervalMillis() > 0L) {
                    retryWaitMs = spec.getPushJobSpec().getPushRetryIntervalMillis();
                }
                RetryPolicies.exponentialBackoffRetryPolicy((int)attempts, (long)retryWaitMs, (double)5.0).attempt(() -> {
                    try {
                        Boolean bl;
                        block14: {
                            InputStream inputStream = fileSystem.open(tarFileURI);
                            try {
                                SimpleHttpResponse response = FILE_UPLOAD_DOWNLOAD_CLIENT.uploadSegment(FileUploadDownloadClient.getUploadSegmentURI((URI)controllerURI), segmentName, inputStream, AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider), FileUploadDownloadClient.makeTableParam((String)tableName), tableName, tableType);
                                LOGGER.info("Response for pushing table {} segment {} to location {} - {}: {}", new Object[]{tableName, segmentName, controllerURI, response.getStatusCode(), response.getResponse()});
                                bl = true;
                                if (inputStream == null) break block14;
                            }
                            catch (Throwable response) {
                                try {
                                    if (inputStream != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable) {
                                            response.addSuppressed(throwable);
                                        }
                                    }
                                    throw response;
                                }
                                catch (HttpErrorStatusException e) {
                                    int statusCode = e.getStatusCode();
                                    if (statusCode >= 500) {
                                        LOGGER.warn("Caught temporary exception while pushing table: {} segment: {} to {}, will retry", new Object[]{tableName, segmentName, controllerURI, e});
                                        Boolean bl2 = false;
                                        return bl2;
                                    }
                                    LOGGER.error("Caught permanent exception while pushing table: {} segment: {} to {}, won't retry", new Object[]{tableName, segmentName, controllerURI, e});
                                    throw e;
                                }
                            }
                            inputStream.close();
                        }
                        return bl;
                    }
                    finally {
                        if (cleanUpOutputDir) {
                            fileSystem.delete(tarFileURI, true);
                        }
                    }
                });
            }
        }
    }

    public static void sendSegmentUris(SegmentGenerationJobSpec spec, List<String> segmentUris) throws RetriableOperationException, AttemptsExceededException {
        String tableName = spec.getTableSpec().getTableName();
        LOGGER.info("Start sending table {} segment URIs: {} to locations: {}", new Object[]{tableName, Arrays.toString(segmentUris.subList(0, Math.min(5, segmentUris.size())).toArray()), Arrays.toString(spec.getPinotClusterSpecs())});
        for (String segmentUri : segmentUris) {
            URI segmentURI = URI.create(segmentUri);
            PinotFS outputDirFS = PinotFSFactory.create((String)segmentURI.getScheme());
            AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)spec.getAuthToken());
            for (PinotClusterSpec pinotClusterSpec : spec.getPinotClusterSpecs()) {
                URI controllerURI;
                try {
                    controllerURI = new URI(pinotClusterSpec.getControllerURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Got invalid controller uri - '" + pinotClusterSpec.getControllerURI() + "'");
                }
                LOGGER.info("Sending table {} segment URI: {} to location: {} for ", new Object[]{tableName, segmentUri, controllerURI});
                int attempts = 1;
                if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushAttempts() > 0) {
                    attempts = spec.getPushJobSpec().getPushAttempts();
                }
                long retryWaitMs = 1000L;
                if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushRetryIntervalMillis() > 0L) {
                    retryWaitMs = spec.getPushJobSpec().getPushRetryIntervalMillis();
                }
                RetryPolicies.exponentialBackoffRetryPolicy((int)attempts, (long)retryWaitMs, (double)5.0).attempt(() -> {
                    try {
                        SimpleHttpResponse response = FILE_UPLOAD_DOWNLOAD_CLIENT.sendSegmentUri(FileUploadDownloadClient.getUploadSegmentURI((URI)controllerURI), segmentUri, AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider), FileUploadDownloadClient.makeTableParam((String)tableName), 600000);
                        LOGGER.info("Response for pushing table {} segment uri {} to location {} - {}: {}", new Object[]{tableName, segmentUri, controllerURI, response.getStatusCode(), response.getResponse()});
                        Boolean bl = true;
                        return bl;
                    }
                    catch (HttpErrorStatusException e) {
                        int statusCode = e.getStatusCode();
                        if (statusCode >= 500) {
                            LOGGER.warn("Caught temporary exception while pushing table: {} segment uri: {} to {}, will retry", new Object[]{tableName, segmentUri, controllerURI, e});
                            Boolean bl = false;
                            return bl;
                        }
                        LOGGER.error("Caught permanent exception while pushing table: {} segment uri: {} to {}, won't retry", new Object[]{tableName, segmentUri, controllerURI, e});
                        throw e;
                    }
                    finally {
                        if (spec.isCleanUpOutputDir()) {
                            outputDirFS.delete(segmentURI, true);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendSegmentUriAndMetadata(SegmentGenerationJobSpec spec, PinotFS fileSystem, Map<String, String> segmentUriToTarPathMap) throws Exception {
        String tableName = spec.getTableSpec().getTableName();
        LOGGER.info("Start pushing segment metadata: {} to locations: {} for table {}", new Object[]{segmentUriToTarPathMap, Arrays.toString(spec.getPinotClusterSpecs()), tableName});
        for (String segmentUriPath : segmentUriToTarPathMap.keySet()) {
            String tarFilePath = segmentUriToTarPathMap.get(segmentUriPath);
            String fileName = new File(tarFilePath).getName();
            Preconditions.checkArgument((boolean)fileName.endsWith(".tar.gz"));
            String segmentName = fileName.substring(0, fileName.length() - ".tar.gz".length());
            File segmentMetadataFile = SegmentPushUtils.generateSegmentMetadataFile(fileSystem, URI.create(tarFilePath));
            AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)spec.getAuthToken());
            try {
                for (PinotClusterSpec pinotClusterSpec : spec.getPinotClusterSpecs()) {
                    URI controllerURI;
                    try {
                        controllerURI = new URI(pinotClusterSpec.getControllerURI());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException("Got invalid controller uri - '" + pinotClusterSpec.getControllerURI() + "'");
                    }
                    LOGGER.info("Pushing segment: {} to location: {} for table {}", new Object[]{segmentName, controllerURI, tableName});
                    int attempts = 1;
                    if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushAttempts() > 0) {
                        attempts = spec.getPushJobSpec().getPushAttempts();
                    }
                    long retryWaitMs = 1000L;
                    if (spec.getPushJobSpec() != null && spec.getPushJobSpec().getPushRetryIntervalMillis() > 0L) {
                        retryWaitMs = spec.getPushJobSpec().getPushRetryIntervalMillis();
                    }
                    RetryPolicies.exponentialBackoffRetryPolicy((int)attempts, (long)retryWaitMs, (double)5.0).attempt(() -> {
                        try {
                            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
                            headers.add(new BasicHeader("DOWNLOAD_URI", segmentUriPath));
                            headers.add(new BasicHeader("UPLOAD_TYPE", FileUploadDownloadClient.FileUploadType.METADATA.toString()));
                            if (spec.getPushJobSpec() != null) {
                                headers.add(new BasicHeader("COPY_SEGMENT_TO_DEEP_STORE", String.valueOf(spec.getPushJobSpec().getCopyToDeepStoreForMetadataPush())));
                            }
                            headers.addAll(AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider));
                            SimpleHttpResponse response = FILE_UPLOAD_DOWNLOAD_CLIENT.uploadSegmentMetadata(FileUploadDownloadClient.getUploadSegmentURI((URI)controllerURI), segmentName, segmentMetadataFile, headers, FileUploadDownloadClient.makeTableParam((String)tableName), 600000);
                            LOGGER.info("Response for pushing table {} segment {} to location {} - {}: {}", new Object[]{tableName, segmentName, controllerURI, response.getStatusCode(), response.getResponse()});
                            return true;
                        }
                        catch (HttpErrorStatusException e) {
                            int statusCode = e.getStatusCode();
                            if (statusCode >= 500) {
                                LOGGER.warn("Caught temporary exception while pushing table: {} segment: {} to {}, will retry", new Object[]{tableName, segmentName, controllerURI, e});
                                return false;
                            }
                            LOGGER.error("Caught permanent exception while pushing table: {} segment: {} to {}, won't retry", new Object[]{tableName, segmentName, controllerURI, e});
                            throw e;
                        }
                    });
                }
            }
            finally {
                FileUtils.deleteQuietly((File)segmentMetadataFile);
            }
        }
    }

    public static Map<String, String> getSegmentUriToTarPathMap(URI outputDirURI, PushJobSpec pushSpec, String[] files) {
        HashMap<String, String> segmentUriToTarPathMap = new HashMap<String, String>();
        PathMatcher pushFilePathMatcher = null;
        if (pushSpec.getPushFileNamePattern() != null) {
            pushFilePathMatcher = FileSystems.getDefault().getPathMatcher(pushSpec.getPushFileNamePattern());
        }
        for (String file : files) {
            URI uri;
            if (pushFilePathMatcher != null && !pushFilePathMatcher.matches(Paths.get(file, new String[0])) || !(uri = URI.create(file)).getPath().endsWith(".tar.gz")) continue;
            URI updatedURI = SegmentPushUtils.generateSegmentTarURI(outputDirURI, uri, pushSpec.getSegmentUriPrefix(), pushSpec.getSegmentUriSuffix());
            segmentUriToTarPathMap.put(updatedURI.toString(), file);
        }
        return segmentUriToTarPathMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File generateSegmentMetadataFile(PinotFS fileSystem, URI tarFileURI) throws Exception {
        String uuid = UUID.randomUUID().toString();
        File tarFile = new File(FileUtils.getTempDirectory(), "segmentTar-" + uuid + ".tar.gz");
        File segmentMetadataDir = new File(FileUtils.getTempDirectory(), "segmentMetadataDir-" + uuid);
        try {
            fileSystem.copyToLocalFile(tarFileURI, tarFile);
            if (segmentMetadataDir.exists()) {
                FileUtils.forceDelete((File)segmentMetadataDir);
            }
            FileUtils.forceMkdir((File)segmentMetadataDir);
            LOGGER.info("Trying to untar Metadata file from: [{}] to [{}]", (Object)tarFile, (Object)segmentMetadataDir);
            TarGzCompressionUtils.untarOneFile((File)tarFile, (String)"metadata.properties", (File)new File(segmentMetadataDir, "metadata.properties"));
            LOGGER.info("Trying to untar CreationMeta file from: [{}] to [{}]", (Object)tarFile, (Object)segmentMetadataDir);
            TarGzCompressionUtils.untarOneFile((File)tarFile, (String)"creation.meta", (File)new File(segmentMetadataDir, "creation.meta"));
            File segmentMetadataTarFile = new File(FileUtils.getTempDirectory(), "segmentMetadata-" + uuid + ".tar.gz");
            if (segmentMetadataTarFile.exists()) {
                FileUtils.forceDelete((File)segmentMetadataTarFile);
            }
            LOGGER.info("Trying to tar segment metadata dir [{}] to [{}]", (Object)segmentMetadataDir, (Object)segmentMetadataTarFile);
            TarGzCompressionUtils.createTarGzFile((File)segmentMetadataDir, (File)segmentMetadataTarFile);
            File file = segmentMetadataTarFile;
            return file;
        }
        finally {
            FileUtils.deleteQuietly((File)tarFile);
            FileUtils.deleteQuietly((File)segmentMetadataDir);
        }
    }
}

