/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PinotColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type dataType;
    private final String expression;
    private final boolean aliased;
    private final boolean aggregate;
    private final boolean returnNullOnEmptyGroup;
    private final Optional<String> pushedDownAggregateFunctionName;
    private final Optional<String> pushedDownAggregateFunctionArgument;

    public PinotColumnHandle(String columnName, Type dataType) {
        this(columnName, dataType, columnName, false, false, true, Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public PinotColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="dataType") Type dataType, @JsonProperty(value="expression") String expression, @JsonProperty(value="aliased") boolean aliased, @JsonProperty(value="aggregate") boolean aggregate, @JsonProperty(value="returnNullOnEmptyGroup") boolean returnNullOnEmptyGroup, @JsonProperty(value="pushedDownAggregateFunctionName") Optional<String> pushedDownAggregateFunctionName, @JsonProperty(value="pushedDownAggregateFunctionArgument") Optional<String> pushedDownAggregateFunctionArgument) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.aliased = aliased;
        this.aggregate = aggregate;
        this.returnNullOnEmptyGroup = returnNullOnEmptyGroup;
        Objects.requireNonNull(pushedDownAggregateFunctionName, "pushedDownAggregateFunctionName is null");
        Objects.requireNonNull(pushedDownAggregateFunctionArgument, "pushedDownAggregateFunctionArgument is null");
        Preconditions.checkState((pushedDownAggregateFunctionName.isPresent() == pushedDownAggregateFunctionArgument.isPresent() ? 1 : 0) != 0, (Object)"Unexpected arguments: Either pushedDownAggregateFunctionName and pushedDownAggregateFunctionArgument must both be present or both be empty.");
        Preconditions.checkState((pushedDownAggregateFunctionName.isPresent() && aggregate || pushedDownAggregateFunctionName.isEmpty() ? 1 : 0) != 0, (Object)"Unexpected arguments: aggregate is false but pushed down aggregation is present");
        this.pushedDownAggregateFunctionName = pushedDownAggregateFunctionName;
        this.pushedDownAggregateFunctionArgument = pushedDownAggregateFunctionArgument;
    }

    public static PinotColumnHandle fromNonAggregateColumnHandle(PinotColumnHandle columnHandle) {
        return new PinotColumnHandle(columnHandle.getColumnName(), columnHandle.getDataType(), DynamicTablePqlExtractor.quoteIdentifier(columnHandle.getColumnName()), false, false, true, Optional.empty(), Optional.empty());
    }

    public static PinotColumnHandle fromColumnMetadata(ColumnMetadata columnMetadata) {
        String columnName = (String)Objects.requireNonNull(columnMetadata.getProperties().get("pinotColumnName"), String.format("Missing required column property '%s'", "pinotColumnName"));
        return new PinotColumnHandle(columnName, columnMetadata.getType());
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getDataType() {
        return this.dataType;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty
    public boolean isAliased() {
        return this.aliased;
    }

    @JsonProperty
    public boolean isAggregate() {
        return this.aggregate;
    }

    @JsonProperty
    public boolean isReturnNullOnEmptyGroup() {
        return this.returnNullOnEmptyGroup;
    }

    @JsonProperty
    public Optional<String> getPushedDownAggregateFunctionName() {
        return this.pushedDownAggregateFunctionName;
    }

    @JsonProperty
    public Optional<String> getPushedDownAggregateFunctionArgument() {
        return this.pushedDownAggregateFunctionArgument;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.columnName).setType(this.dataType).setProperties((Map)ImmutableMap.builder().put((Object)"pinotColumnName", (Object)this.columnName).buildOrThrow()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotColumnHandle that = (PinotColumnHandle)o;
        return Objects.equals(this.getColumnName(), that.getColumnName());
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).add("expression", (Object)this.expression).add("aliased", this.aliased).add("aggregate", this.aggregate).add("returnNullOnEmptyGroup", this.returnNullOnEmptyGroup).add("pushedDownAggregateFunctionName", this.pushedDownAggregateFunctionName).add("pushedDownAggregateFunctionArgument", this.pushedDownAggregateFunctionArgument).toString();
    }
}

