/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.auth.password;

import io.trino.plugin.pinot.auth.PinotAuthenticationProvider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Credentials;

public class PinotPasswordAuthenticationProvider
implements PinotAuthenticationProvider {
    private final Optional<String> authToken;

    public PinotPasswordAuthenticationProvider(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        this.authToken = Optional.of(this.encode(user, password));
    }

    @Override
    public Optional<String> getAuthenticationToken() {
        return this.authToken;
    }

    private String encode(String username, String password) {
        return Credentials.basic((String)username, (String)password, (Charset)StandardCharsets.ISO_8859_1);
    }
}

