/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.client.PinotDataFetcher;
import io.trino.plugin.pinot.client.PinotDataTableWithSize;
import io.trino.plugin.pinot.client.PinotHostMapper;
import io.trino.plugin.pinot.client.PinotLegacyServerQueryClientConfig;
import io.trino.spi.connector.ConnectorSession;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerInstance;
import org.apache.pinot.core.transport.ServerResponse;
import org.apache.pinot.spi.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.apache.pinot.sql.parsers.SqlCompilationException;

public class PinotLegacyDataFetcher
implements PinotDataFetcher {
    private static final Logger LOG = Logger.get(PinotLegacyDataFetcher.class);
    private final ConnectorSession session;
    private final PinotLegacyServerQueryClient pinotQueryClient;
    private final PinotSplit split;
    private final String query;
    private final LinkedList<PinotDataTableWithSize> dataTableList = new LinkedList();
    private final PinotDataFetcher.RowCountChecker rowCountChecker;
    private long readTimeNanos;
    private long estimatedMemoryUsageInBytes;
    private boolean isPinotDataFetched;

    public PinotLegacyDataFetcher(ConnectorSession session, PinotLegacyServerQueryClient pinotQueryClient, PinotSplit split, String query, PinotDataFetcher.RowCountChecker rowCountChecker) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.pinotQueryClient = Objects.requireNonNull(pinotQueryClient, "pinotQueryClient is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.rowCountChecker = Objects.requireNonNull(rowCountChecker, "rowCountChecker is null");
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getMemoryUsageBytes() {
        return this.estimatedMemoryUsageInBytes;
    }

    @Override
    public boolean endOfData() {
        return this.dataTableList.isEmpty();
    }

    @Override
    public boolean isDataFetched() {
        return this.isPinotDataFetched;
    }

    @Override
    public void fetchData() {
        long startTimeNanos = System.nanoTime();
        try {
            this.queryPinot().forEachRemaining(dataTableWithSize -> {
                this.checkExceptions(dataTableWithSize.getDataTable(), this.split, this.query);
                this.rowCountChecker.checkTooManyRows(dataTableWithSize.getDataTable());
                this.dataTableList.add((PinotDataTableWithSize)dataTableWithSize);
                this.estimatedMemoryUsageInBytes += dataTableWithSize.getEstimatedSizeInBytes();
            });
            this.isPinotDataFetched = true;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - startTimeNanos;
        }
    }

    @Override
    public PinotDataTableWithSize getNextDataTable() {
        PinotDataTableWithSize dataTableWithSize = this.dataTableList.pop();
        this.estimatedMemoryUsageInBytes -= dataTableWithSize.getEstimatedSizeInBytes();
        return dataTableWithSize;
    }

    private Iterator<PinotDataTableWithSize> queryPinot() {
        String host = this.split.getSegmentHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the host"));
        LOG.debug("Query '%s' on host '%s' for segment splits: %s", new Object[]{this.query, this.split.getSegmentHost(), this.split.getSegments()});
        return this.pinotQueryClient.queryPinot(this.session, this.query, host, this.split.getSegments());
    }

    public static class PinotLegacyServerQueryClient {
        private static final String TRINO_HOST_PREFIX = "trino-pinot-master";
        private final String trinoHostId;
        private final BrokerMetrics brokerMetrics;
        private final QueryRouter queryRouter;
        private final PinotHostMapper pinotHostMapper;
        private final AtomicLong requestIdGenerator = new AtomicLong();
        private final int estimatedNonNumericColumnSize;

        public PinotLegacyServerQueryClient(PinotHostMapper pinotHostMapper, PinotConfig pinotConfig) {
            this.trinoHostId = PinotLegacyServerQueryClient.getDefaultTrinoId();
            this.pinotHostMapper = Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            this.estimatedNonNumericColumnSize = pinotConfig.getEstimatedSizeInBytesForNonNumericColumn();
            PinotMetricsRegistry registry = PinotMetricUtils.getPinotMetricsRegistry();
            this.brokerMetrics = new BrokerMetrics(registry);
            this.brokerMetrics.initializeGlobalMeters();
            this.queryRouter = new QueryRouter(this.trinoHostId, this.brokerMetrics);
        }

        private static String getDefaultTrinoId() {
            Object defaultBrokerId;
            try {
                defaultBrokerId = TRINO_HOST_PREFIX + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                defaultBrokerId = TRINO_HOST_PREFIX;
            }
            return defaultBrokerId;
        }

        public Iterator<PinotDataTableWithSize> queryPinot(ConnectorSession session, String query, String serverHost, List<String> segments) {
            BrokerRequest brokerRequest;
            long connectionTimeoutInMillis = PinotSessionProperties.getConnectionTimeout(session).toMillis();
            int pinotRetryCount = PinotSessionProperties.getPinotRetryCount(session);
            try {
                brokerRequest = CalciteSqlCompiler.compileToBrokerRequest((String)query);
            }
            catch (SqlCompilationException e) {
                throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.of(query), String.format("Parsing error with on %s, Error = %s", serverHost, e.getMessage()), e);
            }
            ServerInstance serverInstance = this.pinotHostMapper.getServerInstance(serverHost);
            HashMap<ServerInstance, ArrayList<String>> routingTable = new HashMap<ServerInstance, ArrayList<String>>();
            routingTable.put(serverInstance, new ArrayList<String>(segments));
            String tableName = brokerRequest.getQuerySource().getTableName();
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
            HashMap<ServerInstance, ArrayList<String>> offlineRoutingTable = TableNameBuilder.isOfflineTableResource((String)tableName) ? routingTable : null;
            HashMap<ServerInstance, ArrayList<String>> realtimeRoutingTable = TableNameBuilder.isRealtimeTableResource((String)tableName) ? routingTable : null;
            BrokerRequest offlineBrokerRequest = TableNameBuilder.isOfflineTableResource((String)tableName) ? brokerRequest : null;
            BrokerRequest realtimeBrokerRequest = TableNameBuilder.isRealtimeTableResource((String)tableName) ? brokerRequest : null;
            AsyncQueryResponse asyncQueryResponse = this.doWithRetries(pinotRetryCount, requestId -> this.queryRouter.submitQuery(requestId.longValue(), rawTableName, offlineBrokerRequest, offlineRoutingTable, realtimeBrokerRequest, realtimeRoutingTable, connectionTimeoutInMillis));
            try {
                Map response = asyncQueryResponse.getFinalResponses();
                ImmutableList.Builder pinotDataTableWithSizeBuilder = ImmutableList.builder();
                for (Map.Entry entry : response.entrySet()) {
                    ServerResponse serverResponse = (ServerResponse)entry.getValue();
                    DataTable dataTable = serverResponse.getDataTable();
                    if (dataTable == null || dataTable.getNumberOfRows() <= 0) continue;
                    long estimatedTableSizeInBytes = IntStream.rangeClosed(0, dataTable.getDataSchema().size() - 1).mapToLong(i -> this.getEstimatedColumnSizeInBytes(dataTable.getDataSchema().getColumnDataType(i)) * (long)dataTable.getNumberOfRows()).reduce(0L, Long::sum);
                    pinotDataTableWithSizeBuilder.add((Object)new PinotDataTableWithSize(dataTable, estimatedTableSizeInBytes));
                }
                return pinotDataTableWithSizeBuilder.build().iterator();
            }
            catch (InterruptedException e) {
                throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(query), "Pinot query execution was interrupted", e);
            }
        }

        private <T> T doWithRetries(int retries, Function<Long, T> caller) {
            PinotException firstError = null;
            for (int i = 0; i < retries; ++i) {
                try {
                    return caller.apply(this.requestIdGenerator.getAndIncrement());
                }
                catch (PinotException e) {
                    if (firstError == null) {
                        firstError = e;
                    }
                    if (e.isRetryable()) continue;
                    throw e;
                }
            }
            throw firstError;
        }

        private long getEstimatedColumnSizeInBytes(DataSchema.ColumnDataType dataType) {
            if (dataType.isNumber()) {
                switch (dataType) {
                    case LONG: {
                        return 8L;
                    }
                    case FLOAT: {
                        return 4L;
                    }
                    case DOUBLE: {
                        return 8L;
                    }
                }
                return 4L;
            }
            return this.estimatedNonNumericColumnSize;
        }
    }

    public static class Factory
    implements PinotDataFetcher.Factory {
        private final PinotLegacyServerQueryClient queryClient;
        private final int limitForSegmentQueries;

        @Inject
        public Factory(PinotHostMapper pinotHostMapper, PinotConfig pinotConfig, PinotLegacyServerQueryClientConfig pinotLegacyServerQueryClientConfig) {
            Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            this.limitForSegmentQueries = pinotLegacyServerQueryClientConfig.getMaxRowsPerSplitForSegmentQueries();
            this.queryClient = new PinotLegacyServerQueryClient(pinotHostMapper, pinotConfig);
        }

        @Override
        public PinotDataFetcher create(ConnectorSession session, String query, PinotSplit split) {
            return new PinotLegacyDataFetcher(session, this.queryClient, split, query, new PinotDataFetcher.RowCountChecker(this.limitForSegmentQueries, query));
        }

        @Override
        public int getRowLimit() {
            return this.limitForSegmentQueries;
        }
    }
}

