/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.trino.plugin.pinot.conversion.PinotTimestamps;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.Supplier;

public class TimestampDecoder
implements Decoder {
    @Override
    public void decode(Supplier<Object> getter, BlockBuilder output) {
        Object value = getter.get();
        if (value == null) {
            output.appendNull();
        } else {
            LocalDateTime timestamp;
            if (value instanceof String) {
                String stringValue = (String)value;
                timestamp = PinotTimestamps.tryParse(stringValue);
                if (timestamp == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unable to parse string representation of type TIMESTAMP: %s [%s]", value, value.getClass().getSimpleName()));
                }
            } else if (value instanceof Double || value instanceof Long) {
                timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), ZoneOffset.UTC);
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported representation of type TIMESTAMP: %s [%s]", value, value.getClass().getSimpleName()));
            }
            long epochMicros = PinotTimestamps.toMicros(timestamp.atOffset(ZoneOffset.UTC).toInstant());
            TimestampType.TIMESTAMP_MILLIS.writeLong(output, epochMicros);
        }
    }
}

