/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.helix.AccessOption;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkBadVersionException;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.config.AccessControlUserConfigUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.ConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.user.UserConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKMetadataProvider.class);
    private static final String CLUSTER_TENANT_ISOLATION_ENABLED_KEY = "tenantIsolationEnabled";
    private static final String PROPERTYSTORE_CONTROLLER_JOBS_PREFIX = "/CONTROLLER_JOBS";
    private static final String PROPERTYSTORE_SEGMENTS_PREFIX = "/SEGMENTS";
    private static final String PROPERTYSTORE_SCHEMAS_PREFIX = "/SCHEMAS";
    private static final String PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX = "/INSTANCE_PARTITIONS";
    private static final String PROPERTYSTORE_TABLE_CONFIGS_PREFIX = "/CONFIGS/TABLE";
    private static final String PROPERTYSTORE_USER_CONFIGS_PREFIX = "/CONFIGS/USER";
    private static final String PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX = "/CONFIGS/INSTANCE";
    private static final String PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX = "/CONFIGS/CLUSTER";
    private static final String PROPERTYSTORE_SEGMENT_LINEAGE = "/SEGMENT_LINEAGE";
    private static final String PROPERTYSTORE_MINION_TASK_METADATA_PREFIX = "/MINION_TASK_METADATA";

    private ZKMetadataProvider() {
    }

    public static void setUserConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String username, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForUserConfig(username), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setRealtimeTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(realtimeTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setOfflineTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(offlineTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, InstanceZKMetadata instanceZKMetadata) {
        ZNRecord znRecord = instanceZKMetadata.toZNRecord();
        propertyStore.set(StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceZKMetadata.getId()}), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static InstanceZKMetadata getInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String instanceId) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceId}), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        return new InstanceZKMetadata(znRecord);
    }

    public static String constructPropertyStorePathForSegment(String resourceName, String segmentName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_SEGMENTS_PREFIX, resourceName, segmentName});
    }

    public static String constructPropertyStorePathForSchema(String schemaName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_SCHEMAS_PREFIX, schemaName});
    }

    public static String constructPropertyStorePathForInstancePartitions(String instancePartitionsName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX, instancePartitionsName});
    }

    public static String constructPropertyStorePathForControllerJob() {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_CONTROLLER_JOBS_PREFIX});
    }

    public static String constructPropertyStorePathForResource(String resourceName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_SEGMENTS_PREFIX, resourceName});
    }

    public static String constructPropertyStorePathForResourceConfig(String resourceName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_TABLE_CONFIGS_PREFIX, resourceName});
    }

    public static String constructPropertyStorePathForUserConfig(String resourceName) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_USER_CONFIGS_PREFIX, resourceName});
    }

    public static String constructPropertyStorePathForControllerConfig(String controllerConfigKey) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX, controllerConfigKey});
    }

    public static String constructPropertyStorePathForSegmentLineage(String tableNameWithType) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_SEGMENT_LINEAGE, tableNameWithType});
    }

    public static String constructPropertyStorePathForMinionTaskMetadata(String tableNameWithType, String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_MINION_TASK_METADATA_PREFIX, tableNameWithType, taskType});
    }

    @Deprecated
    public static String constructPropertyStorePathForMinionTaskMetadataDeprecated(String taskType, String tableNameWithType) {
        return StringUtil.join((String)"/", (String[])new String[]{PROPERTYSTORE_MINION_TASK_METADATA_PREFIX, taskType, tableNameWithType});
    }

    public static boolean isSegmentExisted(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceNameForResource, String segmentName) {
        return propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForSegment(resourceNameForResource, segmentName), AccessOption.PERSISTENT);
    }

    public static void removeResourceSegmentsFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResource(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static void removeResourceConfigFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResourceConfig(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static void removeUserConfigFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String username) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForUserConfig(username);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static boolean createSegmentZkMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType, SegmentZKMetadata segmentZKMetadata) {
        try {
            return propertyStore.create(ZKMetadataProvider.constructPropertyStorePathForSegment(tableNameWithType, segmentZKMetadata.getSegmentName()), (Object)segmentZKMetadata.toZNRecord(), AccessOption.PERSISTENT);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while creating segmentZkMetadata for table: {}", (Object)tableNameWithType, (Object)e);
            return false;
        }
    }

    public static boolean setSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType, SegmentZKMetadata segmentZKMetadata, int expectedVersion) {
        try {
            return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(tableNameWithType, segmentZKMetadata.getSegmentName()), (Object)segmentZKMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
        }
        catch (ZkBadVersionException e) {
            return false;
        }
    }

    public static boolean setSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType, SegmentZKMetadata segmentZKMetadata) {
        return ZKMetadataProvider.setSegmentZKMetadata(propertyStore, tableNameWithType, segmentZKMetadata, -1);
    }

    @Nullable
    public static ZNRecord getZnRecord(ZkHelixPropertyStore<ZNRecord> propertyStore, String path) {
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setCreationTime(stat.getCtime());
            znRecord.setModifiedTime(stat.getMtime());
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    @Nullable
    public static SegmentZKMetadata getSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType, String segmentName) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment(tableNameWithType, segmentName), null, AccessOption.PERSISTENT);
        return znRecord != null ? new SegmentZKMetadata(znRecord) : null;
    }

    @Nullable
    public static UserConfig getUserConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String username) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForUserConfig(username), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        try {
            UserConfig userConfig = AccessControlUserConfigUtils.fromZNRecord(znRecord);
            return (UserConfig)ConfigUtils.applyConfigWithEnvVariables((BaseJsonConfig)userConfig);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting user configuration for user: {}", (Object)username, (Object)e);
            return null;
        }
    }

    @Nullable
    public static List<UserConfig> getAllUserConfig(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        List znRecordss = propertyStore.getChildren(PROPERTYSTORE_USER_CONFIGS_PREFIX, null, AccessOption.PERSISTENT);
        try {
            return Optional.ofNullable(znRecordss).orElseGet(() -> new ArrayList()).stream().map(AccessControlUserConfigUtils::fromZNRecord).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting user list configuration", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static List<String> getAllUserName(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return propertyStore.getChildNames(PROPERTYSTORE_USER_CONFIGS_PREFIX, AccessOption.PERSISTENT);
    }

    @Nullable
    public static Map<String, UserConfig> getAllUserInfo(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return ZKMetadataProvider.getAllUserConfig(propertyStore).stream().collect(Collectors.toMap(UserConfig::getUsernameWithComponent, u -> u));
    }

    @Nullable
    public static TableConfig getTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        return ZKMetadataProvider.toTableConfig((ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(tableNameWithType), null, AccessOption.PERSISTENT));
    }

    @Nullable
    public static TableConfig getOfflineTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.OFFLINE.tableNameWithType(tableName));
    }

    @Nullable
    public static TableConfig getRealtimeTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.REALTIME.tableNameWithType(tableName));
    }

    public static List<TableConfig> getAllTableConfigs(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        List znRecords = propertyStore.getChildren(PROPERTYSTORE_TABLE_CONFIGS_PREFIX, null, AccessOption.PERSISTENT, 2, 50);
        if (znRecords != null) {
            int numZNRecords = znRecords.size();
            ArrayList<TableConfig> tableConfigs = new ArrayList<TableConfig>(numZNRecords);
            for (ZNRecord znRecord : znRecords) {
                TableConfig tableConfig = ZKMetadataProvider.toTableConfig(znRecord);
                if (tableConfig == null) continue;
                tableConfigs.add(tableConfig);
            }
            if (numZNRecords > tableConfigs.size()) {
                LOGGER.warn("Failed to read {}/{} table configs", (Object)(numZNRecords - tableConfigs.size()), (Object)numZNRecords);
            }
            return tableConfigs;
        }
        LOGGER.warn("Path: {} does not exist", (Object)PROPERTYSTORE_TABLE_CONFIGS_PREFIX);
        return Collections.emptyList();
    }

    @Nullable
    private static TableConfig toTableConfig(@Nullable ZNRecord znRecord) {
        if (znRecord == null) {
            return null;
        }
        try {
            TableConfig tableConfig = TableConfigUtils.fromZNRecord(znRecord);
            return (TableConfig)ConfigUtils.applyConfigWithEnvVariables((BaseJsonConfig)tableConfig);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while creating table config from ZNRecord: {}", (Object)znRecord.getId(), (Object)e);
            return null;
        }
    }

    public static void setSchema(ZkHelixPropertyStore<ZNRecord> propertyStore, Schema schema) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSchema(schema.getSchemaName()), (Object)SchemaUtils.toZNRecord(schema), AccessOption.PERSISTENT);
    }

    @Nullable
    public static Schema getSchema(ZkHelixPropertyStore<ZNRecord> propertyStore, String schemaName) {
        try {
            ZNRecord schemaZNRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSchema(schemaName), null, AccessOption.PERSISTENT);
            if (schemaZNRecord == null) {
                return null;
            }
            return SchemaUtils.fromZNRecord(schemaZNRecord);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting schema: {}", (Object)schemaName, (Object)e);
            return null;
        }
    }

    @Nullable
    public static Schema getTableSchema(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        String offlineSchemaNameFromValidationConfig;
        TableConfig offlineTableConfig;
        String realtimeSchemaNameFromValidationConfig;
        TableConfig realtimeTableConfig;
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        Schema schema = ZKMetadataProvider.getSchema(propertyStore, rawTableName);
        if (schema != null) {
            return schema;
        }
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if ((tableType == null || tableType == TableType.REALTIME) && (realtimeTableConfig = ZKMetadataProvider.getRealtimeTableConfig(propertyStore, tableName)) != null && (realtimeSchemaNameFromValidationConfig = realtimeTableConfig.getValidationConfig().getSchemaName()) != null) {
            schema = ZKMetadataProvider.getSchema(propertyStore, realtimeSchemaNameFromValidationConfig);
        }
        if (schema == null && (tableType == null || tableType == TableType.OFFLINE) && (offlineTableConfig = ZKMetadataProvider.getOfflineTableConfig(propertyStore, tableName)) != null && (offlineSchemaNameFromValidationConfig = offlineTableConfig.getValidationConfig().getSchemaName()) != null) {
            schema = ZKMetadataProvider.getSchema(propertyStore, offlineSchemaNameFromValidationConfig);
        }
        if (schema != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Schema name does not match raw table name, schema name: {}, raw table name: {}", (Object)schema.getSchemaName(), (Object)TableNameBuilder.extractRawTableName((String)tableName));
        }
        return schema;
    }

    public static List<SegmentZKMetadata> getSegmentsZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String parentPath = ZKMetadataProvider.constructPropertyStorePathForResource(tableNameWithType);
        List znRecords = propertyStore.getChildren(parentPath, null, AccessOption.PERSISTENT, 2, 50);
        if (znRecords != null) {
            int numZNRecords = znRecords.size();
            ArrayList<SegmentZKMetadata> segmentsZKMetadata = new ArrayList<SegmentZKMetadata>(numZNRecords);
            for (ZNRecord znRecord : znRecords) {
                if (znRecord == null) continue;
                segmentsZKMetadata.add(new SegmentZKMetadata(znRecord));
            }
            int numNullZNRecords = numZNRecords - segmentsZKMetadata.size();
            if (numNullZNRecords > 0) {
                LOGGER.warn("Failed to read {}/{} segment ZK metadata under path: {}", new Object[]{numNullZNRecords, numZNRecords, parentPath});
            }
            return segmentsZKMetadata;
        }
        LOGGER.warn("Path: {} does not exist", (Object)parentPath);
        return Collections.emptyList();
    }

    public static List<String> getSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(tableNameWithType);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            return propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
        }
        return Collections.emptyList();
    }

    public static List<String> getLLCRealtimeSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName) {
        ArrayList<String> llcRealtimeSegments = new ArrayList<String>();
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            List segments = propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
            for (String segment : segments) {
                if (!SegmentName.isLowLevelConsumerSegmentName(segment)) continue;
                llcRealtimeSegments.add(segment);
            }
        }
        return llcRealtimeSegments;
    }

    public static void setClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean isSingleTenantCluster) {
        String path = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        ZNRecord znRecord = !propertyStore.exists(path, AccessOption.PERSISTENT) ? new ZNRecord(CLUSTER_TENANT_ISOLATION_ENABLED_KEY) : (ZNRecord)propertyStore.get(path, null, AccessOption.PERSISTENT);
        znRecord.setBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, isSingleTenantCluster);
        propertyStore.set(path, (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static boolean getClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        String controllerConfigPath = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        if (propertyStore.exists(controllerConfigPath, AccessOption.PERSISTENT)) {
            ZNRecord znRecord = (ZNRecord)propertyStore.get(controllerConfigPath, null, AccessOption.PERSISTENT);
            if (znRecord.getSimpleFields().containsKey(CLUSTER_TENANT_ISOLATION_ENABLED_KEY)) {
                return znRecord.getBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, true);
            }
            return true;
        }
        return true;
    }
}

