/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.sql.FilterKind;

public class RequestUtils {
    private static final Map<String, String> CANONICAL_NAME_TO_SPECIAL_KEY_MAP = new HashMap<String, String>();

    private RequestUtils() {
    }

    public static Expression getIdentifierExpression(String identifier) {
        Expression expression = new Expression(ExpressionType.IDENTIFIER);
        expression.setIdentifier(new Identifier(identifier));
        return expression;
    }

    public static Expression getLiteralExpression(SqlLiteral node) {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        if (node instanceof SqlNumericLiteral) {
            SqlNumericLiteral sqlNumericLiteral = (SqlNumericLiteral)node;
            if (sqlNumericLiteral.getScale() != null && sqlNumericLiteral.isInteger()) {
                literal.setLongValue(node.bigDecimalValue().longValue());
            } else {
                literal.setDoubleValue(node.bigDecimalValue().doubleValue());
            }
        } else {
            literal.setStringValue(StringUtils.replace((String)node.toValue(), (String)"''", (String)"'"));
        }
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression createNewLiteralExpression() {
        Expression expression = new Expression(ExpressionType.LITERAL);
        Literal literal = new Literal();
        expression.setLiteral(literal);
        return expression;
    }

    public static Expression getLiteralExpression(boolean value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setBoolValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(long value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setLongValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(double value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setDoubleValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(String value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(value);
        return expression;
    }

    public static Expression getLiteralExpression(byte[] value) {
        Expression expression = RequestUtils.createNewLiteralExpression();
        expression.getLiteral().setStringValue(BytesUtils.toHexString((byte[])value));
        return expression;
    }

    public static Expression getLiteralExpression(Object object) {
        if (object instanceof Integer || object instanceof Long) {
            return RequestUtils.getLiteralExpression(((Number)object).longValue());
        }
        if (object instanceof Float || object instanceof Double) {
            return RequestUtils.getLiteralExpression(((Number)object).doubleValue());
        }
        if (object instanceof byte[]) {
            return RequestUtils.getLiteralExpression((byte[])object);
        }
        return RequestUtils.getLiteralExpression(object.toString());
    }

    public static Expression getFunctionExpression(String canonicalName) {
        assert (canonicalName.equalsIgnoreCase(RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(canonicalName)));
        Expression expression = new Expression(ExpressionType.FUNCTION);
        Function function = new Function(canonicalName);
        expression.setFunctionCall(function);
        return expression;
    }

    public static String canonicalizeFunctionName(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    public static String canonicalizeFunctionNamePreservingSpecialKey(String functionName) {
        String canonicalName = RequestUtils.canonicalizeFunctionName(functionName);
        return CANONICAL_NAME_TO_SPECIAL_KEY_MAP.getOrDefault(canonicalName, canonicalName);
    }

    public static String prettyPrint(Expression expression) {
        if (expression == null) {
            return "null";
        }
        if (expression.getIdentifier() != null) {
            return expression.getIdentifier().getName();
        }
        if (expression.getLiteral() != null && expression.getLiteral().isSetLongValue()) {
            return Long.toString(expression.getLiteral().getLongValue());
        }
        if (expression.getFunctionCall() != null) {
            String res = expression.getFunctionCall().getOperator() + "(";
            boolean isFirstParam = true;
            for (Expression operand : expression.getFunctionCall().getOperands()) {
                if (!isFirstParam) {
                    res = res + ", ";
                } else {
                    isFirstParam = false;
                }
                res = res + RequestUtils.prettyPrint(operand);
            }
            res = res + ")";
            return res;
        }
        return null;
    }

    public static String getTableName(PinotQuery pinotQuery) {
        while (pinotQuery.getDataSource().getSubquery() != null) {
            pinotQuery = pinotQuery.getDataSource().getSubquery();
        }
        return pinotQuery.getDataSource().getTableName();
    }

    static {
        for (FilterKind filterKind : FilterKind.values()) {
            CANONICAL_NAME_TO_SPECIAL_KEY_MAP.put(RequestUtils.canonicalizeFunctionName(filterKind.name()), filterKind.name());
        }
        CANONICAL_NAME_TO_SPECIAL_KEY_MAP.put("stdistance", "st_distance");
    }
}

