/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.data.Schema;
import org.joda.time.Duration;
import org.joda.time.Interval;

@InterfaceAudience.Private
public interface SegmentMetadata {
    @Deprecated
    public String getTableName();

    public String getName();

    public String getTimeColumn();

    public long getStartTime();

    public long getEndTime();

    public TimeUnit getTimeUnit();

    public Duration getTimeGranularity();

    public Interval getTimeInterval();

    public String getCrc();

    public SegmentVersion getVersion();

    public Schema getSchema();

    public int getTotalDocs();

    public File getIndexDir();

    @Nullable
    public String getCreatorName();

    public long getIndexCreationTime();

    public long getLastIndexedTimestamp();

    public long getLatestIngestionTimestamp();

    public List<StarTreeV2Metadata> getStarTreeV2MetadataList();

    public Map<String, String> getCustomMap();

    public String getStartOffset();

    public String getEndOffset();

    default public Set<String> getAllColumns() {
        return this.getSchema().getColumnNames();
    }

    public Map<String, ColumnMetadata> getColumnMetadataMap();

    default public ColumnMetadata getColumnMetadataFor(String column) {
        return this.getColumnMetadataMap().get(column);
    }

    public void removeColumn(String var1);

    public JsonNode toJson(@Nullable Set<String> var1);
}

