/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonCodecFactory;
import io.airlift.log.Logger;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.pinot.ForPinot;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotInsufficientServerResponseException;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.auth.PinotBrokerAuthenticationProvider;
import io.trino.plugin.pinot.auth.PinotControllerAuthenticationProvider;
import io.trino.plugin.pinot.client.PinotHostMapper;
import io.trino.plugin.pinot.query.PinotQueryInfo;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class PinotClient {
    private static final Logger LOG = Logger.get(PinotClient.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final Pattern BROKER_PATTERN = Pattern.compile("Broker_(.*)_(\\d+)");
    private static final String TIME_BOUNDARY_NOT_FOUND_ERROR_CODE = "404";
    private static final JsonCodec<Map<String, Map<String, List<String>>>> ROUTING_TABLE_CODEC = JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.mapJsonCodec(String.class, (JsonCodec)JsonCodec.listJsonCodec(String.class)));
    private static final Object ALL_TABLES_CACHE_KEY = new Object();
    private static final JsonCodec<QueryRequest> QUERY_REQUEST_JSON_CODEC = JsonCodec.jsonCodec(QueryRequest.class);
    private static final String GET_ALL_TABLES_API_TEMPLATE = "tables";
    private static final String TABLE_INSTANCES_API_TEMPLATE = "tables/%s/instances";
    private static final String TABLE_SCHEMA_API_TEMPLATE = "tables/%s/schema";
    private static final String ROUTING_TABLE_API_TEMPLATE = "debug/routingTable/%s";
    private static final String TIME_BOUNDARY_API_TEMPLATE = "debug/timeBoundary/%s";
    private static final String QUERY_URL_PATH = "query/sql";
    private final List<URI> controllerUrls;
    private final HttpClient httpClient;
    private final PinotHostMapper pinotHostMapper;
    private final String scheme;
    private final boolean proxyEnabled;
    private final NonEvictableLoadingCache<String, List<String>> brokersForTableCache;
    private final NonEvictableLoadingCache<Object, Multimap<String, String>> allTablesCache;
    private final JsonCodec<GetTables> tablesJsonCodec;
    private final JsonCodec<BrokersForTable> brokersForTableJsonCodec;
    private final JsonCodec<TimeBoundary> timeBoundaryJsonCodec;
    private final JsonCodec<Schema> schemaJsonCodec;
    private final JsonCodec<BrokerResponseNative> brokerResponseCodec;
    private final PinotControllerAuthenticationProvider controllerAuthenticationProvider;
    private final PinotBrokerAuthenticationProvider brokerAuthenticationProvider;

    @Inject
    public PinotClient(PinotConfig config, PinotHostMapper pinotHostMapper, @ForPinot HttpClient httpClient, @ForPinot ExecutorService executor, JsonCodec<GetTables> tablesJsonCodec, JsonCodec<BrokersForTable> brokersForTableJsonCodec, JsonCodec<TimeBoundary> timeBoundaryJsonCodec, JsonCodec<BrokerResponseNative> brokerResponseCodec, PinotControllerAuthenticationProvider controllerAuthenticationProvider, PinotBrokerAuthenticationProvider brokerAuthenticationProvider) {
        this.brokersForTableJsonCodec = Objects.requireNonNull(brokersForTableJsonCodec, "brokersForTableJsonCodec is null");
        this.timeBoundaryJsonCodec = Objects.requireNonNull(timeBoundaryJsonCodec, "timeBoundaryJsonCodec is null");
        this.tablesJsonCodec = Objects.requireNonNull(tablesJsonCodec, "tablesJsonCodec is null");
        this.schemaJsonCodec = new JsonCodecFactory(() -> new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).jsonCodec(Schema.class);
        this.brokerResponseCodec = Objects.requireNonNull(brokerResponseCodec, "brokerResponseCodec is null");
        this.pinotHostMapper = Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
        Objects.requireNonNull(config, "config is null");
        this.scheme = config.isTlsEnabled() ? "https" : "http";
        this.proxyEnabled = config.getProxyEnabled();
        this.controllerUrls = config.getControllerUrls();
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.brokersForTableCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(config.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), (CacheLoader)CacheLoader.from(this::getAllBrokersForTable));
        this.allTablesCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().refreshAfterWrite(config.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), (CacheLoader)CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::getAllTables), (Executor)executor));
        this.controllerAuthenticationProvider = controllerAuthenticationProvider;
        this.brokerAuthenticationProvider = brokerAuthenticationProvider;
    }

    public static void addJsonBinders(JsonCodecBinder jsonCodecBinder) {
        jsonCodecBinder.bindJsonCodec(GetTables.class);
        jsonCodecBinder.bindJsonCodec(BrokersForTable.InstancesInBroker.class);
        jsonCodecBinder.bindJsonCodec(BrokersForTable.class);
        jsonCodecBinder.bindJsonCodec(TimeBoundary.class);
        jsonCodecBinder.bindJsonCodec(BrokerResponseNative.class);
    }

    protected <T> T doHttpActionWithHeadersJson(Request.Builder requestBuilder, Optional<String> requestBody, JsonCodec<T> codec, Multimap<String, String> additionalHeaders) {
        requestBuilder.addHeaders(additionalHeaders);
        requestBuilder.setHeader("Accept", APPLICATION_JSON);
        if (requestBody.isPresent()) {
            requestBuilder.setHeader("Content-Type", APPLICATION_JSON);
            requestBuilder.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)requestBody.get(), (Charset)StandardCharsets.UTF_8));
        }
        Request request = requestBuilder.build();
        JsonResponseHandler responseHandler = JsonResponseHandler.createJsonResponseHandler(codec);
        Object response = null;
        try {
            response = this.httpClient.execute(request, (ResponseHandler)responseHandler);
        }
        catch (UnexpectedResponseException e) {
            throw new PinotException(PinotErrorCode.PINOT_HTTP_ERROR, Optional.empty(), String.format("Unexpected response status: %d for request %s to url %s, with headers %s, full response %s", e.getStatusCode(), requestBody.orElse(""), request.getUri(), request.getHeaders(), response));
        }
        return (T)response;
    }

    private <T> T sendHttpGetToControllerJson(String path, JsonCodec<T> codec) {
        ImmutableMultimap.Builder additionalHeadersBuilder = ImmutableMultimap.builder();
        this.controllerAuthenticationProvider.getAuthenticationToken().ifPresent(token -> additionalHeadersBuilder.put((Object)"Authorization", token));
        URI controllerPathUri = HttpUriBuilder.uriBuilderFrom((URI)this.getControllerUrl()).appendPath(path).scheme(this.scheme).build();
        return this.doHttpActionWithHeadersJson(Request.Builder.prepareGet().setUri(controllerPathUri), Optional.empty(), codec, (Multimap<String, String>)additionalHeadersBuilder.build());
    }

    private <T> T sendHttpGetToBrokerJson(String table, String path, JsonCodec<T> codec) {
        ImmutableMultimap.Builder additionalHeadersBuilder = ImmutableMultimap.builder();
        this.brokerAuthenticationProvider.getAuthenticationToken().ifPresent(token -> additionalHeadersBuilder.put((Object)"Authorization", token));
        HttpUriBuilder httpUriBuilder = this.getBrokerHttpUriBuilder(this.getBrokerHost(table));
        URI brokerPathUri = httpUriBuilder.scheme(this.scheme).appendPath(path).build();
        return this.doHttpActionWithHeadersJson(Request.Builder.prepareGet().setUri(brokerPathUri), Optional.empty(), codec, (Multimap<String, String>)additionalHeadersBuilder.build());
    }

    private HttpUriBuilder getBrokerHttpUriBuilder(String hostAndPort) {
        return this.proxyEnabled ? HttpUriBuilder.uriBuilderFrom((URI)this.getControllerUrl()) : HttpUriBuilder.uriBuilder().hostAndPort(HostAndPort.fromString((String)hostAndPort));
    }

    private URI getControllerUrl() {
        return this.controllerUrls.get(ThreadLocalRandom.current().nextInt(this.controllerUrls.size()));
    }

    protected Multimap<String, String> getAllTables() {
        List<String> allTables = this.sendHttpGetToControllerJson(GET_ALL_TABLES_API_TEMPLATE, this.tablesJsonCodec).getTables();
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String table : allTables) {
            builder.put((Object)table.toLowerCase(Locale.ENGLISH), (Object)table);
        }
        return builder.build();
    }

    public Schema getTableSchema(String table) throws Exception {
        return this.sendHttpGetToControllerJson(String.format(TABLE_SCHEMA_API_TEMPLATE, table), this.schemaJsonCodec);
    }

    public List<String> getPinotTableNames() {
        return ImmutableList.copyOf((Collection)PinotClient.getFromCache(this.allTablesCache, ALL_TABLES_CACHE_KEY).keySet());
    }

    public static <K, V> V getFromCache(LoadingCache<K, V> cache, K key) {
        Object value = cache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Cannot fetch from cache " + key, e.getCause());
        }
    }

    public String getPinotTableNameFromTrinoTableNameIfExists(String trinoTableName) {
        Collection candidates = PinotClient.getFromCache(this.allTablesCache, ALL_TABLES_CACHE_KEY).get((Object)trinoTableName.toLowerCase(Locale.ENGLISH));
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (String)Iterables.getOnlyElement((Iterable)candidates);
        }
        throw new PinotException(PinotErrorCode.PINOT_AMBIGUOUS_TABLE_NAME, Optional.empty(), String.format("Ambiguous table names: %s", candidates.stream().collect(Collectors.joining(", "))));
    }

    public String getPinotTableNameFromTrinoTableName(String trinoTableName) {
        String pinotTableName = this.getPinotTableNameFromTrinoTableNameIfExists(trinoTableName);
        if (pinotTableName == null) {
            throw new TableNotFoundException(new SchemaTableName("default", trinoTableName));
        }
        return pinotTableName;
    }

    @VisibleForTesting
    public List<String> getAllBrokersForTable(String table) {
        ArrayList brokers = this.sendHttpGetToControllerJson(String.format(TABLE_INSTANCES_API_TEMPLATE, table), this.brokersForTableJsonCodec).getBrokers().stream().flatMap(broker -> broker.getInstances().stream()).distinct().map(brokerToParse -> {
            Matcher matcher = BROKER_PATTERN.matcher((CharSequence)brokerToParse);
            if (matcher.matches() && matcher.groupCount() == 2) {
                return this.pinotHostMapper.getBrokerHost(matcher.group(1), matcher.group(2));
            }
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), String.format("Cannot parse %s in the broker instance", brokerToParse));
        }).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(brokers);
        return ImmutableList.copyOf((Collection)brokers);
    }

    public String getBrokerHost(String table) {
        try {
            List brokers = (List)this.brokersForTableCache.get((Object)table);
            if (brokers.isEmpty()) {
                throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), "No valid brokers found for " + table);
            }
            return (String)brokers.get(ThreadLocalRandom.current().nextInt(brokers.size()));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof PinotException) {
                throw (PinotException)((Object)throwable);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNABLE_TO_FIND_BROKER, Optional.empty(), "Error when getting brokers for table " + table, throwable);
        }
    }

    public Map<String, Map<String, List<String>>> getRoutingTableForTable(String tableName) {
        Map<String, Map<String, List<String>>> routingTable = this.sendHttpGetToBrokerJson(tableName, String.format(ROUTING_TABLE_API_TEMPLATE, tableName), ROUTING_TABLE_CODEC);
        ImmutableMap.Builder routingTableMap = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, List<String>>> entry : routingTable.entrySet()) {
            String tableNameWithType = entry.getKey();
            if (entry.getValue().isEmpty() || !tableName.equals(TableNameBuilder.extractRawTableName((String)tableNameWithType))) continue;
            ImmutableMap.Builder segmentBuilder = ImmutableMap.builder();
            for (Map.Entry<String, List<String>> segmentEntry : entry.getValue().entrySet()) {
                if (segmentEntry.getValue().isEmpty()) continue;
                segmentBuilder.put((Object)segmentEntry.getKey(), segmentEntry.getValue());
            }
            ImmutableMap segmentMap = segmentBuilder.buildOrThrow();
            if (segmentMap.isEmpty()) continue;
            routingTableMap.put((Object)tableNameWithType, (Object)segmentMap);
        }
        return routingTableMap.buildOrThrow();
    }

    public TimeBoundary getTimeBoundaryForTable(String table) {
        try {
            return this.sendHttpGetToBrokerJson(table, String.format(TIME_BOUNDARY_API_TEMPLATE, table), this.timeBoundaryJsonCodec);
        }
        catch (Exception e) {
            String[] errorMessageSplits = e.getMessage().split(" ");
            if (errorMessageSplits.length >= 4 && errorMessageSplits[3].equalsIgnoreCase(TIME_BOUNDARY_NOT_FOUND_ERROR_CODE)) {
                return (TimeBoundary)this.timeBoundaryJsonCodec.fromJson("{}");
            }
            throw e;
        }
    }

    private BrokerResponseNative submitBrokerQueryJson(ConnectorSession session, PinotQueryInfo query) {
        String queryRequest = QUERY_REQUEST_JSON_CODEC.toJson((Object)new QueryRequest(query.getQuery()));
        return PinotClient.doWithRetries(PinotSessionProperties.getPinotRetryCount(session), retryNumber -> {
            HttpUriBuilder httpUriBuilder = this.getBrokerHttpUriBuilder(this.getBrokerHost(query.getTable()));
            URI queryPathUri = httpUriBuilder.scheme(this.scheme).appendPath(QUERY_URL_PATH).build();
            LOG.info("Query '%s' on broker host '%s'", new Object[]{query.getQuery(), queryPathUri});
            Request.Builder builder = Request.Builder.preparePost().setUri(queryPathUri);
            ImmutableMultimap.Builder additionalHeadersBuilder = ImmutableMultimap.builder();
            this.brokerAuthenticationProvider.getAuthenticationToken().ifPresent(token -> additionalHeadersBuilder.put((Object)"Authorization", token));
            BrokerResponseNative response = this.doHttpActionWithHeadersJson(builder, Optional.of(queryRequest), this.brokerResponseCodec, (Multimap<String, String>)additionalHeadersBuilder.build());
            if (response.getExceptionsSize() > 0 && response.getProcessingExceptions() != null && !response.getProcessingExceptions().isEmpty()) {
                String processingExceptionMessage = response.getProcessingExceptions().stream().map(e -> "code: '%s' message: '%s'".formatted(e.getErrorCode(), e.getMessage())).collect(Collectors.joining(","));
                throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(query.getQuery()), String.format("Query %s encountered exception %s", query.getQuery(), processingExceptionMessage));
            }
            if (response.getNumServersQueried() == 0 || response.getNumServersResponded() == 0 || response.getNumServersQueried() > response.getNumServersResponded()) {
                throw new PinotInsufficientServerResponseException(query, response.getNumServersResponded(), response.getNumServersQueried());
            }
            return response;
        });
    }

    public Iterator<BrokerResultRow> createResultIterator(ConnectorSession session, PinotQueryInfo query, List<PinotColumnHandle> columnHandles) {
        BrokerResponseNative response = this.submitBrokerQueryJson(session, query);
        return PinotClient.fromResultTable(response, columnHandles, query.getGroupByClauses());
    }

    @VisibleForTesting
    public static ResultsIterator fromResultTable(BrokerResponseNative brokerResponse, List<PinotColumnHandle> columnHandles, int groupByClauses) {
        Objects.requireNonNull(brokerResponse, "brokerResponse is null");
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        ResultTable resultTable = brokerResponse.getResultTable();
        String[] columnNames = resultTable.getDataSchema().getColumnNames();
        Map columnIndices = (Map)IntStream.range(0, columnNames.length).boxed().collect(ImmutableMap.toImmutableMap(i -> columnNames[i].toLowerCase(Locale.ENGLISH), UnaryOperator.identity()));
        int[] indices = new int[columnNames.length];
        int[] inverseIndices = new int[columnNames.length];
        for (int i2 = 0; i2 < columnHandles.size(); ++i2) {
            String columnName = columnHandles.get(i2).getColumnName().toLowerCase(Locale.ENGLISH);
            indices[i2] = Objects.requireNonNull((Integer)columnIndices.get(columnName), String.format("column index for '%s' was not found", columnName));
            inverseIndices[indices[i2]] = i2;
        }
        List rows = resultTable.getRows();
        if (groupByClauses == 0 && brokerResponse.getNumDocsScanned() == 0L && resultTable.getRows().size() == 1) {
            Object[] originalRow = (Object[])Iterables.getOnlyElement((Iterable)resultTable.getRows());
            Object[] newRow = new Object[originalRow.length];
            for (int i3 = 0; i3 < originalRow.length; ++i3) {
                if (columnHandles.get(inverseIndices[i3]).isReturnNullOnEmptyGroup()) continue;
                newRow[i3] = originalRow[i3];
            }
            rows = ImmutableList.of((Object)newRow);
        }
        return new ResultsIterator(rows, indices);
    }

    public static <T> T doWithRetries(int retries, Function<Integer, T> caller) {
        PinotException firstError = null;
        Preconditions.checkState((retries > 0 ? 1 : 0) != 0, (String)"Invalid num of retries %s", (int)retries);
        for (int i = 0; i < retries; ++i) {
            try {
                return caller.apply(i);
            }
            catch (PinotException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (e.isRetryable()) continue;
                throw e;
            }
        }
        throw firstError;
    }

    public static class GetTables {
        private final List<String> tables;

        @JsonCreator
        public GetTables(@JsonProperty(value="tables") List<String> tables) {
            this.tables = tables;
        }

        public List<String> getTables() {
            return this.tables;
        }
    }

    public static class BrokersForTable {
        private final List<InstancesInBroker> brokers;

        @JsonCreator
        public BrokersForTable(@JsonProperty(value="brokers") List<InstancesInBroker> brokers) {
            this.brokers = brokers;
        }

        @JsonProperty(value="brokers")
        public List<InstancesInBroker> getBrokers() {
            return this.brokers;
        }

        public static class InstancesInBroker {
            private final List<String> instances;

            @JsonCreator
            public InstancesInBroker(@JsonProperty(value="instances") List<String> instances) {
                this.instances = instances;
            }

            @JsonProperty(value="instances")
            public List<String> getInstances() {
                return this.instances;
            }
        }
    }

    public static class TimeBoundary {
        private final Optional<String> onlineTimePredicate;
        private final Optional<String> offlineTimePredicate;

        public TimeBoundary() {
            this(null, null);
        }

        @JsonCreator
        public TimeBoundary(@JsonProperty String timeColumn, @JsonProperty String timeValue) {
            if (timeColumn != null && timeValue != null) {
                this.offlineTimePredicate = Optional.of(String.format("%s < %s", timeColumn, timeValue));
                this.onlineTimePredicate = Optional.of(String.format("%s >= %s", timeColumn, timeValue));
            } else {
                this.onlineTimePredicate = Optional.empty();
                this.offlineTimePredicate = Optional.empty();
            }
        }

        public Optional<String> getOnlineTimePredicate() {
            return this.onlineTimePredicate;
        }

        public Optional<String> getOfflineTimePredicate() {
            return this.offlineTimePredicate;
        }
    }

    public static class QueryRequest {
        private final String sql;

        @JsonCreator
        public QueryRequest(@JsonProperty String sql) {
            this.sql = Objects.requireNonNull(sql, "sql is null");
        }

        @JsonProperty
        public String getSql() {
            return this.sql;
        }
    }

    public static class ResultsIterator
    extends AbstractIterator<BrokerResultRow> {
        private final List<Object[]> rows;
        private final int[] indices;
        private int rowIndex;

        private ResultsIterator(List<Object[]> rows, int[] indices) {
            this.rows = Objects.requireNonNull(rows, "rows is null");
            this.indices = Objects.requireNonNull(indices, "indices is null");
        }

        protected BrokerResultRow computeNext() {
            if (this.rowIndex == this.rows.size()) {
                return (BrokerResultRow)this.endOfData();
            }
            return new ResultRow(this.rows.get(this.rowIndex++), this.indices);
        }
    }

    private static class ResultRow
    implements BrokerResultRow {
        private final Object[] row;
        private final int[] indices;

        public ResultRow(Object[] row, int[] indices) {
            this.row = Objects.requireNonNull(row, "row is null");
            this.indices = Objects.requireNonNull(indices, "indices is null");
        }

        @Override
        public Object getField(int index) {
            return this.row[this.indices[index]];
        }
    }

    public static interface BrokerResultRow {
        public Object getField(int var1);
    }
}

