/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import io.trino.plugin.pinot.query.PinotPatterns;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PinotSqlFormatter {
    private static final String MINUS = "minus";
    private static final List<Rule<FilterContext>> FILTER_RULES = ImmutableList.builder().add((Object)new AndOrFilterRule()).add((Object)new PredicateFilterRule()).build();
    private static final List<Rule<Predicate>> GLOBAL_PREDICATE_RULES = ImmutableList.builder().add((Object)new MinusZeroPredicateRule()).add((Object)new BinaryOperatorPredicateRule()).build();
    private static final List<Rule<FunctionContext>> GLOBAL_FUNCTION_RULES = ImmutableList.of((Object)new MinusFunctionRule());
    private static final Map<Predicate.Type, Rule<Predicate>> PREDICATE_RULE_MAP;
    private static final Map<TransformFunctionType, Rule<FunctionContext>> FUNCTION_RULE_MAP;
    private static final Map<AggregationFunctionType, Rule<FunctionContext>> AGGREGATION_FUNCTION_RULE_MAP;
    private static final Rule<FunctionContext> DEFAULT_FUNCTION_RULE;

    private PinotSqlFormatter() {
    }

    public static String formatFilter(final SchemaTableName schemaTableName, FilterContext filterContext, final Map<String, ColumnHandle> columnHandles) {
        Objects.requireNonNull(filterContext, "filterContext is null");
        Context context = new Context(){

            @Override
            public SchemaTableName getSchemaTableName() {
                return schemaTableName;
            }

            @Override
            public Optional<Map<String, ColumnHandle>> getColumnHandles() {
                return Optional.of(columnHandles);
            }
        };
        return PinotSqlFormatter.formatFilter(filterContext, context);
    }

    private static String formatFilter(FilterContext filterContext, Context context) {
        Optional<String> result = PinotSqlFormatter.applyRules(FILTER_RULES, filterContext, context);
        if (result.isPresent()) {
            return result.get();
        }
        throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), String.format("Unexpected filter type: '%s'", filterContext.getType()));
    }

    private static String formatPredicate(Predicate predicate, Context context) {
        Optional<String> result = PinotSqlFormatter.applyRules(GLOBAL_PREDICATE_RULES, predicate, context);
        if (result.isPresent()) {
            return result.get();
        }
        Rule<Predicate> rule = PREDICATE_RULE_MAP.get(predicate.getType());
        if (rule != null) {
            result = PinotSqlFormatter.applyRule(rule, predicate, context);
        }
        if (result.isPresent()) {
            return result.get();
        }
        throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.empty(), String.format("Unsupported predicate type '%s'", predicate.getType()));
    }

    public static String formatExpression(SchemaTableName schemaTableName, ExpressionContext expressionContext) {
        return PinotSqlFormatter.formatExpression(schemaTableName, expressionContext, Optional.empty());
    }

    public static String formatExpression(final SchemaTableName schemaTableName, ExpressionContext expressionContext, final Optional<Map<String, ColumnHandle>> columnHandles) {
        Objects.requireNonNull(expressionContext, "expressionContext is null");
        Context context = new Context(){

            @Override
            public SchemaTableName getSchemaTableName() {
                return schemaTableName;
            }

            @Override
            public Optional<Map<String, ColumnHandle>> getColumnHandles() {
                return columnHandles;
            }
        };
        return PinotSqlFormatter.formatExpression(expressionContext, context);
    }

    private static String formatExpression(ExpressionContext expressionContext, Context context) {
        switch (expressionContext.getType()) {
            case LITERAL: {
                return PinotSqlFormatter.singleQuoteValue(expressionContext.getLiteral());
            }
            case IDENTIFIER: {
                if (context.getColumnHandles().isPresent()) {
                    return DynamicTablePqlExtractor.quoteIdentifier(PinotSqlFormatter.getColumnHandle(expressionContext.getIdentifier(), context.getSchemaTableName(), context.getColumnHandles().get()).getColumnName());
                }
                return DynamicTablePqlExtractor.quoteIdentifier(expressionContext.getIdentifier());
            }
            case FUNCTION: {
                return PinotSqlFormatter.formatFunction(expressionContext.getFunction(), context);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.empty(), String.format("Unsupported expression type '%s'", expressionContext.getType()));
    }

    private static String formatFunction(FunctionContext functionContext, Context context) {
        Optional<Object> result = Optional.empty();
        if (functionContext.getType() == FunctionContext.Type.TRANSFORM) {
            Rule<FunctionContext> rule = FUNCTION_RULE_MAP.get(TransformFunctionType.getTransformFunctionType((String)functionContext.getFunctionName()));
            result = rule != null ? PinotSqlFormatter.applyRule(rule, functionContext, context) : PinotSqlFormatter.applyRules(GLOBAL_FUNCTION_RULES, functionContext, context);
        } else {
            Preconditions.checkState((functionContext.getType() == FunctionContext.Type.AGGREGATION ? 1 : 0) != 0, (String)"Unexpected function type for '%s'", (Object)functionContext);
            Rule<FunctionContext> rule = AGGREGATION_FUNCTION_RULE_MAP.get(AggregationFunctionType.getAggregationFunctionType((String)functionContext.getFunctionName()));
            if (rule != null) {
                result = PinotSqlFormatter.applyRule(rule, functionContext, context);
            }
        }
        if (result.isPresent()) {
            return (String)result.get();
        }
        result = PinotSqlFormatter.applyRule(DEFAULT_FUNCTION_RULE, functionContext, context);
        if (result.isPresent()) {
            return (String)result.get();
        }
        throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.empty(), String.format("Unsupported function expression '%s'", functionContext));
    }

    private static <T> Optional<String> applyRule(Rule<T> rule, T object, Context context) {
        Iterator iterator = rule.getPattern().match(object).iterator();
        if (iterator.hasNext()) {
            Match match = (Match)iterator.next();
            return Optional.of(rule.formatToSql(object, match.captures(), context));
        }
        return Optional.empty();
    }

    private static <T> Optional<String> applyRules(List<Rule<T>> rules, T object, Context context) {
        Rule<T> rule;
        Optional<String> result = Optional.empty();
        Iterator<Rule<T>> iterator = rules.iterator();
        while (iterator.hasNext() && !(result = PinotSqlFormatter.applyRule(rule = iterator.next(), object, context)).isPresent()) {
        }
        return result;
    }

    private static String singleQuoteValue(String value) {
        return "'" + value.replaceAll("'", "''") + "'";
    }

    private static String singleQuoteValues(List<String> values) {
        return values.stream().map(PinotSqlFormatter::singleQuoteValue).collect(Collectors.joining(", "));
    }

    public static String stripQuotes(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static PinotColumnHandle getColumnHandle(String name, SchemaTableName schemaTableName, Map<String, ColumnHandle> columnHandles) {
        PinotColumnHandle columnHandle = (PinotColumnHandle)columnHandles.get(name);
        if (columnHandle == null) {
            throw new ColumnNotFoundException(schemaTableName, name);
        }
        return columnHandle;
    }

    static {
        DEFAULT_FUNCTION_RULE = new DefaultFunctionRule();
        HashMap<Predicate.Type, Rule<Predicate>> predicateMap = new HashMap<Predicate.Type, Rule<Predicate>>();
        predicateMap.put(Predicate.Type.IN, new ValuesListPredicateRule(Predicate.Type.IN, "IN"));
        predicateMap.put(Predicate.Type.NOT_IN, new ValuesListPredicateRule(Predicate.Type.NOT_IN, "NOT IN"));
        predicateMap.put(Predicate.Type.RANGE, new RangePredicateRule());
        predicateMap.put(Predicate.Type.REGEXP_LIKE, new BinaryFunctionPredicateRule(Predicate.Type.REGEXP_LIKE, "regexp_like"));
        predicateMap.put(Predicate.Type.TEXT_MATCH, new BinaryFunctionPredicateRule(Predicate.Type.TEXT_MATCH, "text_match"));
        predicateMap.put(Predicate.Type.JSON_MATCH, new BinaryFunctionPredicateRule(Predicate.Type.JSON_MATCH, "json_match"));
        predicateMap.put(Predicate.Type.IS_NULL, new ExpressionOnlyPredicate(Predicate.Type.IS_NULL, "IS NULL"));
        predicateMap.put(Predicate.Type.IS_NOT_NULL, new ExpressionOnlyPredicate(Predicate.Type.IS_NOT_NULL, "IS NOT NULL"));
        PREDICATE_RULE_MAP = Maps.immutableEnumMap(predicateMap);
        HashMap<TransformFunctionType, Rule<FunctionContext>> functionMap = new HashMap<TransformFunctionType, Rule<FunctionContext>>();
        functionMap.put(TransformFunctionType.CASE, new CaseFunctionRule());
        functionMap.put(TransformFunctionType.CAST, new CastFunctionRule());
        FUNCTION_RULE_MAP = Maps.immutableEnumMap(functionMap);
        HashMap<AggregationFunctionType, CountStarFunctionRule> aggregationFunctionMap = new HashMap<AggregationFunctionType, CountStarFunctionRule>();
        aggregationFunctionMap.put(AggregationFunctionType.COUNT, new CountStarFunctionRule());
        AGGREGATION_FUNCTION_RULE_MAP = Maps.immutableEnumMap(aggregationFunctionMap);
    }

    private static interface Context {
        public SchemaTableName getSchemaTableName();

        public Optional<Map<String, ColumnHandle>> getColumnHandles();
    }

    private static interface Rule<T> {
        public Pattern<T> getPattern();

        public String formatToSql(T var1, Captures var2, Context var3);
    }

    private static class AndOrFilterRule
    implements Rule<FilterContext> {
        private static final Capture<FilterContext.Type> FILTER_TYPE = Capture.newCapture();
        private static final Capture<List<FilterContext>> CHILD_FILTERS = Capture.newCapture();
        private static final Pattern<FilterContext> PATTERN = PinotPatterns.filter().with(PinotPatterns.filterType().matching(contextType -> contextType == FilterContext.Type.AND || contextType == FilterContext.Type.OR)).with(PinotPatterns.filterType().capturedAs(FILTER_TYPE)).with(PinotPatterns.childFilters().capturedAs(CHILD_FILTERS));

        private AndOrFilterRule() {
        }

        @Override
        public Pattern<FilterContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FilterContext object, Captures captures, Context context) {
            FilterContext.Type filterType = (FilterContext.Type)captures.get(FILTER_TYPE);
            List childFilters = (List)captures.get(CHILD_FILTERS);
            return String.format("%s(%s)", filterType.name(), childFilters.stream().map(filterContext -> PinotSqlFormatter.formatFilter(filterContext, context)).collect(Collectors.joining(", ")));
        }
    }

    private static class PredicateFilterRule
    implements Rule<FilterContext> {
        private static final Capture<Predicate> PREDICATE = Capture.newCapture();
        private static final Pattern<FilterContext> PATTERN = PinotPatterns.filter().with(PinotPatterns.filterPredicate().capturedAs(PREDICATE));

        private PredicateFilterRule() {
        }

        @Override
        public Pattern<FilterContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FilterContext object, Captures captures, Context context) {
            Predicate predicate = (Predicate)captures.get(PREDICATE);
            return PinotSqlFormatter.formatPredicate(predicate, context);
        }
    }

    private static class MinusZeroPredicateRule
    implements Rule<Predicate> {
        private static final Capture<ExpressionContext> FIRST_ARGUMENT = Capture.newCapture();
        private static final Capture<ExpressionContext> SECOND_ARGUMENT = Capture.newCapture();
        private static final Capture<String> BINARY_OPERATOR_NAME = Capture.newCapture();
        private static final Pattern<Predicate> PATTERN = PinotPatterns.predicate().with(PinotPatterns.binaryOperatorValue().equalTo((Object)"0")).with(PinotPatterns.binaryOperator().capturedAs(BINARY_OPERATOR_NAME)).with(PinotPatterns.predicateExpression().matching(PinotPatterns.expression().with(PinotPatterns.functionContext().matching(PinotPatterns.binaryFunction().with(PinotPatterns.firstArgument().capturedAs(FIRST_ARGUMENT)).with(PinotPatterns.secondArgument().capturedAs(SECOND_ARGUMENT)).with(PinotPatterns.transformFunctionName().matching("minus"::equalsIgnoreCase))))));

        private MinusZeroPredicateRule() {
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            ExpressionContext first = (ExpressionContext)captures.get(FIRST_ARGUMENT);
            ExpressionContext second = (ExpressionContext)captures.get(SECOND_ARGUMENT);
            String operator = (String)captures.get(BINARY_OPERATOR_NAME);
            return String.format("(%s) %s (%s)", PinotSqlFormatter.formatExpression(first, context), operator, PinotSqlFormatter.formatExpression(second, context));
        }
    }

    private static class BinaryOperatorPredicateRule
    implements Rule<Predicate> {
        private static final Capture<String> BINARY_OPERATOR_NAME = Capture.newCapture();
        private static final Capture<String> BINARY_OPERATOR_VALUE = Capture.newCapture();
        private static final Capture<ExpressionContext> PREDICATE_EXPRESSION = Capture.newCapture();
        private static final Pattern<Predicate> PATTERN = PinotPatterns.predicate().with(PinotPatterns.binaryOperatorValue().capturedAs(BINARY_OPERATOR_VALUE)).with(PinotPatterns.binaryOperator().capturedAs(BINARY_OPERATOR_NAME)).with(PinotPatterns.predicateExpression().capturedAs(PREDICATE_EXPRESSION));

        private BinaryOperatorPredicateRule() {
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            ExpressionContext predicateExpression = (ExpressionContext)captures.get(PREDICATE_EXPRESSION);
            String singleValue = (String)captures.get(BINARY_OPERATOR_VALUE);
            String operator = (String)captures.get(BINARY_OPERATOR_NAME);
            return String.format("(%s) %s %s", PinotSqlFormatter.formatExpression(predicateExpression, context), operator, PinotSqlFormatter.singleQuoteValue(singleValue));
        }
    }

    private static class MinusFunctionRule
    implements Rule<FunctionContext> {
        private static final Capture<ExpressionContext> FIRST_ARGUMENT = Capture.newCapture();
        private static final Capture<ExpressionContext> SECOND_ARGUMENT = Capture.newCapture();
        private static final Pattern<FunctionContext> PATTERN = PinotPatterns.binaryFunction().with(PinotPatterns.transformFunctionName().matching("minus"::equalsIgnoreCase)).with(PinotPatterns.firstArgument().capturedAs(FIRST_ARGUMENT)).with(PinotPatterns.secondArgument().capturedAs(SECOND_ARGUMENT));

        private MinusFunctionRule() {
        }

        @Override
        public Pattern<FunctionContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FunctionContext object, Captures captures, Context context) {
            ExpressionContext first = (ExpressionContext)captures.get(FIRST_ARGUMENT);
            ExpressionContext second = (ExpressionContext)captures.get(SECOND_ARGUMENT);
            return String.format("%s - %s", PinotSqlFormatter.formatExpression(first, context), PinotSqlFormatter.formatExpression(second, context));
        }
    }

    private static class DefaultFunctionRule
    implements Rule<FunctionContext> {
        private static final Capture<List<ExpressionContext>> ARGUMENTS = Capture.newCapture();
        private static final Pattern<FunctionContext> PATTERN = PinotPatterns.function().with(PinotPatterns.arguments().capturedAs(ARGUMENTS));

        private DefaultFunctionRule() {
        }

        @Override
        public Pattern<FunctionContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FunctionContext object, Captures captures, Context context) {
            return String.format("%s(%s)", object.getFunctionName(), ((List)captures.get(ARGUMENTS)).stream().map(expressionContext -> PinotSqlFormatter.formatExpression(expressionContext, context)).collect(Collectors.joining(", ")));
        }
    }

    private static class ValuesListPredicateRule
    implements Rule<Predicate> {
        private static final Capture<List<String>> VALUES_LIST = Capture.newCapture();
        private static final Capture<ExpressionContext> PREDICATE_EXPRESSION = Capture.newCapture();
        private static final Pattern<Predicate> VALUES_LIST_PATTERN = PinotPatterns.predicate().with(PinotPatterns.predicateValuesList().capturedAs(VALUES_LIST)).with(PinotPatterns.predicateExpression().capturedAs(PREDICATE_EXPRESSION));
        private final Pattern<Predicate> pattern;
        private final String operator;

        public ValuesListPredicateRule(Predicate.Type predicateType, String operator) {
            Objects.requireNonNull(predicateType, "predicateType is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
            this.pattern = VALUES_LIST_PATTERN.with(PinotPatterns.predicateType().equalTo((Object)predicateType));
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return this.pattern;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            ExpressionContext predicateExpression = (ExpressionContext)captures.get(PREDICATE_EXPRESSION);
            List values = (List)captures.get(VALUES_LIST);
            return String.format("%s %s (%s)", PinotSqlFormatter.formatExpression(predicateExpression, context), this.operator, PinotSqlFormatter.singleQuoteValues(values));
        }
    }

    private static class RangePredicateRule
    implements Rule<Predicate> {
        private static final Capture<ExpressionContext> PREDICATE_EXPRESSION = Capture.newCapture();
        private static final Pattern<Predicate> PATTERN = PinotPatterns.predicate().with(PinotPatterns.predicateType().equalTo((Object)Predicate.Type.RANGE)).with(PinotPatterns.predicateExpression().capturedAs(PREDICATE_EXPRESSION));

        private RangePredicateRule() {
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            RangePredicate rangePredicate = (RangePredicate)object;
            ExpressionContext predicateExpression = (ExpressionContext)captures.get(PREDICATE_EXPRESSION);
            String expression = PinotSqlFormatter.formatExpression(predicateExpression, context);
            Preconditions.checkState((!rangePredicate.getLowerBound().equals("*") && !rangePredicate.getUpperBound().equals("*") ? 1 : 0) != 0, (String)"Unexpected range predicate '%s'", (Object)rangePredicate);
            if (rangePredicate.isUpperInclusive() && rangePredicate.isLowerInclusive()) {
                return String.format("(%s) BETWEEN %s AND %s", expression, PinotSqlFormatter.singleQuoteValue(rangePredicate.getLowerBound()), PinotSqlFormatter.singleQuoteValue(rangePredicate.getUpperBound()));
            }
            String leftOperator = rangePredicate.isLowerInclusive() ? ">=" : ">";
            String rightOperator = rangePredicate.isUpperInclusive() ? "<=" : "<";
            return String.format("(%1$s) %2$s %3$s AND (%1$s) %4$s %5$s", expression, leftOperator, PinotSqlFormatter.singleQuoteValue(rangePredicate.getLowerBound()), rightOperator, PinotSqlFormatter.singleQuoteValue(rangePredicate.getUpperBound()));
        }
    }

    private static class BinaryFunctionPredicateRule
    implements Rule<Predicate> {
        private static final Capture<String> BINARY_FUNCTION_VALUE = Capture.newCapture();
        private static final Capture<ExpressionContext> PREDICATE_EXPRESSION = Capture.newCapture();
        private static final Pattern<Predicate> BINARY_FUNCTION_PREDICATE = PinotPatterns.predicate().with(PinotPatterns.binaryFunctionPredicateValue().capturedAs(BINARY_FUNCTION_VALUE)).with(PinotPatterns.predicateExpression().capturedAs(PREDICATE_EXPRESSION));
        private final Pattern<Predicate> pattern;
        private final String functionName;

        public BinaryFunctionPredicateRule(Predicate.Type predicateType, String functionName) {
            Objects.requireNonNull(predicateType, "predicateType is null");
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.pattern = BINARY_FUNCTION_PREDICATE.with(PinotPatterns.predicateType().equalTo((Object)predicateType));
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return this.pattern;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            String value = (String)captures.get(BINARY_FUNCTION_VALUE);
            ExpressionContext predicateExpression = (ExpressionContext)captures.get(PREDICATE_EXPRESSION);
            return String.format("%s(%s, %s)", this.functionName, PinotSqlFormatter.formatExpression(predicateExpression, context), PinotSqlFormatter.singleQuoteValue(value));
        }
    }

    private static class ExpressionOnlyPredicate
    implements Rule<Predicate> {
        private static final Capture<ExpressionContext> PREDICATE_EXPRESSION = Capture.newCapture();
        private static final Pattern<Predicate> PREDICATE_PATTERN = PinotPatterns.predicate().with(PinotPatterns.predicateExpression().capturedAs(PREDICATE_EXPRESSION));
        private final Pattern<Predicate> pattern;
        private final String operator;

        public ExpressionOnlyPredicate(Predicate.Type predicateType, String operator) {
            Objects.requireNonNull(predicateType, "predicateType is null");
            this.operator = Objects.requireNonNull(operator, "operator is null");
            this.pattern = PREDICATE_PATTERN.with(PinotPatterns.predicateType().equalTo((Object)predicateType));
        }

        @Override
        public Pattern<Predicate> getPattern() {
            return this.pattern;
        }

        @Override
        public String formatToSql(Predicate object, Captures captures, Context context) {
            ExpressionContext predicateExpression = (ExpressionContext)captures.get(PREDICATE_EXPRESSION);
            return String.format("%s %s", PinotSqlFormatter.formatExpression(predicateExpression, context), this.operator);
        }
    }

    private static class CaseFunctionRule
    implements Rule<FunctionContext> {
        private static final Capture<List<ExpressionContext>> ARGUMENTS = Capture.newCapture();
        private static final Pattern<FunctionContext> PATTERN = PinotPatterns.transformFunction().with(PinotPatterns.transformFunctionType().equalTo((Object)TransformFunctionType.CASE)).with(PinotPatterns.arguments().capturedAs(ARGUMENTS));

        private CaseFunctionRule() {
        }

        @Override
        public Pattern<FunctionContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FunctionContext object, Captures captures, Context context) {
            List arguments = (List)((List)captures.get(ARGUMENTS)).stream().map(expressionContext -> PinotSqlFormatter.formatExpression(expressionContext, context)).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((arguments.size() >= 2 ? 1 : 0) != 0, (String)"Unexpected expression '%s'", (Object)object);
            int whenStatements = arguments.size() / 2;
            StringBuilder builder = new StringBuilder("CASE ");
            builder.append("WHEN ").append((String)arguments.get(0)).append(" THEN ").append((String)arguments.get(whenStatements));
            for (int index = 1; index < whenStatements; ++index) {
                builder.append(" WHEN ").append((String)arguments.get(index)).append(" THEN ").append((String)arguments.get(index + whenStatements));
            }
            if (arguments.size() % 2 != 0) {
                builder.append(" ELSE ").append((String)arguments.get(arguments.size() - 1));
            }
            return builder.append(" END").toString();
        }
    }

    private static class CastFunctionRule
    implements Rule<FunctionContext> {
        private static final Capture<ExpressionContext> FIRST_ARGUMENT = Capture.newCapture();
        private static final Capture<ExpressionContext> SECOND_ARGUMENT = Capture.newCapture();
        private static final Pattern<FunctionContext> PATTERN = PinotPatterns.binaryFunction().with(PinotPatterns.transformFunctionType().equalTo((Object)TransformFunctionType.CAST)).with(PinotPatterns.firstArgument().capturedAs(FIRST_ARGUMENT)).with(PinotPatterns.secondArgument().capturedAs(SECOND_ARGUMENT));

        private CastFunctionRule() {
        }

        @Override
        public Pattern<FunctionContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FunctionContext object, Captures captures, Context context) {
            ExpressionContext first = (ExpressionContext)captures.get(FIRST_ARGUMENT);
            ExpressionContext second = (ExpressionContext)captures.get(SECOND_ARGUMENT);
            return String.format("CAST(%s AS %s)", PinotSqlFormatter.formatExpression(first, context), PinotSqlFormatter.stripQuotes(PinotSqlFormatter.formatExpression(second, context)));
        }
    }

    private static class CountStarFunctionRule
    implements Rule<FunctionContext> {
        private static final Pattern<FunctionContext> PATTERN = PinotPatterns.aggregationFunction().with(PinotPatterns.aggregationFunctionType().equalTo((Object)AggregationFunctionType.COUNT)).with(PinotPatterns.singleInput().matching(PinotPatterns.expression().with(PinotPatterns.expressionType().equalTo((Object)ExpressionContext.Type.IDENTIFIER)).with(PinotPatterns.identifier().equalTo((Object)"*"))));

        private CountStarFunctionRule() {
        }

        @Override
        public Pattern<FunctionContext> getPattern() {
            return PATTERN;
        }

        @Override
        public String formatToSql(FunctionContext object, Captures captures, Context context) {
            return String.format("%s(%s)", object.getFunctionName(), "*");
        }
    }
}

