/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.util.Arrays;
import java.util.Objects;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockEquals {
    private DataBlockEquals() {
    }

    public static boolean equals(DataBlock left, DataBlock right) {
        return DataBlockEquals.equals(left, right, DefaultContentComparator.INSTANCE);
    }

    public static boolean equals(DataBlock left, DataBlock right, ContentComparator contentComparator) {
        return DataBlockEquals.sameType(left, right) && DataBlockEquals.sameSchema(left, right) && DataBlockEquals.sameContent(left, right, contentComparator);
    }

    public static boolean sameType(DataBlock left, DataBlock right) {
        return left.getDataBlockType() == right.getDataBlockType();
    }

    public static boolean sameSchema(DataBlock left, DataBlock right) {
        return Objects.equals(left.getDataSchema(), right.getDataSchema());
    }

    public static boolean sameContent(DataBlock left, DataBlock right) {
        return DataBlockEquals.sameContent(left, right, DefaultContentComparator.INSTANCE);
    }

    public static boolean sameContent(DataBlock left, DataBlock right, ContentComparator contentComparator) {
        return contentComparator.equals(left, right);
    }

    public static void checkSameContent(DataBlock left, DataBlock right, String message) {
        try {
            DataBlockEquals.sameContent(left, right, DefaultContentComparator.CHECKER);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    public static void checkSameContent(DataBlock left, DataBlock right, String message, ContentComparator contentComparator) {
        try {
            if (!DataBlockEquals.sameContent(left, right, contentComparator)) {
                throw new IllegalArgumentException("Different content: " + left + " and " + right + ". Content comparator " + contentComparator.getClass() + " didn't notify the reason for the difference.");
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    public static class DefaultContentComparator
    implements ContentComparator {
        private final boolean _failOnFalse;
        public static final DefaultContentComparator INSTANCE = new DefaultContentComparator(false);
        public static final DefaultContentComparator CHECKER = new DefaultContentComparator(true);

        private DefaultContentComparator(boolean failOnFalse) {
            this._failOnFalse = failOnFalse;
        }

        @Override
        public boolean equals(DataBlock left, DataBlock right) {
            DataBlock.Type leftType = left.getDataBlockType();
            DataBlock.Type rightType = right.getDataBlockType();
            if (leftType == DataBlock.Type.METADATA) {
                if (rightType != DataBlock.Type.METADATA) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different types: " + leftType + " and " + rightType);
                    }
                    return false;
                }
                if (!Objects.equals(left.getExceptions(), right.getExceptions())) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different exceptions: " + left.getExceptions() + " and " + right.getExceptions());
                    }
                    return false;
                }
                if (!Objects.equals(left.getStatsByStage(), right.getStatsByStage())) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different statsByStage: " + left.getStatsByStage() + " and " + right.getStatsByStage());
                    }
                    return false;
                }
            } else {
                if (rightType == DataBlock.Type.METADATA) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different types: " + leftType + " and " + rightType);
                    }
                    return false;
                }
                DataSchema dataSchema = left.getDataSchema();
                assert (dataSchema != null);
                if (!dataSchema.equals(right.getDataSchema())) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different data schemas: " + dataSchema + " and " + right.getDataSchema());
                    }
                    return false;
                }
                if (left.getNumberOfRows() != right.getNumberOfRows()) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different number of rows: " + left.getNumberOfRows() + " and " + right.getNumberOfRows());
                    }
                    return false;
                }
                int numRows = left.getNumberOfRows();
                if (left.getNumberOfColumns() != right.getNumberOfColumns()) {
                    if (this._failOnFalse) {
                        throw new IllegalArgumentException("Different number of columns: " + left.getNumberOfColumns() + " and " + right.getNumberOfColumns());
                    }
                    return false;
                }
                DataSchema.ColumnDataType[] colTypes = dataSchema.getColumnDataTypes();
                String[] colNames = dataSchema.getColumnNames();
                block16: for (int colId = 0; colId < colNames.length; ++colId) {
                    RoaringBitmap rightNulls;
                    RoaringBitmap leftNulls = left.getNullRowIds(colId);
                    if (!Objects.equals(leftNulls, rightNulls = right.getNullRowIds(colId))) {
                        if (this._failOnFalse) {
                            throw new IllegalArgumentException("Different nulls for column: " + colNames[colId] + " left: " + leftNulls + " right: " + rightNulls);
                        }
                        return false;
                    }
                    switch (colTypes[colId]) {
                        case INT: 
                        case BOOLEAN: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getInt(did, colId) == right.getInt(did, colId)) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getInt(did, colId) + " right: " + right.getInt(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case LONG: 
                        case TIMESTAMP: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getLong(did, colId) == right.getLong(did, colId)) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getLong(did, colId) + " right: " + right.getLong(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case FLOAT: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getFloat(did, colId) == right.getFloat(did, colId)) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getFloat(did, colId) + " right: " + right.getFloat(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case DOUBLE: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getDouble(did, colId) == right.getDouble(did, colId)) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getDouble(did, colId) + " right: " + right.getDouble(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case STRING: 
                        case JSON: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getString(did, colId).equals(right.getString(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getString(did, colId) + " right: " + right.getString(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case BYTES: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getBytes(did, colId).equals((Object)right.getBytes(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getBytes(did, colId) + " right: " + right.getBytes(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case BIG_DECIMAL: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (left.getBigDecimal(did, colId).equals(right.getBigDecimal(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getBigDecimal(did, colId) + " right: " + right.getBigDecimal(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case OBJECT: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Objects.equals(left.getCustomObject(did, colId), right.getCustomObject(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + left.getCustomObject(did, colId) + " right: " + right.getCustomObject(did, colId));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case INT_ARRAY: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Arrays.equals(left.getIntArray(did, colId), right.getIntArray(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + Arrays.toString(left.getIntArray(did, colId)) + " right: " + Arrays.toString(right.getIntArray(did, colId)));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case LONG_ARRAY: 
                        case TIMESTAMP_ARRAY: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Arrays.equals(left.getLongArray(did, colId), right.getLongArray(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + Arrays.toString(left.getLongArray(did, colId)) + " right: " + Arrays.toString(right.getLongArray(did, colId)));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case FLOAT_ARRAY: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Arrays.equals(left.getFloatArray(did, colId), right.getFloatArray(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + Arrays.toString(left.getFloatArray(did, colId)) + " right: " + Arrays.toString(right.getFloatArray(did, colId)));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case DOUBLE_ARRAY: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Arrays.equals(left.getDoubleArray(did, colId), right.getDoubleArray(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + Arrays.toString(left.getDoubleArray(did, colId)) + " right: " + Arrays.toString(right.getDoubleArray(did, colId)));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case STRING_ARRAY: {
                            int did;
                            for (did = 0; did < numRows; ++did) {
                                if (Arrays.equals(left.getStringArray(did, colId), right.getStringArray(did, colId))) continue;
                                if (this._failOnFalse) {
                                    throw new IllegalArgumentException("Different values for " + colTypes[colId] + " column: " + colNames[colId] + " left: " + Arrays.toString(left.getStringArray(did, colId)) + " right: " + Arrays.toString(right.getStringArray(did, colId)));
                                }
                                return false;
                            }
                            continue block16;
                        }
                        case BYTES_ARRAY: 
                        case BOOLEAN_ARRAY: 
                        case UNKNOWN: {
                            throw new UnsupportedOperationException("Check how to read " + colTypes[colId] + " from data block");
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported column type: " + colTypes[colId]);
                        }
                    }
                }
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface ContentComparator {
        public boolean equals(DataBlock var1, DataBlock var2);

        default public ContentComparator andThen(ContentComparator other) {
            return (left, right) -> this.equals(left, right) && other.equals(left, right);
        }
    }
}

