/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockSerde;
import org.apache.pinot.common.datablock.MetadataBlock;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.spi.memory.CompoundDataBuffer;
import org.apache.pinot.segment.spi.memory.DataBuffer;
import org.apache.pinot.segment.spi.memory.PagedPinotOutputStream;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotInputStream;
import org.apache.pinot.segment.spi.memory.PinotOutputStream;

public class ZeroCopyDataBlockSerde
implements DataBlockSerde {
    private final PagedPinotOutputStream.PageAllocator _allocator;

    public ZeroCopyDataBlockSerde() {
        this._allocator = PagedPinotOutputStream.HeapPageAllocator.createSmall();
    }

    public ZeroCopyDataBlockSerde(PagedPinotOutputStream.PageAllocator allocator) {
        this._allocator = allocator;
    }

    @Override
    public DataBuffer serialize(DataBlock dataBlock, int firstInt) throws IOException {
        DataBuffer varSizeData;
        Header header = new Header(firstInt, dataBlock.getNumberOfRows(), dataBlock.getNumberOfColumns());
        CompoundDataBuffer.Builder builder = new CompoundDataBuffer.Builder(ByteOrder.BIG_ENDIAN, false);
        ByteBuffer headerBuffer = ByteBuffer.allocate(52);
        builder.addBuffer((DataBuffer)PinotByteBuffer.wrap((ByteBuffer)headerBuffer));
        try (PagedPinotOutputStream into = new PagedPinotOutputStream(this._allocator);){
            this.serializeExceptions(dataBlock, (PinotOutputStream)into);
            header._exceptionsLength = (int)into.getCurrentOffset();
            ZeroCopyDataBlockSerde.serializeDictionary(dataBlock, (PinotOutputStream)into);
            header._dictionaryLength = (int)into.getCurrentOffset() - header._exceptionsLength;
            ZeroCopyDataBlockSerde.serializeDataSchema(dataBlock, (PinotOutputStream)into);
            header._dataSchemaLength = (int)into.getCurrentOffset() - header._exceptionsLength - header._dictionaryLength;
            builder.addPagedOutputStream(into);
        }
        DataBuffer fixedData = dataBlock.getFixedData();
        if (fixedData != null) {
            builder.addBuffer(fixedData);
            header._fixedSizeDataLength = (int)fixedData.size();
        }
        if ((varSizeData = dataBlock.getVarSizeData()) != null) {
            builder.addBuffer(varSizeData);
            header._variableSizeDataLength = (int)varSizeData.size();
        }
        try (PagedPinotOutputStream into = new PagedPinotOutputStream(this._allocator);){
            ZeroCopyDataBlockSerde.serializeMetadata(dataBlock, (PinotOutputStream)into, header);
            builder.addPagedOutputStream(into);
        }
        header.updateStarts();
        header.serialize(headerBuffer);
        headerBuffer.flip();
        return builder.build();
    }

    private void serializeExceptions(DataBlock dataBlock, PinotOutputStream into) throws IOException {
        Map<Integer, String> errCodeToExceptionMap = dataBlock.getExceptions();
        if (errCodeToExceptionMap == null || errCodeToExceptionMap.isEmpty()) {
            return;
        }
        into.writeInt(errCodeToExceptionMap.size());
        for (Map.Entry<Integer, String> entry : errCodeToExceptionMap.entrySet()) {
            into.writeInt(entry.getKey().intValue());
            into.writeInt4String(entry.getValue());
        }
    }

    private static void serializeDictionary(DataBlock dataBlock, PinotOutputStream into) throws IOException {
        String[] stringDictionary = dataBlock.getStringDictionary();
        if (stringDictionary == null) {
            return;
        }
        into.writeInt(stringDictionary.length);
        for (String entry : stringDictionary) {
            into.writeInt4String(entry);
        }
    }

    private static void serializeDataSchema(DataBlock dataBlock, PinotOutputStream into) throws IOException {
        DataSchema dataSchema = dataBlock.getDataSchema();
        if (dataSchema == null) {
            return;
        }
        byte[] bytes = dataSchema.toBytes();
        into.write(bytes);
    }

    private static void serializeMetadata(DataBlock dataBlock, PinotOutputStream into, Header header) throws IOException {
        header._metadataStart = (int)into.getCurrentOffset();
        if (!(dataBlock instanceof MetadataBlock)) {
            into.writeInt(0);
            return;
        }
        List<DataBuffer> statsByStage = dataBlock.getStatsByStage();
        if (statsByStage == null) {
            into.writeInt(0);
            return;
        }
        int size = statsByStage.size();
        into.writeInt(size);
        if (size > 0) {
            for (DataBuffer stat : statsByStage) {
                if (stat == null) {
                    into.writeBoolean(false);
                    continue;
                }
                into.writeBoolean(true);
                if (stat.size() > Integer.MAX_VALUE) {
                    throw new IOException("Stat size is too large to serialize");
                }
                into.writeInt((int)stat.size());
                into.write(stat);
            }
        }
    }

    @Override
    public DataBlock deserialize(DataBuffer buffer, long offset, DataBlock.Type type, @Nullable LongConsumer finalOffsetConsumer) throws IOException {
        try (PinotInputStream stream = buffer.openInputStream(offset);){
            Header header = Header.deserialize((DataInput)stream);
            if (finalOffsetConsumer != null) {
                finalOffsetConsumer.accept(offset + this.calculateEndOffset(buffer, header));
            }
            switch (type) {
                case COLUMNAR: {
                    ColumnarDataBlock columnarDataBlock = new ColumnarDataBlock(header._numRows, ZeroCopyDataBlockSerde.deserializeDataSchema(stream, header), ZeroCopyDataBlockSerde.deserializeDictionary(stream, header), this.bufferView(buffer, (long)header._fixedSizeDataStart + offset, header._fixedSizeDataLength), this.bufferView(buffer, (long)header._variableSizeDataStart + offset, header._variableSizeDataLength));
                    return columnarDataBlock;
                }
                case ROW: {
                    RowDataBlock rowDataBlock = new RowDataBlock(header._numRows, ZeroCopyDataBlockSerde.deserializeDataSchema(stream, header), ZeroCopyDataBlockSerde.deserializeDictionary(stream, header), this.bufferView(buffer, (long)header._fixedSizeDataStart + offset, header._fixedSizeDataLength), this.bufferView(buffer, (long)header._variableSizeDataStart + offset, header._variableSizeDataLength));
                    return rowDataBlock;
                }
                case METADATA: {
                    Map<Integer, String> exceptions = ZeroCopyDataBlockSerde.deserializeExceptions(stream, header);
                    if (!exceptions.isEmpty()) {
                        MetadataBlock metadataBlock = MetadataBlock.newError(exceptions);
                        return metadataBlock;
                    }
                    List<DataBuffer> metadata = ZeroCopyDataBlockSerde.deserializeMetadata(buffer, header);
                    MetadataBlock metadataBlock = new MetadataBlock(metadata);
                    return metadataBlock;
                }
            }
            throw new UnsupportedOperationException("Unsupported data table version: " + this.getVersion() + " with type: " + type);
        }
    }

    private static List<DataBuffer> deserializeMetadata(DataBuffer buffer, Header header) {
        long currentOffset = header._metadataStart;
        int statsSize = buffer.getInt(currentOffset);
        currentOffset += 4L;
        ArrayList<DataBuffer> stats = new ArrayList<DataBuffer>(statsSize);
        for (int i = 0; i < statsSize; ++i) {
            boolean isPresent = buffer.getByte(currentOffset) != 0;
            ++currentOffset;
            if (isPresent) {
                int length = buffer.getInt(currentOffset);
                stats.add(buffer.view(currentOffset += 4L, currentOffset + (long)length));
                currentOffset += (long)length;
                continue;
            }
            stats.add(null);
        }
        return stats;
    }

    private long calculateEndOffset(DataBuffer buffer, Header header) {
        long currentOffset = header._metadataStart;
        int statsSize = buffer.getInt(currentOffset);
        currentOffset += 4L;
        for (int i = 0; i < statsSize; ++i) {
            boolean isPresent = buffer.getByte(currentOffset) != 0;
            ++currentOffset;
            if (!isPresent) continue;
            int length = buffer.getInt(currentOffset);
            currentOffset += 4L;
            currentOffset += (long)length;
        }
        return currentOffset;
    }

    @VisibleForTesting
    static Map<Integer, String> deserializeExceptions(PinotInputStream stream, Header header) throws IOException {
        if (header._exceptionsLength == 0) {
            return new HashMap<Integer, String>();
        }
        stream.seek((long)header.getExceptionsStart());
        int numExceptions = stream.readInt();
        HashMap<Integer, String> exceptions = new HashMap<Integer, String>(HashUtil.getHashMapCapacity(numExceptions));
        for (int i = 0; i < numExceptions; ++i) {
            int errCode = stream.readInt();
            String errMessage = stream.readInt4UTF();
            exceptions.put(errCode, errMessage);
        }
        return exceptions;
    }

    private DataBuffer bufferView(DataBuffer buffer, long offset, int length) {
        if (length == 0) {
            return PinotByteBuffer.empty();
        }
        return buffer.view(offset, offset + (long)length, ByteOrder.BIG_ENDIAN);
    }

    private static String[] deserializeDictionary(PinotInputStream stream, Header header) throws IOException {
        if (header._dictionaryLength == 0) {
            return new String[0];
        }
        stream.seek((long)header._dictionaryStart);
        int dictionarySize = stream.readInt();
        String[] stringDictionary = new String[dictionarySize];
        for (int i = 0; i < dictionarySize; ++i) {
            stringDictionary[i] = stream.readInt4UTF();
        }
        return stringDictionary;
    }

    private static DataSchema deserializeDataSchema(PinotInputStream stream, Header header) throws IOException {
        if (header._dataSchemaLength == 0) {
            return null;
        }
        stream.seek((long)header._dataSchemaStart);
        return DataSchema.fromBytes(stream);
    }

    @Override
    public DataBlockSerde.Version getVersion() {
        return DataBlockSerde.Version.V1_V2;
    }

    static class Header {
        static final int BYTES = 52;
        int _firstInt;
        int _numRows;
        int _numColumns;
        int _exceptionsLength;
        int _dictionaryStart;
        int _dictionaryLength;
        int _dataSchemaStart;
        int _dataSchemaLength;
        int _fixedSizeDataStart;
        int _fixedSizeDataLength;
        int _variableSizeDataStart;
        int _variableSizeDataLength;
        int _metadataStart;

        public Header(int firstInt, int numRows, int numColumns) {
            this._firstInt = firstInt;
            this._numRows = numRows;
            this._numColumns = numColumns;
        }

        public Header(int firstInt, int numRows, int numColumns, int exceptionsLength, int dictionaryStart, int dictionaryLength, int dataSchemaStart, int dataSchemaLength, int fixedSizeDataStart, int fixedSizeDataLength, int variableSizeDataStart, int variableSizeDataLength, int metadataStart) {
            this._firstInt = firstInt;
            this._numRows = numRows;
            this._numColumns = numColumns;
            this._exceptionsLength = exceptionsLength;
            this._dictionaryStart = dictionaryStart;
            this._dictionaryLength = dictionaryLength;
            this._dataSchemaStart = dataSchemaStart;
            this._dataSchemaLength = dataSchemaLength;
            this._fixedSizeDataStart = fixedSizeDataStart;
            this._fixedSizeDataLength = fixedSizeDataLength;
            this._variableSizeDataStart = variableSizeDataStart;
            this._variableSizeDataLength = variableSizeDataLength;
            this._metadataStart = metadataStart;
        }

        public void serialize(ByteBuffer into) {
            Preconditions.checkState((into.remaining() >= 52 ? 1 : 0) != 0, (Object)"Buffer does not have enough space to serialize the header");
            into.putInt(this._firstInt);
            into.putInt(this._numRows);
            into.putInt(this._numColumns);
            into.putInt(52);
            into.putInt(this._exceptionsLength);
            into.putInt(this._dictionaryStart);
            into.putInt(this._dictionaryLength);
            into.putInt(this._dataSchemaStart);
            into.putInt(this._dataSchemaLength);
            into.putInt(this._fixedSizeDataStart);
            into.putInt(this._fixedSizeDataLength);
            into.putInt(this._variableSizeDataStart);
            into.putInt(this._variableSizeDataLength);
        }

        public static Header deserialize(DataInput input) throws IOException {
            int firstInt = input.readInt();
            int numRows = input.readInt();
            int numCols = input.readInt();
            input.skipBytes(4);
            int exceptionsLength = input.readInt();
            int dictionaryStart = input.readInt();
            int dictionaryLength = input.readInt();
            int dataSchemaStart = input.readInt();
            int dataSchemaLength = input.readInt();
            int fixedSizeDataStart = input.readInt();
            int fixedSizeDataLength = input.readInt();
            int variableSizeDataStart = input.readInt();
            int variableSizeDataLength = input.readInt();
            int metadataStart = variableSizeDataStart + variableSizeDataLength;
            return new Header(firstInt, numRows, numCols, exceptionsLength, dictionaryStart, dictionaryLength, dataSchemaStart, dataSchemaLength, fixedSizeDataStart, fixedSizeDataLength, variableSizeDataStart, variableSizeDataLength, metadataStart);
        }

        public String toString() {
            return "Header{_numRows=" + this._numRows + ", _numColumns=" + this._numColumns + ", _exceptionsLength=" + this._exceptionsLength + ", _dictionaryStart=" + this._dictionaryStart + ", _dictionaryLength=" + this._dictionaryLength + ", _dataSchemaStart=" + this._dataSchemaStart + ", _dataSchemaLength=" + this._dataSchemaLength + ", _fixedSizeDataStart=" + this._fixedSizeDataStart + ", _fixedSizeDataLength=" + this._fixedSizeDataLength + ", _variableSizeDataStart=" + this._variableSizeDataStart + ", _variableSizeDataLength=" + this._variableSizeDataLength + ", _metadataStart=" + this._metadataStart + "}";
        }

        public void updateStarts() {
            this._dictionaryStart = 52 + this._exceptionsLength;
            this._dataSchemaStart = this._dictionaryStart + this._dictionaryLength;
            this._fixedSizeDataStart = this._dataSchemaStart + this._dataSchemaLength;
            this._variableSizeDataStart = this._fixedSizeDataStart + this._fixedSizeDataLength;
            this._metadataStart = this._variableSizeDataStart + this._variableSizeDataLength;
        }

        public int getFirstInt() {
            return this._firstInt;
        }

        public int getNumRows() {
            return this._numRows;
        }

        public int getNumColumns() {
            return this._numColumns;
        }

        public int getExceptionsStart() {
            return 52;
        }

        public int getExceptionsLength() {
            return this._exceptionsLength;
        }

        public int getDictionaryStart() {
            return this._dictionaryStart;
        }

        public int getDictionaryLength() {
            return this._dictionaryLength;
        }

        public int getDataSchemaStart() {
            return this._dataSchemaStart;
        }

        public int getDataSchemaLength() {
            return this._dataSchemaLength;
        }

        public int getFixedSizeDataStart() {
            return this._fixedSizeDataStart;
        }

        public int getFixedSizeDataLength() {
            return this._fixedSizeDataLength;
        }

        public int getVariableSizeDataStart() {
            return this._variableSizeDataStart;
        }

        public int getVariableSizeDataLength() {
            return this._variableSizeDataLength;
        }

        public int getMetadataStart() {
            return this._metadataStart;
        }
    }
}

